/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.support.csv;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import shade.com.alibaba.fastjson2.JSONException;
import shade.com.alibaba.fastjson2.JSONFactory;
import shade.com.alibaba.fastjson2.reader.CharArrayValueConsumer;
import shade.com.alibaba.fastjson2.reader.FieldReader;
import shade.com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import shade.com.alibaba.fastjson2.reader.ObjectReaderProvider;
import shade.com.alibaba.fastjson2.stream.StreamReader;
import shade.com.alibaba.fastjson2.support.csv.CSVReader;
import shade.com.alibaba.fastjson2.util.DateUtils;
import shade.com.alibaba.fastjson2.util.Fnv;
import shade.com.alibaba.fastjson2.util.IOUtils;
import shade.com.alibaba.fastjson2.util.TypeUtils;

final class CSVReaderUTF16<T>
extends CSVReader<T> {
    static final Map<Long, Function<Consumer, CharArrayValueConsumer>> valueConsumerCreators = new ConcurrentHashMap<Long, Function<Consumer, CharArrayValueConsumer>>();
    CharArrayValueConsumer valueConsumer;
    char[] buf;
    Reader input;

    CSVReaderUTF16(StreamReader.Feature ... features) {
        for (StreamReader.Feature feature : features) {
            this.features |= feature.mask;
        }
    }

    CSVReaderUTF16(Reader input, Class<T> objectClass) {
        super(objectClass);
        this.input = input;
    }

    CSVReaderUTF16(Reader input, CharArrayValueConsumer valueConsumer) {
        this.valueConsumer = valueConsumer;
        this.input = input;
    }

    CSVReaderUTF16(Reader input, Type[] types) {
        super(types);
        this.input = input;
    }

    CSVReaderUTF16(char[] bytes, int off, int len, Class<T> objectClass) {
        super(objectClass);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
    }

    CSVReaderUTF16(char[] bytes, int off, int len, CharArrayValueConsumer valueConsumer) {
        this.valueConsumer = valueConsumer;
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
    }

    CSVReaderUTF16(char[] bytes, int off, int len, Type[] types) {
        super(types);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
    }

    @Override
    protected boolean seekLine() throws IOException {
        char[] buf = this.buf;
        int off = this.off;
        if (buf == null && this.input != null) {
            this.buf = new char[524288];
            buf = this.buf;
            int cnt = this.input.read(buf);
            if (cnt == -1) {
                this.inputEnd = true;
                return false;
            }
            this.end = cnt;
        }
        for (int k = 0; k < 3; ++k) {
            this.lineTerminated = false;
            for (int i = off; i < this.end; ++i) {
                int n;
                char ch;
                if (i + 4 < this.end) {
                    char b0 = buf[i];
                    char b1 = buf[i + 1];
                    char b2 = buf[i + 2];
                    char b3 = buf[i + 3];
                    if (b0 > '\"' && b1 > '\"' && b2 > '\"' && b3 > '\"') {
                        this.lineSize += 4;
                        i += 3;
                        continue;
                    }
                }
                if ((ch = buf[i]) == '\"') {
                    ++this.lineSize;
                    if (!this.quote) {
                        this.quote = true;
                        continue;
                    }
                    n = i + 1;
                    if (n >= this.end) break;
                    if (buf[n] == '\"') {
                        ++this.lineSize;
                        ++i;
                        continue;
                    }
                    this.quote = false;
                    continue;
                }
                if (this.quote) {
                    ++this.lineSize;
                    continue;
                }
                if (ch == '\n') {
                    if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                        ++this.rowCount;
                    }
                    this.lineTerminated = true;
                    this.lineSize = 0;
                    this.lineEnd = i;
                    this.lineStart = this.lineNextStart;
                    this.lineNextStart = off = i + 1;
                    break;
                }
                if (ch == '\r') {
                    if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                        ++this.rowCount;
                    }
                    this.lineTerminated = true;
                    this.lineSize = 0;
                    this.lineEnd = i;
                    n = i + 1;
                    if (n >= this.end) break;
                    if (buf[n] == '\n') {
                        ++i;
                    }
                    this.lineStart = this.lineNextStart;
                    this.lineNextStart = off = i + 1;
                    break;
                }
                ++this.lineSize;
            }
            if (!this.lineTerminated) {
                if (this.input != null && !this.inputEnd) {
                    int cnt;
                    int len = this.end - off;
                    if (off > 0) {
                        if (len > 0) {
                            System.arraycopy(buf, off, buf, 0, len);
                        }
                        this.lineNextStart = 0;
                        this.lineStart = 0;
                        off = 0;
                        this.end = len;
                        this.quote = false;
                    }
                    if ((cnt = this.input.read(buf, this.end, buf.length - this.end)) == -1) {
                        this.inputEnd = true;
                        if (off == this.end) {
                            this.off = off;
                            return false;
                        }
                    } else {
                        this.end += cnt;
                        continue;
                    }
                }
                this.lineStart = this.lineNextStart;
                this.lineEnd = this.end;
                ++this.rowCount;
                this.lineSize = 0;
                off = this.end;
            }
            this.lineTerminated = off == this.end;
            break;
        }
        this.off = off;
        return true;
    }

    Object readValue(char[] chars, int off, int len, Type type) {
        if (len == 0) {
            return null;
        }
        if (type == Integer.class) {
            return TypeUtils.parseInt(chars, off, len);
        }
        if (type == Long.class) {
            return TypeUtils.parseLong(chars, off, len);
        }
        if (type == BigDecimal.class) {
            return TypeUtils.parseBigDecimal(chars, off, len);
        }
        if (type == Float.class) {
            return Float.valueOf(TypeUtils.parseFloat(chars, off, len));
        }
        if (type == Double.class) {
            return TypeUtils.parseDouble(chars, off, len);
        }
        if (type == Date.class) {
            long millis = DateUtils.parseMillis(chars, off, len, DateUtils.DEFAULT_ZONE_ID);
            return new Date(millis);
        }
        if (type == Boolean.class) {
            return TypeUtils.parseBoolean(chars, off, len);
        }
        String str = new String(chars, off, len);
        return TypeUtils.cast((Object)str, type);
    }

    @Override
    public boolean isEnd() {
        return this.inputEnd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] readLineValues(boolean strings) {
        ArrayList<Object> valueList;
        Object[] values;
        block57: {
            Object value;
            int columnIndex;
            block53: {
                Type type;
                int valueSize;
                int valueStart;
                block58: {
                    try {
                        if (this.inputEnd) {
                            return null;
                        }
                        if (this.input == null && this.off >= this.end) {
                            return null;
                        }
                        boolean result = this.seekLine();
                        if (!result) {
                            return null;
                        }
                    }
                    catch (IOException e) {
                        throw new JSONException("seekLine error", e);
                    }
                    values = null;
                    valueList = null;
                    if (this.columns != null) {
                        values = strings ? new String[this.columns.size()] : new Object[this.columns.size()];
                    }
                    boolean quote = false;
                    valueStart = this.lineStart;
                    valueSize = 0;
                    int escapeCount = 0;
                    columnIndex = 0;
                    for (int i = this.lineStart; i < this.lineEnd; ++i) {
                        block55: {
                            Object value2;
                            block52: {
                                Type type2;
                                block56: {
                                    char ch;
                                    block51: {
                                        block54: {
                                            ch = this.buf[i];
                                            if (!quote) break block54;
                                            if (ch == '\"') {
                                                int n = i + 1;
                                                if (n < this.lineEnd) {
                                                    char c1 = this.buf[n];
                                                    if (c1 == '\"') {
                                                        valueSize += 2;
                                                        ++escapeCount;
                                                        ++i;
                                                        continue;
                                                    }
                                                    if (c1 == ',') {
                                                        ++i;
                                                        ch = c1;
                                                    }
                                                    break block51;
                                                } else if (n == this.lineEnd) {
                                                    break;
                                                }
                                                break block51;
                                            } else {
                                                ++valueSize;
                                                continue;
                                            }
                                        }
                                        if (ch == '\"') {
                                            quote = true;
                                            continue;
                                        }
                                    }
                                    if (ch != ',') break block55;
                                    Type type3 = type2 = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
                                    if (!quote) break block56;
                                    if (escapeCount == 0) {
                                        if (type2 == null || type2 == String.class || type2 == Object.class || strings) {
                                            value2 = new String(this.buf, valueStart + 1, valueSize);
                                            break block52;
                                        } else {
                                            try {
                                                value2 = this.readValue(this.buf, valueStart + 1, valueSize, type2);
                                            }
                                            catch (Exception e) {
                                                value2 = this.error(columnIndex, e);
                                            }
                                        }
                                        break block52;
                                    } else {
                                        char[] chars = new char[valueSize - escapeCount];
                                        int valueEnd = valueStart + valueSize;
                                        int k = 0;
                                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                                            char c = this.buf[j];
                                            chars[k++] = c;
                                            if (c != '\"' || this.buf[j + 1] != '\"') continue;
                                            ++j;
                                        }
                                        if (type2 == null || type2 == String.class || type2 == Object.class || strings) {
                                            value2 = new String(chars);
                                            break block52;
                                        } else {
                                            try {
                                                value2 = this.readValue(chars, 0, chars.length, type2);
                                            }
                                            catch (Exception e) {
                                                value2 = this.error(columnIndex, e);
                                            }
                                        }
                                    }
                                    break block52;
                                }
                                if (type2 == null || type2 == String.class || type2 == Object.class || strings) {
                                    value2 = valueSize == 1 ? TypeUtils.toString(this.buf[valueStart]) : (valueSize == 2 ? TypeUtils.toString(this.buf[valueStart], this.buf[valueStart + 1]) : new String(this.buf, valueStart, valueSize));
                                } else {
                                    try {
                                        value2 = this.readValue(this.buf, valueStart, valueSize, type2);
                                    }
                                    catch (Exception e) {
                                        value2 = this.error(columnIndex, e);
                                    }
                                }
                            }
                            if (values != null) {
                                if (columnIndex < values.length) {
                                    values[columnIndex] = value2;
                                }
                            } else {
                                if (valueList == null) {
                                    valueList = new ArrayList();
                                }
                                valueList.add(value2);
                            }
                            quote = false;
                            valueStart = i + 1;
                            valueSize = 0;
                            escapeCount = 0;
                            ++columnIndex;
                            continue;
                        }
                        ++valueSize;
                    }
                    if (valueSize <= 0 && !quote) break block57;
                    Type type4 = type = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
                    if (!quote) break block58;
                    if (escapeCount == 0) {
                        value = type == null || type == String.class || type == Object.class || strings ? new String(this.buf, valueStart + 1, valueSize) : this.readValue(this.buf, valueStart + 1, valueSize, type);
                        break block53;
                    } else {
                        char[] chars = new char[valueSize - escapeCount];
                        int valueEnd = this.lineEnd;
                        int k = 0;
                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                            char c = this.buf[j];
                            chars[k++] = c;
                            if (c != '\"' || this.buf[j + 1] != '\"') continue;
                            ++j;
                        }
                        if (type == null || type == String.class || type == Object.class || strings) {
                            value = new String(chars);
                            break block53;
                        } else {
                            try {
                                value = this.readValue(chars, 0, chars.length, type);
                            }
                            catch (Exception e) {
                                value = this.error(columnIndex, e);
                            }
                        }
                    }
                    break block53;
                }
                if (type == null || type == String.class || type == Object.class || strings) {
                    value = valueSize == 1 ? TypeUtils.toString(this.buf[valueStart]) : (valueSize == 2 ? TypeUtils.toString(this.buf[valueStart], this.buf[valueStart + 1]) : new String(this.buf, valueStart, valueSize));
                } else {
                    try {
                        value = this.readValue(this.buf, valueStart, valueSize, type);
                    }
                    catch (Exception e) {
                        value = this.error(columnIndex, e);
                    }
                }
            }
            if (values != null) {
                if (columnIndex < values.length) {
                    values[columnIndex] = value;
                }
            } else {
                if (valueList == null) {
                    valueList = new ArrayList<Object>();
                }
                valueList.add(value);
            }
        }
        if (values == null && valueList != null) {
            values = strings ? new String[valueList.size()] : new Object[valueList.size()];
            valueList.toArray(values);
        }
        if (this.input == null && this.off == this.end) {
            this.inputEnd = true;
        }
        return values;
    }

    @Override
    public void close() {
        if (this.input != null) {
            IOUtils.close(this.input);
        }
    }

    @Override
    public void statAll() {
        CharArrayValueConsumer consumer = (row, column, bytes, off, len) -> {
            StreamReader.ColumnStat stat = this.getColumnStat(column);
            stat.stat(bytes, off, len);
        };
        this.readAll(consumer, Integer.MAX_VALUE);
    }

    @Override
    public void statAll(int maxRows) {
        CharArrayValueConsumer consumer = (row, column, bytes, off, len) -> {
            StreamReader.ColumnStat stat = this.getColumnStat(column);
            stat.stat(bytes, off, len);
        };
        this.readAll(consumer, maxRows);
    }

    @Override
    public void readLineObjectAll(boolean readHeader, Consumer<T> consumer) {
        if (readHeader) {
            this.readHeader();
        }
        if (this.fieldReaders == null) {
            Object[] line;
            while ((line = this.readLineValues(false)) != null) {
                consumer.accept(line);
            }
            return;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        if (this.fieldReaders == null && this.objectClass != null) {
            ObjectReaderAdapter objectReader = (ObjectReaderAdapter)provider.getObjectReader(this.objectClass);
            this.fieldReaders = objectReader.getFieldReaders();
            this.objectCreator = provider.createObjectCreator(this.objectClass, this.features);
        }
        String[] strings = new String[this.fieldReaders.length + 1];
        strings[0] = this.objectClass.getName();
        for (int i = 0; i < this.fieldReaders.length; ++i) {
            strings[i + 1] = this.fieldReaders[i].fieldName;
        }
        long fullNameHash = Fnv.hashCode64(strings);
        Function<Consumer, CharArrayValueConsumer> valueConsumerCreator = valueConsumerCreators.get(fullNameHash);
        if (valueConsumerCreator == null && (valueConsumerCreator = provider.createCharArrayValueConsumerCreator(this.objectClass, this.fieldReaders)) != null) {
            valueConsumerCreators.putIfAbsent(fullNameHash, valueConsumerCreator);
        }
        CharArrayConsumerImpl<T> bytesConsumer = null;
        if (valueConsumerCreator != null) {
            bytesConsumer = valueConsumerCreator.apply(consumer);
        }
        if (bytesConsumer == null) {
            bytesConsumer = new CharArrayConsumerImpl<T>(consumer);
        }
        this.readAll(bytesConsumer, Integer.MAX_VALUE);
    }

    @Override
    public void readAll() {
        if (this.valueConsumer == null) {
            throw new JSONException("unsupported operation, consumer is null");
        }
        this.readAll(this.valueConsumer, Integer.MAX_VALUE);
    }

    @Override
    public void readAll(int maxRows) {
        if (this.valueConsumer == null) {
            throw new JSONException("unsupported operation, consumer is null");
        }
        this.readAll(this.valueConsumer, maxRows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readAll(CharArrayValueConsumer<T> consumer, int maxRows) {
        consumer.start();
        for (int r = 0; r < maxRows || maxRows < 0; ++r) {
            try {
                boolean result;
                if (this.inputEnd || this.input == null && this.off >= this.end || !(result = this.seekLine())) {
                    break;
                }
            }
            catch (IOException e) {
                throw new JSONException("seekLine error", e);
            }
            consumer.beforeRow(this.rowCount);
            boolean quote = false;
            int valueStart = this.lineStart;
            int valueSize = 0;
            int escapeCount = 0;
            int columnIndex = 0;
            for (int i = this.lineStart; i < this.lineEnd; ++i) {
                char ch;
                block25: {
                    block28: {
                        ch = this.buf[i];
                        if (!quote) break block28;
                        if (ch == '\"') {
                            int n = i + 1;
                            if (n < this.lineEnd) {
                                char c1 = this.buf[n];
                                if (c1 == '\"') {
                                    valueSize += 2;
                                    ++escapeCount;
                                    ++i;
                                    continue;
                                }
                                if (c1 == ',') {
                                    ++i;
                                    ch = c1;
                                }
                                break block25;
                            } else if (n == this.lineEnd) {
                                break;
                            }
                            break block25;
                        } else {
                            ++valueSize;
                            continue;
                        }
                    }
                    if (ch == '\"') {
                        quote = true;
                        continue;
                    }
                }
                if (ch == ',') {
                    if (quote) {
                        if (escapeCount == 0) {
                            consumer.accept(this.rowCount, columnIndex, this.buf, valueStart + 1, valueSize);
                        } else {
                            char[] bytes = new char[valueSize - escapeCount];
                            int valueEnd = valueStart + valueSize;
                            int k = 0;
                            for (int j = valueStart + 1; j < valueEnd; ++j) {
                                char c = this.buf[j];
                                bytes[k++] = c;
                                if (c != '\"' || this.buf[j + 1] != '\"') continue;
                                ++j;
                            }
                            consumer.accept(this.rowCount, columnIndex, bytes, 0, bytes.length);
                        }
                    } else {
                        consumer.accept(this.rowCount, columnIndex, this.buf, valueStart, valueSize);
                    }
                    quote = false;
                    valueStart = i + 1;
                    valueSize = 0;
                    escapeCount = 0;
                    ++columnIndex;
                    continue;
                }
                ++valueSize;
            }
            if (valueSize > 0) {
                if (quote) {
                    if (escapeCount == 0) {
                        consumer.accept(this.rowCount, columnIndex, this.buf, valueStart + 1, valueSize);
                    } else {
                        char[] bytes = new char[valueSize - escapeCount];
                        int valueEnd = this.lineEnd;
                        int k = 0;
                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                            char c = this.buf[j];
                            bytes[k++] = c;
                            if (c != '\"' || this.buf[j + 1] != '\"') continue;
                            ++j;
                        }
                        consumer.accept(this.rowCount, columnIndex, bytes, 0, bytes.length);
                    }
                } else {
                    consumer.accept(this.rowCount, columnIndex, this.buf, valueStart, valueSize);
                }
            }
            consumer.afterRow(this.rowCount);
        }
        consumer.end();
    }

    class CharArrayConsumerImpl<T>
    implements CharArrayValueConsumer {
        protected T object;
        final Consumer<T> consumer;

        public CharArrayConsumerImpl(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public final void beforeRow(int row) {
            if (CSVReaderUTF16.this.objectCreator != null) {
                this.object = CSVReaderUTF16.this.objectCreator.get();
            }
        }

        @Override
        public void accept(int row, int column, char[] bytes, int off, int len) {
            if (column >= CSVReaderUTF16.this.fieldReaders.length || len == 0) {
                return;
            }
            FieldReader fieldReader = CSVReaderUTF16.this.fieldReaders[column];
            Object fieldValue = CSVReaderUTF16.this.readValue(bytes, off, len, fieldReader.fieldType);
            fieldReader.accept(this.object, fieldValue);
        }

        @Override
        public final void afterRow(int row) {
            this.consumer.accept(this.object);
            this.object = null;
        }
    }
}

