/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.spring;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;

public class ConverterBeanListener
implements ApplicationListener<ApplicationContextEvent> {
    private ForestConfiguration forestConfiguration;

    public void onApplicationEvent(ApplicationContextEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        ForestConfiguration forestConfiguration = this.forestConfiguration;
        if (forestConfiguration == null) {
            try {
                forestConfiguration = (ForestConfiguration)applicationContext.getBean(ForestConfiguration.class);
            }
            catch (Exception ignored) {
                throw new ForestRuntimeException("property forestConfiguration undefined", (Throwable)ignored);
            }
        }
        Map forestConverterMap = applicationContext.getBeansOfType(ForestConverter.class);
        for (ForestConverter forestConverter : forestConverterMap.values()) {
            forestConfiguration.getConverterMap().put(forestConverter.getDataType(), forestConverter);
        }
    }

    public ForestConfiguration getForestConfiguration() {
        return this.forestConfiguration;
    }

    public void setForestConfiguration(ForestConfiguration forestConfiguration) {
        this.forestConfiguration = forestConfiguration;
    }
}

