/*
 * Decompiled with CFR 0.152.
 */
package com.github.junit5docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.github.junit5docker.DockerClientAdapter;
import com.github.junit5docker.PortBinding;
import com.github.junit5docker.StreamLog;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class DefaultDockerClient
implements DockerClientAdapter {
    private final DockerClient dockerClient = DockerClientBuilder.getInstance((DefaultDockerClientConfig.Builder)DefaultDockerClientConfig.createDefaultConfigBuilder().withApiVersion("1.22")).build();

    DefaultDockerClient() {
    }

    @Override
    public String startContainer(String wantedImage, Map<String, String> environment, PortBinding ... portBinding) {
        Ports bindings = this.createPortBindings(portBinding);
        List<String> environmentStrings = this.createEnvironmentList(environment);
        String containerId = this.createContainer(wantedImage, bindings, environmentStrings);
        this.dockerClient.startContainerCmd(containerId).exec();
        return containerId;
    }

    @Override
    public void stopAndRemoveContainer(String containerId) {
        this.dockerClient.stopContainerCmd(containerId).exec();
        this.dockerClient.removeContainerCmd(containerId).withRemoveVolumes(Boolean.valueOf(true)).exec();
    }

    @Override
    public Stream<String> logs(String containerId) {
        return ((StreamLog)this.dockerClient.logContainerCmd(containerId).withFollowStream(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).exec((ResultCallback)new StreamLog())).stream();
    }

    private String createContainer(String wantedImage, Ports bindings, List<String> environmentStrings) {
        String imageWithVersion = wantedImage;
        if (!imageWithVersion.contains(":")) {
            imageWithVersion = imageWithVersion + ":latest";
        }
        this.ensureImageExists(imageWithVersion);
        return this.dockerClient.createContainerCmd(imageWithVersion).withEnv(environmentStrings).withPortBindings(bindings).exec().getId();
    }

    private List<String> createEnvironmentList(Map<String, String> environment) {
        return environment.entrySet().stream().map(this::toEnvString).collect(Collectors.toList());
    }

    private Ports createPortBindings(PortBinding ... portBinding) {
        Ports bindings = new Ports();
        for (PortBinding binding : portBinding) {
            ExposedPort inner = ExposedPort.tcp((int)binding.inner);
            bindings.bind(inner, Ports.Binding.bindPort((int)binding.exposed));
        }
        return bindings;
    }

    private String toEnvString(Map.Entry<String, String> environmentEntry) {
        return environmentEntry.getKey() + "=" + environmentEntry.getValue();
    }

    private void ensureImageExists(String wantedImage) {
        try {
            this.dockerClient.inspectImageCmd(wantedImage).exec();
        }
        catch (NotFoundException e) {
            ((PullImageResultCallback)this.dockerClient.pullImageCmd(wantedImage).exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
        }
    }
}

