/*
 * Decompiled with CFR 0.152.
 */
package com.github.junit5docker;

import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.junit5docker.QueueIterator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Spliterators;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class StreamLog
extends LogContainerResultCallback {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final BlockingQueue<String> lines = new ArrayBlockingQueue<String>(1);
    private final QueueIterator queueIterator = new QueueIterator(this.lines);

    StreamLog() {
    }

    public void onNext(Frame item) {
        try {
            this.lines.put(new String(item.getPayload(), UTF_8));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onComplete() {
        super.onComplete();
        this.queueIterator.close();
    }

    public void onError(Throwable throwable) {
        super.onError(throwable);
        this.queueIterator.close();
    }

    public Stream<String> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.queueIterator, 0), false).onClose(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

