/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingOutputStream
extends FilterOutputStream {
    private final ByteArrayOutputStream buf = new ByteArrayOutputStream();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String prefix;

    public LoggingOutputStream(OutputStream out, String prefix) {
        super(out);
        this.prefix = prefix;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.appendToBuffer(b);
        super.write(b);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.logLine();
        super.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.logLine();
        super.close();
    }

    private void appendToBuffer(int b) {
        if (b == 10) {
            this.buf.write(92);
            this.buf.write(110);
        } else if (b == 13) {
            this.buf.write(92);
            this.buf.write(114);
        } else if (b == 9) {
            this.buf.write(92);
            this.buf.write(116);
        } else if (b < 32) {
            this.buf.write(94);
            this.buf.write(64 + b);
        } else {
            this.buf.write(b);
        }
        if (b == 10 || this.isLineLengthExceeded()) {
            this.logLine();
        }
    }

    protected void logLine() {
        if (this.buf.size() > 0) {
            try {
                if (this.isLineLengthExceeded()) {
                    this.buf.write("[WRAP]".getBytes(StandardCharsets.US_ASCII));
                }
                String line = this.buf.toString(StandardCharsets.UTF_8.name());
                this.log.debug(this.prefix + line);
                this.buf.reset();
            }
            catch (IOException e) {
                throw new IllegalStateException("Can not log output stream", e);
            }
        }
    }

    private boolean isLineLengthExceeded() {
        return this.buf.size() > 128;
    }
}

