/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlPageBreak;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlPageBreakType;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IBlockElement;
import java.util.Map;

public class PageBreakApplierUtil {
    private PageBreakApplierUtil() {
    }

    public static void applyPageBreakProperties(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        PageBreakApplierUtil.applyPageBreakInside(cssProps, context, element);
        PageBreakApplierUtil.applyKeepWithNext(cssProps, context, element);
    }

    public static void addPageBreakElementBefore(ProcessorContext context, ITagWorker parentTagWorker, IElementNode childElement, ITagWorker childTagWorker) {
        String pageBreakBeforeVal;
        HtmlPageBreak breakBefore;
        if (("block".equals(childElement.getStyles().get("display")) || childElement.getStyles().get("display") == null && childTagWorker.getElementResult() instanceof IBlockElement) && (breakBefore = PageBreakApplierUtil.createHtmlPageBreak(pageBreakBeforeVal = childElement.getStyles().get("page-break-before"))) != null) {
            parentTagWorker.processTagChild(new HtmlPageBreakWorker(breakBefore), context);
        }
    }

    public static void addPageBreakElementAfter(ProcessorContext context, ITagWorker parentTagWorker, IElementNode childElement, ITagWorker childTagWorker) {
        String pageBreakAfterVal;
        HtmlPageBreak breakAfter;
        if (("block".equals(childElement.getStyles().get("display")) || childElement.getStyles().get("display") == null && childTagWorker.getElementResult() instanceof IBlockElement) && (breakAfter = PageBreakApplierUtil.createHtmlPageBreak(pageBreakAfterVal = childElement.getStyles().get("page-break-after"))) != null) {
            parentTagWorker.processTagChild(new HtmlPageBreakWorker(breakAfter), context);
        }
    }

    private static HtmlPageBreak createHtmlPageBreak(String pageBreakVal) {
        HtmlPageBreak pageBreak = null;
        if ("always".equals(pageBreakVal)) {
            pageBreak = new HtmlPageBreak(HtmlPageBreakType.ALWAYS);
        } else if ("left".equals(pageBreakVal)) {
            pageBreak = new HtmlPageBreak(HtmlPageBreakType.LEFT);
        } else if ("right".equals(pageBreakVal)) {
            pageBreak = new HtmlPageBreak(HtmlPageBreakType.RIGHT);
        }
        return pageBreak;
    }

    private static void applyKeepWithNext(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String pageBreakBefore = cssProps.get("page-break-before");
        String pageBreakAfter = cssProps.get("page-break-after");
        if ("avoid".equals(pageBreakAfter)) {
            element.setProperty(81, (Object)true);
        }
        if ("avoid".equals(pageBreakBefore)) {
            element.setProperty(0x100001, (Object)true);
        }
    }

    private static void applyPageBreakInside(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String pageBreakInsideVal = cssProps.get("page-break-inside");
        if ("avoid".equals(pageBreakInsideVal)) {
            element.setProperty(32, (Object)true);
        }
    }

    private static class HtmlPageBreakWorker
    implements ITagWorker {
        private HtmlPageBreak pageBreak;

        HtmlPageBreakWorker(HtmlPageBreak pageBreak) {
            this.pageBreak = pageBreak;
        }

        @Override
        public void processEnd(IElementNode element, ProcessorContext context) {
        }

        @Override
        public boolean processContent(String content, ProcessorContext context) {
            throw new IllegalStateException();
        }

        @Override
        public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
            throw new IllegalStateException();
        }

        @Override
        public IPropertyContainer getElementResult() {
            return this.pageBreak;
        }
    }
}

