/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OcgPropertiesCopier {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcgPropertiesCopier.class);

    private OcgPropertiesCopier() {
    }

    public static void copyOCGProperties(PdfDocument fromDocument, PdfDocument toDocument, Map<PdfPage, PdfPage> page2page) {
        try {
            PdfDictionary toOcProperties = ((PdfDictionary)toDocument.getCatalog().getPdfObject()).getAsDictionary(PdfName.OCProperties);
            Set<PdfIndirectReference> fromOcgsToCopy = OcgPropertiesCopier.getAllUsedNonFlushedOCGs(page2page, toOcProperties);
            if (fromOcgsToCopy.isEmpty()) {
                return;
            }
            toOcProperties = toDocument.getCatalog().fillAndGetOcPropertiesDictionary();
            PdfDictionary fromOcProperties = ((PdfDictionary)fromDocument.getCatalog().getPdfObject()).getAsDictionary(PdfName.OCProperties);
            OcgPropertiesCopier.copyOCGs(fromOcgsToCopy, toOcProperties, toDocument);
            OcgPropertiesCopier.copyDDictionary(fromOcgsToCopy, fromOcProperties.getAsDictionary(PdfName.D), toOcProperties, toDocument);
        }
        catch (Exception ex) {
            LOGGER.error(MessageFormatUtil.format((String)"OCG copying caused the following exception: {0}.", (Object[])new Object[]{ex.toString()}));
        }
    }

    private static Set<PdfIndirectReference> getAllUsedNonFlushedOCGs(Map<PdfPage, PdfPage> page2page, PdfDictionary toOcProperties) {
        LinkedHashSet<PdfIndirectReference> fromUsedOcgs = new LinkedHashSet<PdfIndirectReference>();
        PdfPage[] fromPages = page2page.keySet().toArray(new PdfPage[0]);
        PdfPage[] toPages = page2page.values().toArray(new PdfPage[0]);
        for (int i = 0; i < toPages.length; ++i) {
            PdfPage fromPage = fromPages[i];
            PdfPage toPage = toPages[i];
            List<PdfAnnotation> toAnnotations = toPage.getAnnotations();
            List<PdfAnnotation> fromAnnotations = fromPage.getAnnotations();
            for (int j = 0; j < toAnnotations.size(); ++j) {
                if (toAnnotations.get(j).isFlushed()) continue;
                PdfDictionary toAnnotDict = (PdfDictionary)toAnnotations.get(j).getPdfObject();
                PdfDictionary fromAnnotDict = (PdfDictionary)fromAnnotations.get(j).getPdfObject();
                PdfAnnotation toAnnot = toAnnotations.get(j);
                PdfAnnotation fromAnnot = fromAnnotations.get(j);
                if (toAnnotDict.isFlushed()) continue;
                OcgPropertiesCopier.getUsedNonFlushedOCGsFromOcDict(toAnnotDict.getAsDictionary(PdfName.OC), fromAnnotDict.getAsDictionary(PdfName.OC), fromUsedOcgs, toOcProperties);
                OcgPropertiesCopier.getUsedNonFlushedOCGsFromXObject(toAnnot.getNormalAppearanceObject(), fromAnnot.getNormalAppearanceObject(), fromUsedOcgs, toOcProperties);
                OcgPropertiesCopier.getUsedNonFlushedOCGsFromXObject(toAnnot.getRolloverAppearanceObject(), fromAnnot.getRolloverAppearanceObject(), fromUsedOcgs, toOcProperties);
                OcgPropertiesCopier.getUsedNonFlushedOCGsFromXObject(toAnnot.getDownAppearanceObject(), fromAnnot.getDownAppearanceObject(), fromUsedOcgs, toOcProperties);
            }
            PdfDictionary toResources = ((PdfDictionary)toPage.getPdfObject()).getAsDictionary(PdfName.Resources);
            PdfDictionary fromResources = ((PdfDictionary)fromPage.getPdfObject()).getAsDictionary(PdfName.Resources);
            OcgPropertiesCopier.getUsedNonFlushedOCGsFromResources(toResources, fromResources, fromUsedOcgs, toOcProperties);
        }
        return fromUsedOcgs;
    }

    private static void getUsedNonFlushedOCGsFromResources(PdfDictionary toResources, PdfDictionary fromResources, Set<PdfIndirectReference> fromUsedOcgs, PdfDictionary toOcProperties) {
        if (toResources != null && !toResources.isFlushed()) {
            PdfDictionary toProperties = toResources.getAsDictionary(PdfName.Properties);
            PdfDictionary fromProperties = fromResources.getAsDictionary(PdfName.Properties);
            if (toProperties != null && !toProperties.isFlushed()) {
                for (PdfName name : toProperties.keySet()) {
                    PdfObject toCurrObj = toProperties.get(name);
                    PdfObject fromCurrObj = fromProperties.get(name);
                    OcgPropertiesCopier.getUsedNonFlushedOCGsFromOcDict(toCurrObj, fromCurrObj, fromUsedOcgs, toOcProperties);
                }
            }
            PdfDictionary toXObject = toResources.getAsDictionary(PdfName.XObject);
            PdfDictionary fromXObject = fromResources.getAsDictionary(PdfName.XObject);
            OcgPropertiesCopier.getUsedNonFlushedOCGsFromXObject(toXObject, fromXObject, fromUsedOcgs, toOcProperties);
        }
    }

    private static void getUsedNonFlushedOCGsFromXObject(PdfDictionary toXObject, PdfDictionary fromXObject, Set<PdfIndirectReference> fromUsedOcgs, PdfDictionary toOcProperties) {
        if (toXObject != null && !toXObject.isFlushed()) {
            if (toXObject.isStream() && !toXObject.isFlushed()) {
                PdfStream toStream = (PdfStream)toXObject;
                PdfStream fromStream = (PdfStream)fromXObject;
                OcgPropertiesCopier.getUsedNonFlushedOCGsFromOcDict(toStream.getAsDictionary(PdfName.OC), fromStream.getAsDictionary(PdfName.OC), fromUsedOcgs, toOcProperties);
                OcgPropertiesCopier.getUsedNonFlushedOCGsFromResources(toStream.getAsDictionary(PdfName.Resources), fromStream.getAsDictionary(PdfName.Resources), fromUsedOcgs, toOcProperties);
            } else {
                for (PdfName name : toXObject.keySet()) {
                    PdfObject toCurrObj = toXObject.get(name);
                    PdfObject fromCurrObj = fromXObject.get(name);
                    if (!toCurrObj.isStream() || toCurrObj.isFlushed()) continue;
                    PdfStream toStream = (PdfStream)toCurrObj;
                    PdfStream fromStream = (PdfStream)fromCurrObj;
                    OcgPropertiesCopier.getUsedNonFlushedOCGsFromXObject(toStream, fromStream, fromUsedOcgs, toOcProperties);
                }
            }
        }
    }

    private static void getUsedNonFlushedOCGsFromOcDict(PdfObject toObj, PdfObject fromObj, Set<PdfIndirectReference> fromUsedOcgs, PdfDictionary toOcProperties) {
        if (toObj != null && toObj.isDictionary() && !toObj.isFlushed()) {
            PdfDictionary toCurrDict = (PdfDictionary)toObj;
            PdfDictionary fromCurrDict = (PdfDictionary)fromObj;
            PdfName typeName = toCurrDict.getAsName(PdfName.Type);
            if (PdfName.OCG.equals(typeName) && !OcgPropertiesCopier.ocgAlreadyInOCGs(toCurrDict.getIndirectReference(), toOcProperties)) {
                fromUsedOcgs.add(fromCurrDict.getIndirectReference());
            } else if (PdfName.OCMD.equals(typeName)) {
                PdfArray toOcgs = null;
                PdfArray fromOcgs = null;
                if (toCurrDict.getAsDictionary(PdfName.OCGs) != null) {
                    toOcgs = new PdfArray();
                    toOcgs.add(toCurrDict.getAsDictionary(PdfName.OCGs));
                    fromOcgs = new PdfArray();
                    fromOcgs.add(fromCurrDict.getAsDictionary(PdfName.OCGs));
                } else if (toCurrDict.getAsArray(PdfName.OCGs) != null) {
                    toOcgs = toCurrDict.getAsArray(PdfName.OCGs);
                    fromOcgs = fromCurrDict.getAsArray(PdfName.OCGs);
                }
                if (toOcgs != null && !toOcgs.isFlushed()) {
                    for (int i = 0; i < toOcgs.size(); ++i) {
                        OcgPropertiesCopier.getUsedNonFlushedOCGsFromOcDict(toOcgs.get(i), fromOcgs.get(i), fromUsedOcgs, toOcProperties);
                    }
                }
            }
        }
    }

    private static void copyOCGs(Set<PdfIndirectReference> fromOcgsToCopy, PdfDictionary toOcProperties, PdfDocument toDocument) {
        HashSet<String> layerNames = new HashSet<String>();
        if (toOcProperties.getAsArray(PdfName.OCGs) != null) {
            PdfArray toOcgs = toOcProperties.getAsArray(PdfName.OCGs);
            for (PdfObject toOcgObj : toOcgs) {
                if (!toOcgObj.isDictionary()) continue;
                layerNames.add(((PdfDictionary)toOcgObj).getAsString(PdfName.Name).toUnicodeString());
            }
        }
        boolean hasConflictingNames = false;
        for (PdfIndirectReference fromOcgRef : fromOcgsToCopy) {
            PdfDictionary toOcg = (PdfDictionary)fromOcgRef.getRefersTo().copyTo(toDocument, false);
            String currentLayerName = toOcg.getAsString(PdfName.Name).toUnicodeString();
            if (layerNames.contains(currentLayerName)) {
                hasConflictingNames = true;
                int i = 0;
                while (layerNames.contains(currentLayerName + "_" + i)) {
                    ++i;
                }
                currentLayerName = currentLayerName + "_" + i;
                toOcg.put(PdfName.Name, new PdfString(currentLayerName, "UnicodeBig"));
            }
            if (toOcProperties.getAsArray(PdfName.OCGs) == null) {
                toOcProperties.put(PdfName.OCGs, new PdfArray());
            }
            toOcProperties.getAsArray(PdfName.OCGs).add(toOcg);
        }
        if (hasConflictingNames) {
            LOGGER.warn("Document has conflicting names for optional content groups. Groups with conflicting names will be renamed");
        }
    }

    private static boolean ocgAlreadyInOCGs(PdfIndirectReference toOcgRef, PdfDictionary toOcProperties) {
        if (toOcProperties == null) {
            return false;
        }
        PdfArray toOcgs = toOcProperties.getAsArray(PdfName.OCGs);
        if (toOcgs != null) {
            for (PdfObject toOcg : toOcgs) {
                if (!toOcgRef.equals(toOcg.getIndirectReference())) continue;
                return true;
            }
        }
        return false;
    }

    private static void copyDDictionary(Set<PdfIndirectReference> fromOcgsToCopy, PdfDictionary fromDDict, PdfDictionary toOcProperties, PdfDocument toDocument) {
        if (toOcProperties.getAsDictionary(PdfName.D) == null) {
            toOcProperties.put(PdfName.D, new PdfDictionary());
        }
        PdfDictionary toDDict = toOcProperties.getAsDictionary(PdfName.D);
        toDDict.remove(PdfName.Creator);
        OcgPropertiesCopier.copyDArrayField(PdfName.ON, fromOcgsToCopy, fromDDict, toDDict, toDocument);
        OcgPropertiesCopier.copyDArrayField(PdfName.OFF, fromOcgsToCopy, fromDDict, toDDict, toDocument);
        OcgPropertiesCopier.copyDArrayField(PdfName.Order, fromOcgsToCopy, fromDDict, toDDict, toDocument);
        OcgPropertiesCopier.copyDArrayField(PdfName.RBGroups, fromOcgsToCopy, fromDDict, toDDict, toDocument);
        OcgPropertiesCopier.copyDArrayField(PdfName.Locked, fromOcgsToCopy, fromDDict, toDDict, toDocument);
    }

    private static void attemptToAddObjectToArray(Set<PdfIndirectReference> fromOcgsToCopy, PdfObject fromObj, PdfArray toArray, PdfDocument toDocument) {
        PdfIndirectReference fromObjRef = fromObj.getIndirectReference();
        if (fromObjRef != null && fromOcgsToCopy.contains(fromObjRef)) {
            toArray.add(fromObj.copyTo(toDocument, false));
        }
    }

    private static void copyDArrayField(PdfName fieldToCopy, Set<PdfIndirectReference> fromOcgsToCopy, PdfDictionary fromDict, PdfDictionary toDict, PdfDocument toDocument) {
        if (fromDict.getAsArray(fieldToCopy) == null) {
            return;
        }
        PdfArray fromArray = fromDict.getAsArray(fieldToCopy);
        if (toDict.getAsArray(fieldToCopy) == null) {
            toDict.put(fieldToCopy, new PdfArray());
        }
        PdfArray toArray = toDict.getAsArray(fieldToCopy);
        HashSet<PdfIndirectReference> toOcgsToCopy = new HashSet<PdfIndirectReference>();
        for (PdfIndirectReference fromRef : fromOcgsToCopy) {
            toOcgsToCopy.add(fromRef.getRefersTo().copyTo(toDocument, false).getIndirectReference());
        }
        if (PdfName.Order.equals(fieldToCopy)) {
            int i;
            ArrayList<Integer> removeIndex = new ArrayList<Integer>();
            for (i = 0; i < toArray.size(); ++i) {
                PdfObject toOrderItem = toArray.get(i);
                if (!OcgPropertiesCopier.orderBranchContainsSetElements(toOrderItem, toArray, i, toOcgsToCopy, null, null)) continue;
                removeIndex.add(i);
            }
            for (i = removeIndex.size() - 1; i > -1; --i) {
                toArray.remove((Integer)removeIndex.get(i));
            }
            PdfArray toOcgs = ((PdfDictionary)toDocument.getCatalog().getPdfObject()).getAsDictionary(PdfName.OCProperties).getAsArray(PdfName.OCGs);
            for (int i2 = 0; i2 < fromArray.size(); ++i2) {
                PdfObject fromOrderItem = fromArray.get(i2);
                if (!OcgPropertiesCopier.orderBranchContainsSetElements(fromOrderItem, fromArray, i2, fromOcgsToCopy, toOcgs, toDocument)) continue;
                toArray.add(fromOrderItem.copyTo(toDocument, false));
            }
        } else if (PdfName.RBGroups.equals(fieldToCopy)) {
            block4: for (int i = toArray.size() - 1; i > -1; --i) {
                PdfArray toRbGroup = (PdfArray)toArray.get(i);
                for (PdfObject toRbGroupItemObj : toRbGroup) {
                    if (!toOcgsToCopy.contains(toRbGroupItemObj.getIndirectReference())) continue;
                    toArray.remove(i);
                    continue block4;
                }
            }
            block6: for (PdfObject fromRbGroupObj : fromArray) {
                PdfArray fromRbGroup = (PdfArray)fromRbGroupObj;
                for (PdfObject fromRbGroupItemObj : fromRbGroup) {
                    if (!fromOcgsToCopy.contains(fromRbGroupItemObj.getIndirectReference())) continue;
                    toArray.add(fromRbGroup.copyTo(toDocument, false));
                    continue block6;
                }
            }
        } else {
            for (PdfObject fromObj : fromArray) {
                OcgPropertiesCopier.attemptToAddObjectToArray(fromOcgsToCopy, fromObj, toArray, toDocument);
            }
        }
        if (toArray.isEmpty()) {
            toDict.remove(fieldToCopy);
        }
    }

    private static boolean orderBranchContainsSetElements(PdfObject arrayObj, PdfArray array, int currentIndex, Set<PdfIndirectReference> ocgs, PdfArray toOcgs, PdfDocument toDocument) {
        if (arrayObj.isDictionary()) {
            PdfArray nextArray;
            if (ocgs.contains(arrayObj.getIndirectReference())) {
                return true;
            }
            if (currentIndex < array.size() - 1 && array.get(currentIndex + 1).isArray() && !(nextArray = array.getAsArray(currentIndex + 1)).get(0).isString()) {
                boolean result = OcgPropertiesCopier.orderBranchContainsSetElements(nextArray, array, currentIndex + 1, ocgs, toOcgs, toDocument);
                if (result && toOcgs != null && !ocgs.contains(arrayObj.getIndirectReference())) {
                    toOcgs.add(arrayObj.copyTo(toDocument, false));
                }
                return result;
            }
        } else if (arrayObj.isArray()) {
            PdfArray arrayItem = (PdfArray)arrayObj;
            for (int i = 0; i < arrayItem.size(); ++i) {
                PdfObject obj = arrayItem.get(i);
                if (!OcgPropertiesCopier.orderBranchContainsSetElements(obj, arrayItem, i, ocgs, toOcgs, toDocument)) continue;
                return true;
            }
            if (!arrayItem.isEmpty() && !arrayItem.get(0).isString() && currentIndex > 0 && array.get(currentIndex - 1).isDictionary()) {
                PdfDictionary previousDict = (PdfDictionary)array.get(currentIndex - 1);
                return ocgs.contains(previousDict.getIndirectReference());
            }
        }
        return false;
    }
}

