/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfObject;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

class PdfDictionaryValues
extends AbstractCollection<PdfObject> {
    private final Collection<PdfObject> collection;

    PdfDictionaryValues(Collection<PdfObject> collection) {
        this.collection = collection;
    }

    @Override
    public boolean add(PdfObject object) {
        return this.collection.add(object);
    }

    @Override
    public boolean contains(Object o) {
        if (this.collection.contains(o)) {
            return true;
        }
        if (o == null) {
            return false;
        }
        for (PdfObject pdfObject : this) {
            if (!PdfObject.equalContent((PdfObject)o, pdfObject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.collection.remove(o)) {
            return true;
        }
        if (o == null) {
            return false;
        }
        Iterator<PdfObject> it = this.iterator();
        while (it.hasNext()) {
            if (!PdfObject.equalContent((PdfObject)o, it.next())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public Iterator<PdfObject> iterator() {
        return new DirectIterator(this.collection.iterator());
    }

    private static class DirectIterator
    implements Iterator<PdfObject> {
        Iterator<PdfObject> parentIterator;

        DirectIterator(Iterator<PdfObject> parentIterator) {
            this.parentIterator = parentIterator;
        }

        @Override
        public boolean hasNext() {
            return this.parentIterator.hasNext();
        }

        @Override
        public PdfObject next() {
            PdfObject obj = this.parentIterator.next();
            if (obj != null && obj.isIndirectReference()) {
                obj = ((PdfIndirectReference)obj).getRefersTo(true);
            }
            return obj;
        }

        @Override
        public void remove() {
            this.parentIterator.remove();
        }
    }
}

