/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.border;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.color.DeviceCmyk;
import com.itextpdf.kernel.color.DeviceGray;
import com.itextpdf.kernel.color.DeviceRgb;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.border.Border;

public abstract class Border3D
extends Border {
    private static final DeviceRgb GRAY = new DeviceRgb(212, 208, 200);

    protected Border3D(float width) {
        this(GRAY, width);
    }

    protected Border3D(DeviceRgb color, float width) {
        super((Color)color, width);
    }

    protected Border3D(DeviceCmyk color, float width) {
        super((Color)color, width);
    }

    protected Border3D(DeviceGray color, float width) {
        super((Color)color, width);
    }

    protected Border3D(DeviceRgb color, float width, float opacity) {
        super((Color)color, width, opacity);
    }

    protected Border3D(DeviceCmyk color, float width, float opacity) {
        super((Color)color, width, opacity);
    }

    protected Border3D(DeviceGray color, float width, float opacity) {
        super((Color)color, width, opacity);
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderWidthBefore, float borderWidthAfter) {
        float x3 = 0.0f;
        float y3 = 0.0f;
        float x4 = 0.0f;
        float y4 = 0.0f;
        float widthHalf = this.width / 2.0f;
        float halfOfWidthBefore = borderWidthBefore / 2.0f;
        float halfOfWidthAfter = borderWidthAfter / 2.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2);
        switch (borderSide) {
            case TOP: {
                x3 = x2 + halfOfWidthAfter;
                y3 = y2 + widthHalf;
                x4 = x1 - halfOfWidthBefore;
                y4 = y1 + widthHalf;
                break;
            }
            case RIGHT: {
                x3 = x2 + widthHalf;
                y3 = y2 - halfOfWidthAfter;
                x4 = x1 + widthHalf;
                y4 = y1 + halfOfWidthBefore;
                break;
            }
            case BOTTOM: {
                x3 = x2 - halfOfWidthAfter;
                y3 = y2 - widthHalf;
                x4 = x1 + halfOfWidthBefore;
                y4 = y1 - widthHalf;
                break;
            }
            case LEFT: {
                x3 = x2 - widthHalf;
                y3 = y2 + halfOfWidthAfter;
                x4 = x1 - widthHalf;
                y4 = y1 - halfOfWidthBefore;
            }
        }
        canvas.saveState();
        this.setInnerHalfColor(canvas, borderSide);
        canvas.moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).lineTo((double)x3, (double)y3).lineTo((double)x4, (double)y4).lineTo((double)x1, (double)y1).fill();
        switch (borderSide) {
            case TOP: {
                x2 += borderWidthAfter;
                y2 += this.width;
                x1 -= borderWidthBefore;
                y1 += this.width;
                break;
            }
            case RIGHT: {
                x2 += this.width;
                y2 -= borderWidthAfter;
                x1 += this.width;
                y1 += borderWidthBefore;
                break;
            }
            case BOTTOM: {
                x2 -= borderWidthAfter;
                y2 -= this.width;
                x1 += borderWidthBefore;
                y1 -= this.width;
                break;
            }
            case LEFT: {
                x2 -= this.width;
                y2 += borderWidthAfter;
                x1 -= this.width;
                y1 -= borderWidthBefore;
            }
        }
        this.setOuterHalfColor(canvas, borderSide);
        canvas.moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).lineTo((double)x3, (double)y3).lineTo((double)x4, (double)y4).lineTo((double)x1, (double)y1).fill();
        canvas.restoreState();
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderRadius, Border.Side side, float borderWidthBefore, float borderWidthAfter) {
        this.draw(canvas, x1, y1, x2, y2, borderWidthBefore, borderWidthAfter);
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2) {
        canvas.saveState().setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineWidth(this.width).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
    }

    protected Color getDarkerColor() {
        Color color = this.transparentColor.getColor();
        if (color instanceof DeviceRgb) {
            return DeviceRgb.makeDarker((DeviceRgb)((DeviceRgb)color));
        }
        if (color instanceof DeviceCmyk) {
            return DeviceCmyk.makeDarker((DeviceCmyk)((DeviceCmyk)color));
        }
        if (color instanceof DeviceGray) {
            return DeviceGray.makeDarker((DeviceGray)((DeviceGray)color));
        }
        return color;
    }

    protected abstract void setInnerHalfColor(PdfCanvas var1, Border.Side var2);

    protected abstract void setOuterHalfColor(PdfCanvas var1, Border.Side var2);
}

