/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ICertificateStatus;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IRevokedStatus;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ISingleResp;
import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.TimestampConstants;
import com.itextpdf.signatures.validation.v1.SignatureValidationProperties;
import com.itextpdf.signatures.validation.v1.ValidatorChainBuilder;
import com.itextpdf.signatures.validation.v1.context.CertificateSource;
import com.itextpdf.signatures.validation.v1.context.ValidationContext;
import com.itextpdf.signatures.validation.v1.context.ValidatorContext;
import com.itextpdf.signatures.validation.v1.report.CertificateReportItem;
import com.itextpdf.signatures.validation.v1.report.ReportItem;
import com.itextpdf.signatures.validation.v1.report.ValidationReport;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Date;

public class OCSPValidator {
    static final String CERT_IS_EXPIRED = "Certificate is expired on {0}. Its revocation status could have been removed from the database, so the OCSP response status could be falsely valid.";
    static final String CERT_IS_REVOKED = "Certificate status is revoked.";
    static final String CERT_STATUS_IS_UNKNOWN = "Certificate status is unknown.";
    static final String INVALID_OCSP = "OCSP response is invalid.";
    static final String ISSUERS_DO_NOT_MATCH = "OCSP: Issuers don't match.";
    static final String FRESHNESS_CHECK = "OCSP response is not fresh enough: this update: {0}, validation date: {1}, freshness: {2}.";
    static final String OCSP_COULD_NOT_BE_VERIFIED = "OCSP response could not be verified: it does not contain responder in the certificate chain and response is not signed by issuer certificate or any from the trusted store.";
    static final String OCSP_RESPONDER_NOT_RETRIEVED = "OCSP response could not be verified: \" +\n            \"Unexpected exception occurred retrieving responder.";
    static final String OCSP_RESPONDER_NOT_VERIFIED = "OCSP response could not be verified: \" +\n            \" Unexpected exception occurred while validating responder certificate.";
    static final String OCSP_RESPONDER_TRUST_NOT_RETRIEVED = "OCSP response could not be verified: \" +\n            \"responder trust state could not be retrieved.";
    static final String OCSP_IS_NO_LONGER_VALID = "OCSP is no longer valid: {0} after {1}";
    static final String SERIAL_NUMBERS_DO_NOT_MATCH = "OCSP: Serial numbers don't match.";
    static final String UNABLE_TO_CHECK_IF_ISSUERS_MATCH = "OCSP response could not be verified: Unexpected exception occurred checking if issuers match.";
    static final String UNABLE_TO_RETRIEVE_ISSUER = "OCSP response could not be verified: Unexpected exception occurred while retrieving issuer";
    static final String OCSP_CHECK = "OCSP response check.";
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final IssuingCertificateRetriever certificateRetriever;
    private final SignatureValidationProperties properties;
    private final ValidatorChainBuilder builder;

    protected OCSPValidator(ValidatorChainBuilder builder) {
        this.certificateRetriever = builder.getCertificateRetriever();
        this.properties = builder.getProperties();
        this.builder = builder;
    }

    @Deprecated
    public void validate(ValidationReport report, ValidationContext context, X509Certificate certificate, ISingleResp singleResp, IBasicOCSPResp ocspResp, Date validationDate) {
        this.validate(report, context, certificate, singleResp, ocspResp, validationDate, DateTimeUtil.getCurrentTimeDate());
    }

    public void validate(ValidationReport report, ValidationContext context, X509Certificate certificate, ISingleResp singleResp, IBasicOCSPResp ocspResp, Date validationDate, Date responseGenerationDate) {
        Date startExpirationDate;
        Certificate issuerCert;
        ValidationContext localContext = context.setValidatorContext(ValidatorContext.OCSP_VALIDATOR);
        if (CertificateUtil.isSelfSigned(certificate)) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, "Certificate is self-signed. Revocation data check will be skipped.", ReportItem.ReportItemStatus.INFO));
            return;
        }
        if (!certificate.getSerialNumber().equals(singleResp.getCertID().getSerialNumber())) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, SERIAL_NUMBERS_DO_NOT_MATCH, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        try {
            issuerCert = this.certificateRetriever.retrieveIssuerCertificate(certificate);
        }
        catch (RuntimeException e) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, UNABLE_TO_RETRIEVE_ISSUER, e, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        try {
            if (!CertificateUtil.checkIfIssuersMatch(singleResp.getCertID(), (X509Certificate)issuerCert)) {
                report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, ISSUERS_DO_NOT_MATCH, ReportItem.ReportItemStatus.INDETERMINATE));
                return;
            }
        }
        catch (Exception e) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, UNABLE_TO_CHECK_IF_ISSUERS_MATCH, e, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        Duration freshness = this.properties.getFreshness(localContext);
        if (DateTimeUtil.addMillisToDate((Date)singleResp.getThisUpdate(), (long)freshness.toMillis()).before(validationDate)) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, MessageFormatUtil.format((String)FRESHNESS_CHECK, (Object[])new Object[]{singleResp.getThisUpdate(), validationDate, freshness}), ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        if (singleResp.getNextUpdate() != TimestampConstants.UNDEFINED_TIMESTAMP_DATE && validationDate.after(singleResp.getNextUpdate())) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, MessageFormatUtil.format((String)OCSP_IS_NO_LONGER_VALID, (Object[])new Object[]{validationDate, singleResp.getNextUpdate()}), ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        ICertificateStatus status = singleResp.getCertStatus();
        IRevokedStatus revokedStatus = BOUNCY_CASTLE_FACTORY.createRevokedStatus(status);
        boolean isStatusGood = BOUNCY_CASTLE_FACTORY.createCertificateStatus().getGood().equals(status);
        if (isStatusGood && certificate.getNotAfter().before(ocspResp.getProducedAt()) && (TimestampConstants.UNDEFINED_TIMESTAMP_DATE == (startExpirationDate = this.getArchiveCutoffExtension(ocspResp)) || certificate.getNotAfter().before(startExpirationDate))) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, MessageFormatUtil.format((String)CERT_IS_EXPIRED, (Object[])new Object[]{certificate.getNotAfter()}), ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        if (isStatusGood || revokedStatus != null && validationDate.before(revokedStatus.getRevocationTime())) {
            this.verifyOcspResponder(report, localContext, ocspResp, (X509Certificate)issuerCert, responseGenerationDate);
            if (!isStatusGood) {
                report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, MessageFormatUtil.format((String)"The certificate was valid on the verification date, but has been revoked since {0}.", (Object[])new Object[]{revokedStatus.getRevocationTime()}), ReportItem.ReportItemStatus.INFO));
            }
        } else if (revokedStatus != null) {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, CERT_IS_REVOKED, ReportItem.ReportItemStatus.INVALID));
        } else {
            report.addReportItem(new CertificateReportItem(certificate, OCSP_CHECK, CERT_STATUS_IS_UNKNOWN, ReportItem.ReportItemStatus.INDETERMINATE));
        }
    }

    private void verifyOcspResponder(ValidationReport report, ValidationContext context, IBasicOCSPResp ocspResp, X509Certificate issuerCert, Date responseGenerationDate) {
        ValidationContext localContext = context.setCertificateSource(CertificateSource.OCSP_ISSUER);
        ValidationReport responderReport = new ValidationReport();
        X509Certificate responderCert = null;
        if (CertificateUtil.isSignatureValid(ocspResp, issuerCert)) {
            responderCert = issuerCert;
        }
        if (responderCert == null) {
            try {
                responderCert = (X509Certificate)this.certificateRetriever.retrieveOCSPResponderCertificate(ocspResp);
            }
            catch (RuntimeException e) {
                report.addReportItem(new CertificateReportItem(issuerCert, OCSP_CHECK, OCSP_RESPONDER_NOT_RETRIEVED, e, ReportItem.ReportItemStatus.INDETERMINATE));
                return;
            }
            if (responderCert == null) {
                report.addReportItem(new CertificateReportItem(issuerCert, OCSP_CHECK, OCSP_COULD_NOT_BE_VERIFIED, ReportItem.ReportItemStatus.INDETERMINATE));
                return;
            }
            boolean needsToBeSignedByIssuer = false;
            try {
                needsToBeSignedByIssuer = !this.certificateRetriever.isCertificateTrusted(responderCert) && !this.certificateRetriever.getTrustedCertificatesStore().isCertificateTrustedForOcsp(responderCert);
            }
            catch (RuntimeException e) {
                report.addReportItem(new CertificateReportItem(responderCert, OCSP_CHECK, OCSP_RESPONDER_TRUST_NOT_RETRIEVED, e, ReportItem.ReportItemStatus.INDETERMINATE));
                return;
            }
            if (needsToBeSignedByIssuer) {
                try {
                    responderCert.verify(issuerCert.getPublicKey());
                }
                catch (Exception e) {
                    report.addReportItem(new CertificateReportItem(responderCert, OCSP_CHECK, INVALID_OCSP, e, ReportItem.ReportItemStatus.INVALID));
                    return;
                }
                try {
                    this.builder.getCertificateChainValidator().validate(responderReport, localContext, responderCert, responseGenerationDate);
                }
                catch (RuntimeException e) {
                    report.addReportItem(new CertificateReportItem(responderCert, OCSP_CHECK, OCSP_RESPONDER_NOT_VERIFIED, e, ReportItem.ReportItemStatus.INDETERMINATE));
                    return;
                }
            }
            try {
                this.builder.getCertificateChainValidator().validate(responderReport, localContext.setCertificateSource(CertificateSource.TRUSTED), responderCert, responseGenerationDate);
            }
            catch (RuntimeException e) {
                report.addReportItem(new CertificateReportItem(responderCert, OCSP_CHECK, OCSP_RESPONDER_NOT_VERIFIED, e, ReportItem.ReportItemStatus.INDETERMINATE));
                return;
            }
        }
        try {
            this.builder.getCertificateChainValidator().validate(responderReport, localContext.setCertificateSource(CertificateSource.CERT_ISSUER), responderCert, responseGenerationDate);
        }
        catch (RuntimeException e) {
            report.addReportItem(new CertificateReportItem(responderCert, OCSP_CHECK, OCSP_RESPONDER_NOT_VERIFIED, e, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        OCSPValidator.addResponderValidationReport(report, responderReport);
    }

    private static void addResponderValidationReport(ValidationReport report, ValidationReport responderReport) {
        for (ReportItem reportItem : responderReport.getLogs()) {
            report.addReportItem(ReportItem.ReportItemStatus.INVALID == reportItem.getStatus() ? reportItem.setStatus(ReportItem.ReportItemStatus.INDETERMINATE) : reportItem);
        }
    }

    private Date getArchiveCutoffExtension(IBasicOCSPResp ocspResp) {
        IASN1Encodable archiveCutoff = ocspResp.getExtensionParsedValue(BOUNCY_CASTLE_FACTORY.createOCSPObjectIdentifiers().getIdPkixOcspArchiveCutoff());
        if (!archiveCutoff.isNull()) {
            try {
                return BOUNCY_CASTLE_FACTORY.createASN1GeneralizedTime(archiveCutoff).getDate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (Date)TimestampConstants.UNDEFINED_TIMESTAMP_DATE;
    }
}

