/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.validation.v1.CRLValidator;
import com.itextpdf.signatures.validation.v1.CertificateChainValidator;
import com.itextpdf.signatures.validation.v1.DocumentRevisionsValidator;
import com.itextpdf.signatures.validation.v1.OCSPValidator;
import com.itextpdf.signatures.validation.v1.RevocationDataValidator;
import com.itextpdf.signatures.validation.v1.SignatureValidationProperties;
import com.itextpdf.signatures.validation.v1.SignatureValidator;
import java.security.cert.Certificate;
import java.util.Collection;

public class ValidatorChainBuilder {
    private SignatureValidationProperties properties;
    private IssuingCertificateRetriever certificateRetriever;
    private CertificateChainValidator certificateChainValidator;
    private RevocationDataValidator revocationDataValidator;
    private OCSPValidator ocspValidator;
    private CRLValidator crlValidator;
    private DocumentRevisionsValidator documentRevisionsValidator;

    public SignatureValidator buildSignatureValidator(PdfDocument document) {
        return new SignatureValidator(document, this);
    }

    public DocumentRevisionsValidator buildDocumentRevisionsValidator() {
        return new DocumentRevisionsValidator(this);
    }

    public CertificateChainValidator buildCertificateChainValidator() {
        return new CertificateChainValidator(this);
    }

    public RevocationDataValidator buildRevocationDataValidator() {
        return new RevocationDataValidator(this);
    }

    public OCSPValidator buildOCSPValidator() {
        return new OCSPValidator(this);
    }

    public CRLValidator buildCRLValidator() {
        return new CRLValidator(this);
    }

    public ValidatorChainBuilder withDocumentRevisionsValidator(DocumentRevisionsValidator documentRevisionsValidator) {
        this.documentRevisionsValidator = documentRevisionsValidator;
        return this;
    }

    public ValidatorChainBuilder withCRLValidator(CRLValidator crlValidator) {
        this.crlValidator = crlValidator;
        return this;
    }

    public ValidatorChainBuilder withOCSPValidator(OCSPValidator ocspValidator) {
        this.ocspValidator = ocspValidator;
        return this;
    }

    public ValidatorChainBuilder withRevocationDataValidator(RevocationDataValidator revocationDataValidator) {
        this.revocationDataValidator = revocationDataValidator;
        return this;
    }

    public ValidatorChainBuilder withCertificateChainValidator(CertificateChainValidator certificateChainValidator) {
        this.certificateChainValidator = certificateChainValidator;
        return this;
    }

    public ValidatorChainBuilder withSignatureValidationProperties(SignatureValidationProperties properties) {
        this.properties = properties;
        return this;
    }

    public ValidatorChainBuilder withIssuingCertificateRetriever(IssuingCertificateRetriever certificateRetriever) {
        this.certificateRetriever = certificateRetriever;
        return this;
    }

    public ValidatorChainBuilder withKnownCertificates(Collection<Certificate> knownCertificates) {
        this.getCertificateRetriever().addKnownCertificates(knownCertificates);
        return this;
    }

    public ValidatorChainBuilder withTrustedCertificates(Collection<Certificate> trustedCertificates) {
        this.getCertificateRetriever().setTrustedCertificates(trustedCertificates);
        return this;
    }

    DocumentRevisionsValidator getDocumentRevisionsValidator() {
        if (this.documentRevisionsValidator == null) {
            this.documentRevisionsValidator = this.buildDocumentRevisionsValidator();
        }
        return this.documentRevisionsValidator;
    }

    CertificateChainValidator getCertificateChainValidator() {
        if (this.certificateChainValidator == null) {
            this.certificateChainValidator = this.buildCertificateChainValidator();
        }
        return this.certificateChainValidator;
    }

    RevocationDataValidator getRevocationDataValidator() {
        if (this.revocationDataValidator == null) {
            this.revocationDataValidator = this.buildRevocationDataValidator();
        }
        return this.revocationDataValidator;
    }

    CRLValidator getCRLValidator() {
        if (this.crlValidator == null) {
            this.crlValidator = this.buildCRLValidator();
        }
        return this.crlValidator;
    }

    OCSPValidator getOCSPValidator() {
        if (this.ocspValidator == null) {
            this.ocspValidator = this.buildOCSPValidator();
        }
        return this.ocspValidator;
    }

    public IssuingCertificateRetriever getCertificateRetriever() {
        if (this.certificateRetriever == null) {
            this.certificateRetriever = new IssuingCertificateRetriever();
        }
        return this.certificateRetriever;
    }

    public SignatureValidationProperties getProperties() {
        if (this.properties == null) {
            this.properties = new SignatureValidationProperties();
        }
        return this.properties;
    }
}

