/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc.protocol;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;

public final class UnaryGrpcSerializationFormats {
    public static final SerializationFormat PROTO = SerializationFormat.of((String)"gproto");
    public static final SerializationFormat PROTO_WEB = SerializationFormat.of((String)"gproto-web");
    public static final SerializationFormat PROTO_WEB_TEXT = SerializationFormat.of((String)"gproto-web-text");
    private static final Set<SerializationFormat> FORMATS = ImmutableSet.of((Object)PROTO, (Object)PROTO_WEB, (Object)PROTO_WEB_TEXT);

    public static Set<SerializationFormat> values() {
        return FORMATS;
    }

    public static boolean isGrpc(SerializationFormat format) {
        return FORMATS.contains(Objects.requireNonNull(format, "format"));
    }

    public static boolean isGrpcWeb(SerializationFormat format) {
        Objects.requireNonNull(format, "format");
        return format == PROTO_WEB || format == PROTO_WEB_TEXT;
    }

    public static boolean isGrpcWebText(SerializationFormat format) {
        Objects.requireNonNull(format, "format");
        return format == PROTO_WEB_TEXT;
    }

    private UnaryGrpcSerializationFormats() {
    }
}

