/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.spring;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import com.linecorp.armeria.internal.spring.ArmeriaConfigurationNetUtil;
import com.linecorp.armeria.internal.spring.ArmeriaConfigurationSettingsUtil;
import com.linecorp.armeria.internal.spring.CustomAliasKeyManagerFactory;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.encoding.EncodingService;
import com.linecorp.armeria.server.metric.MetricCollectingService;
import com.linecorp.armeria.server.metric.MetricCollectingServiceBuilder;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import com.linecorp.armeria.spring.ArmeriaSettings;
import com.linecorp.armeria.spring.InternalServiceId;
import com.linecorp.armeria.spring.InternalServices;
import com.linecorp.armeria.spring.MetricCollectingServiceConfigurator;
import com.linecorp.armeria.spring.Ssl;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.util.ResourceUtils;

public final class ArmeriaConfigurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaConfigurationUtil.class);
    private static final String[] EMPTY_PROTOCOL_NAMES = new String[0];
    private static final Pattern DATA_SIZE_PATTERN = Pattern.compile("^([+]?\\d+)([a-zA-Z]{0,2})$");

    public static void configureServerWithArmeriaSettings(ServerBuilder server, ArmeriaSettings settings, InternalServices internalServices, List<ArmeriaServerConfigurator> armeriaServerConfigurators, List<Consumer<ServerBuilder>> armeriaServerBuilderConsumers, MeterRegistry meterRegistry, MeterIdPrefixFunction meterIdPrefixFunction, List<MetricCollectingServiceConfigurator> metricCollectingServiceConfigurators, BeanFactory beanFactory) {
        ArmeriaSettings.Compression compression;
        ArmeriaSettings.InternalServiceProperties internalServiceProperties;
        boolean needsManagementPort;
        Objects.requireNonNull(server, "server");
        Objects.requireNonNull(settings, "settings");
        Objects.requireNonNull(armeriaServerConfigurators, "armeriaServerConfigurators");
        Objects.requireNonNull(armeriaServerBuilderConsumers, "armeriaServerBuilderConsumers");
        Objects.requireNonNull(meterRegistry, "meterRegistry");
        Objects.requireNonNull(metricCollectingServiceConfigurators, "metricCollectingServiceConfigurators");
        ArmeriaSettings.Port internalServicePort = internalServices.internalServicePort();
        ArmeriaSettings.Port managementServerPort = internalServices.managementServerPort();
        ImmutableList.Builder internalPortsBuilder = ImmutableList.builder();
        if (internalServicePort != null) {
            internalPortsBuilder.add((Object)internalServicePort);
        }
        boolean bl = needsManagementPort = ArmeriaConfigurationUtil.findBean(beanFactory, "actuatorServerConfigurator", ArmeriaServerConfigurator.class) != null;
        if (needsManagementPort && managementServerPort != null) {
            internalPortsBuilder.add((Object)managementServerPort);
        }
        ImmutableList internalPorts = internalPortsBuilder.build();
        ArmeriaConfigurationNetUtil.configurePorts(server, settings.getPorts());
        ArmeriaConfigurationNetUtil.configurePorts(server, (List<ArmeriaSettings.Port>)internalPorts);
        ArmeriaConfigurationSettingsUtil.configureSettings(server, settings);
        armeriaServerConfigurators.forEach(configurator -> configurator.configure(server));
        armeriaServerBuilderConsumers.forEach(consumer -> consumer.accept(server));
        if (settings.getGracefulShutdownQuietPeriodMillis() >= 0L && settings.getGracefulShutdownTimeoutMillis() >= 0L) {
            server.gracefulShutdownTimeoutMillis(settings.getGracefulShutdownQuietPeriodMillis(), settings.getGracefulShutdownTimeoutMillis());
            logger.debug("Set graceful shutdown timeout: quiet period {} ms, timeout {} ms", (Object)settings.getGracefulShutdownQuietPeriodMillis(), (Object)settings.getGracefulShutdownTimeoutMillis());
        }
        List<InternalServiceId> internalServiceIds = (internalServiceProperties = settings.getInternalServices()) == null ? InternalServiceId.defaultServiceIds() : internalServiceProperties.getInclude();
        ArmeriaConfigurationUtil.configureInternalService(server, InternalServiceId.DOCS, settings.getDocsPath(), (HttpService)internalServices.docService(), (List<ArmeriaSettings.Port>)internalPorts, internalServiceIds, true);
        ArmeriaConfigurationUtil.configureInternalService(server, InternalServiceId.HEALTH, settings.getHealthCheckPath(), (HttpService)internalServices.healthCheckService(), (List<ArmeriaSettings.Port>)internalPorts, internalServiceIds, false);
        server.meterRegistry(meterRegistry);
        if (settings.isEnableMetrics()) {
            if (!metricCollectingServiceConfigurators.isEmpty()) {
                MetricCollectingServiceBuilder builder = MetricCollectingService.builder((MeterIdPrefixFunction)meterIdPrefixFunction);
                for (MetricCollectingServiceConfigurator configurator2 : metricCollectingServiceConfigurators) {
                    configurator2.configure(builder);
                }
                server.decorator(builder.newDecorator());
            } else {
                server.decorator(MetricCollectingService.newDecorator((MeterIdPrefixFunction)meterIdPrefixFunction));
            }
            ArmeriaConfigurationUtil.configureInternalService(server, InternalServiceId.METRICS, settings.getMetricsPath(), internalServices.metricsExpositionService(), (List<ArmeriaSettings.Port>)internalPorts, internalServiceIds, false);
        }
        if (settings.getSsl() != null) {
            ArmeriaConfigurationUtil.configureTls(server, settings.getSsl());
        }
        if ((compression = settings.getCompression()) != null && compression.isEnabled()) {
            int minBytesToForceChunkedAndEncoding = Ints.saturatedCast((long)ArmeriaConfigurationUtil.parseDataSize(compression.getMinResponseSize()));
            server.decorator(ArmeriaConfigurationUtil.contentEncodingDecorator(compression.getMimeTypes(), compression.getExcludedUserAgents(), minBytesToForceChunkedAndEncoding));
        }
    }

    private static void configureInternalService(ServerBuilder server, InternalServiceId serviceId, @Nullable String servicePath, @Nullable HttpService service, List<ArmeriaSettings.Port> internalPorts, @Nullable List<InternalServiceId> internalServiceIds, boolean usesPrefixPath) {
        if (service == null) {
            return;
        }
        assert (servicePath != null);
        internalServiceIds = (List)MoreObjects.firstNonNull(internalServiceIds, (Object)ImmutableList.of());
        if (internalPorts.isEmpty()) {
            ArmeriaConfigurationUtil.configureInternalService(server, serviceId, servicePath, service, (ArmeriaSettings.Port)null, (List<InternalServiceId>)internalServiceIds, usesPrefixPath);
        } else {
            for (ArmeriaSettings.Port internalPort : internalPorts) {
                ArmeriaConfigurationUtil.configureInternalService(server, serviceId, servicePath, service, internalPort, (List<InternalServiceId>)internalServiceIds, usesPrefixPath);
            }
        }
    }

    private static void configureInternalService(ServerBuilder server, InternalServiceId serviceId, String servicePath, HttpService service, @Nullable ArmeriaSettings.Port internalPort, List<InternalServiceId> internalServiceIds, boolean usesPrefixPath) {
        boolean needsPortBasedVirtualHost = internalPort == null ? false : (internalServiceIds.contains((Object)InternalServiceId.ALL) ? true : internalServiceIds.contains((Object)serviceId));
        if (needsPortBasedVirtualHost) {
            if (usesPrefixPath) {
                server.virtualHost(internalPort.getPort()).serviceUnder(servicePath, service);
            } else {
                server.virtualHost(internalPort.getPort()).service(servicePath, service);
            }
        } else if (usesPrefixPath) {
            server.serviceUnder(servicePath, service);
        } else {
            server.service(servicePath, service);
        }
    }

    @Nullable
    private static <T> T findBean(BeanFactory beanFactory, String name, Class<T> clazz) {
        try {
            return (T)beanFactory.getBean(name, clazz);
        }
        catch (NoUniqueBeanDefinitionException e) {
            throw new IllegalStateException("Too many " + clazz.getSimpleName() + " beans: (expected: 1)", e);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public static void configureTls(ServerBuilder sb, Ssl ssl) {
        ArmeriaConfigurationUtil.configureTls(sb, ssl, null, null);
    }

    public static void configureTls(ServerBuilder sb, Ssl ssl, @Nullable Supplier<KeyStore> keyStoreSupplier, @Nullable Supplier<KeyStore> trustStoreSupplier) {
        if (!ssl.isEnabled()) {
            return;
        }
        try {
            if (keyStoreSupplier == null && trustStoreSupplier == null && ssl.getKeyStore() == null && ssl.getTrustStore() == null) {
                logger.warn("Configuring TLS with a self-signed certificate because no key or trust store was specified");
                sb.tlsSelfSigned();
                return;
            }
            KeyManagerFactory keyManagerFactory = ArmeriaConfigurationUtil.getKeyManagerFactory(ssl, keyStoreSupplier);
            TrustManagerFactory trustManagerFactory = ArmeriaConfigurationUtil.getTrustManagerFactory(ssl, trustStoreSupplier);
            sb.tls(keyManagerFactory);
            sb.tlsCustomizer(sslContextBuilder -> {
                ClientAuth clientAuth;
                List<String> ciphers;
                List<String> enabledProtocols;
                sslContextBuilder.trustManager(trustManagerFactory);
                SslProvider sslProvider = ssl.getProvider();
                if (sslProvider != null) {
                    sslContextBuilder.sslProvider(sslProvider);
                }
                if ((enabledProtocols = ssl.getEnabledProtocols()) != null) {
                    sslContextBuilder.protocols(enabledProtocols.toArray(EMPTY_PROTOCOL_NAMES));
                }
                if ((ciphers = ssl.getCiphers()) != null) {
                    sslContextBuilder.ciphers((Iterable)ImmutableList.copyOf(ciphers), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
                }
                if ((clientAuth = ssl.getClientAuth()) != null) {
                    sslContextBuilder.clientAuth(clientAuth);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to configure TLS: " + e, e);
        }
    }

    private static KeyManagerFactory getKeyManagerFactory(Ssl ssl, @Nullable Supplier<KeyStore> sslStoreProvider) throws Exception {
        String keyPassword;
        KeyStore store = sslStoreProvider != null ? sslStoreProvider.get() : ArmeriaConfigurationUtil.loadKeyStore(ssl.getKeyStoreType(), ssl.getKeyStore(), ssl.getKeyStorePassword());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (ssl.getKeyAlias() != null) {
            keyManagerFactory = new CustomAliasKeyManagerFactory(keyManagerFactory, ssl.getKeyAlias());
        }
        if ((keyPassword = ssl.getKeyPassword()) == null) {
            keyPassword = ssl.getKeyStorePassword();
        }
        keyManagerFactory.init(store, keyPassword != null ? keyPassword.toCharArray() : null);
        return keyManagerFactory;
    }

    private static TrustManagerFactory getTrustManagerFactory(Ssl ssl, @Nullable Supplier<KeyStore> sslStoreProvider) throws Exception {
        KeyStore store = sslStoreProvider != null ? sslStoreProvider.get() : ArmeriaConfigurationUtil.loadKeyStore(ssl.getTrustStoreType(), ssl.getTrustStore(), ssl.getTrustStorePassword());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(store);
        return trustManagerFactory;
    }

    @Nullable
    private static KeyStore loadKeyStore(@Nullable String type, @Nullable String resource, @Nullable String password) throws IOException, GeneralSecurityException {
        if (resource == null) {
            return null;
        }
        KeyStore store = KeyStore.getInstance((String)MoreObjects.firstNonNull((Object)type, (Object)"JKS"));
        URL url = ResourceUtils.getURL((String)resource);
        store.load(url.openStream(), password != null ? password.toCharArray() : null);
        return store;
    }

    public static Function<? super HttpService, EncodingService> contentEncodingDecorator(@Nullable String[] mimeTypes, @Nullable String[] excludedUserAgents, int minBytesToForceChunkedAndEncoding) {
        Predicate<RequestHeaders> encodableRequestHeadersPredicate;
        Predicate<MediaType> encodableContentTypePredicate;
        if (mimeTypes == null || mimeTypes.length == 0) {
            encodableContentTypePredicate = contentType -> true;
        } else {
            List encodableContentTypes = (List)Arrays.stream(mimeTypes).map(MediaType::parse).collect(ImmutableList.toImmutableList());
            encodableContentTypePredicate = contentType -> encodableContentTypes.stream().anyMatch(arg_0 -> ((MediaType)contentType).is(arg_0));
        }
        if (excludedUserAgents == null || excludedUserAgents.length == 0) {
            encodableRequestHeadersPredicate = headers -> true;
        } else {
            List patterns = (List)Arrays.stream(excludedUserAgents).map(Pattern::compile).collect(ImmutableList.toImmutableList());
            encodableRequestHeadersPredicate = headers -> {
                String userAgent = headers.get((CharSequence)HttpHeaderNames.USER_AGENT, "");
                return patterns.stream().noneMatch(pattern -> pattern.matcher(userAgent).matches());
            };
        }
        return EncodingService.builder().encodableContentTypes(encodableContentTypePredicate).encodableRequestHeaders(encodableRequestHeadersPredicate).minBytesToForceChunkedEncoding(minBytesToForceChunkedAndEncoding).newDecorator();
    }

    public static long parseDataSize(String dataSizeText) {
        long unit;
        Objects.requireNonNull(dataSizeText, "text");
        Matcher matcher = DATA_SIZE_PATTERN.matcher(dataSizeText);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid data size text: %s (expected: %s)", (Object)dataSizeText, (Object)DATA_SIZE_PATTERN);
        String unitText = matcher.group(2);
        if (Strings.isNullOrEmpty((String)unitText)) {
            unit = 1L;
        } else {
            switch (Ascii.toLowerCase((String)unitText)) {
                case "b": {
                    unit = 1L;
                    break;
                }
                case "kb": {
                    unit = 1024L;
                    break;
                }
                case "mb": {
                    unit = 0x100000L;
                    break;
                }
                case "gb": {
                    unit = 0x40000000L;
                    break;
                }
                case "tb": {
                    unit = 0x10000000000L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid data size text: " + dataSizeText + " (expected: " + DATA_SIZE_PATTERN + ')');
                }
            }
        }
        try {
            long amount = Long.parseLong(matcher.group(1));
            return LongMath.checkedMultiply((long)amount, (long)unit);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid data size text: " + dataSizeText + " (expected: " + DATA_SIZE_PATTERN + ')', e);
        }
    }

    private ArmeriaConfigurationUtil() {
    }
}

