/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.spring.DropwizardExpositionService;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import java.util.concurrent.TimeUnit;

final class DropwizardSupport {
    @Nullable
    static DropwizardExpositionService newExpositionService(MeterRegistry meterRegistry) {
        if (!(meterRegistry instanceof DropwizardMeterRegistry)) {
            return null;
        }
        MetricRegistry dropwizardRegistry = ((DropwizardMeterRegistry)meterRegistry).getDropwizardRegistry();
        ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, true));
        return new DropwizardExpositionService(dropwizardRegistry, objectMapper);
    }

    private DropwizardSupport() {
    }
}

