/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring;

import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.spring.AbstractArmeriaAutoConfiguration;
import com.linecorp.armeria.spring.ArmeriaSettings;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration
@Conditional(value={NonReactiveWebApplicationCondition.class})
@EnableConfigurationProperties(value={ArmeriaSettings.class})
@ConditionalOnClass(value={Server.class})
@ConditionalOnProperty(name={"armeria.server-enabled"}, havingValue="true", matchIfMissing=true)
public class ArmeriaAutoConfiguration
extends AbstractArmeriaAutoConfiguration {

    static class NonReactiveWebApplicationCondition
    extends NoneNestedConditions {
        NonReactiveWebApplicationCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
        static class ReactiveWebApplication {
            ReactiveWebApplication() {
            }
        }
    }
}

