/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.spring.InternalServiceId;
import com.linecorp.armeria.spring.Ssl;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="armeria")
@Validated
public class ArmeriaSettings {
    private boolean serverEnabled = true;
    private List<Port> ports = new ArrayList<Port>();
    @Nullable
    private String healthCheckPath = "/internal/healthcheck";
    @Nullable
    private String docsPath = "/internal/docs/";
    @Nullable
    private String metricsPath = "/internal/metrics";
    @Nullable
    private InternalServiceProperties internalServices;
    private long gracefulShutdownQuietPeriodMillis = 5000L;
    private long gracefulShutdownTimeoutMillis = 40000L;
    private boolean enableMetrics = true;
    @Nullable
    @NestedConfigurationProperty
    private Ssl ssl;
    @Nullable
    private Compression compression;
    @Nullable
    private Integer workerGroup;
    @Nullable
    private Integer blockingTaskExecutor;
    @Nullable
    private Integer maxNumConnections;
    @Nullable
    private Duration idleTimeout;
    @Nullable
    private Duration pingInterval;
    @Nullable
    private Duration maxConnectionAge;
    @Nullable
    private Integer maxNumRequestsPerConnection;
    @Nullable
    private String http2InitialConnectionWindowSize;
    @Nullable
    private String http2InitialStreamWindowSize;
    @Nullable
    private Long http2MaxStreamsPerConnection;
    @Nullable
    private String http2MaxFrameSize;
    @Nullable
    private String http2MaxHeaderListSize;
    @Nullable
    private String http1MaxInitialLineLength;
    @Nullable
    private String http1MaxHeaderSize;
    @Nullable
    private String http1MaxChunkSize;
    @Nullable
    private AccessLog accessLog;
    @Nullable
    private String accessLogger;
    @Nullable
    private Duration requestTimeout;
    @Nullable
    private String maxRequestLength;
    @Nullable
    private Boolean verboseResponses;
    private boolean enableAutoInjection;

    public List<Port> getPorts() {
        return this.ports;
    }

    public void setPorts(List<Port> ports) {
        this.ports = ports;
    }

    @Nullable
    public String getHealthCheckPath() {
        return this.healthCheckPath;
    }

    public void setHealthCheckPath(@Nullable String healthCheckPath) {
        this.healthCheckPath = healthCheckPath;
    }

    @Nullable
    public String getDocsPath() {
        return this.docsPath;
    }

    public void setDocsPath(@Nullable String docsPath) {
        this.docsPath = docsPath;
    }

    @Nullable
    public String getMetricsPath() {
        return this.metricsPath;
    }

    public void setMetricsPath(@Nullable String metricsPath) {
        this.metricsPath = metricsPath;
    }

    public void setInternalServices(InternalServiceProperties internalServices) {
        this.internalServices = internalServices;
    }

    @Nullable
    public InternalServiceProperties getInternalServices() {
        return this.internalServices;
    }

    public long getGracefulShutdownQuietPeriodMillis() {
        return this.gracefulShutdownQuietPeriodMillis;
    }

    public void setGracefulShutdownQuietPeriodMillis(long gracefulShutdownQuietPeriodMillis) {
        this.gracefulShutdownQuietPeriodMillis = gracefulShutdownQuietPeriodMillis;
    }

    public long getGracefulShutdownTimeoutMillis() {
        return this.gracefulShutdownTimeoutMillis;
    }

    public void setGracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        this.gracefulShutdownTimeoutMillis = gracefulShutdownTimeoutMillis;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public void setEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
    }

    @Nullable
    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    @Nullable
    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    @Nullable
    public Integer getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(@Nullable Integer workerGroup) {
        this.workerGroup = workerGroup;
    }

    @Nullable
    public Integer getBlockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    public void setBlockingTaskExecutor(@Nullable Integer blockingTaskExecutor) {
        this.blockingTaskExecutor = blockingTaskExecutor;
    }

    @Nullable
    public Integer getMaxNumConnections() {
        return this.maxNumConnections;
    }

    public void setMaxNumConnections(@Nullable Integer maxNumConnections) {
        this.maxNumConnections = maxNumConnections;
    }

    @Nullable
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(@Nullable Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Nullable
    public Duration getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(@Nullable Duration pingInterval) {
        this.pingInterval = pingInterval;
    }

    @Nullable
    public Duration getMaxConnectionAge() {
        return this.maxConnectionAge;
    }

    public void setMaxConnectionAge(@Nullable Duration maxConnectionAge) {
        this.maxConnectionAge = maxConnectionAge;
    }

    @Nullable
    public Integer getMaxNumRequestsPerConnection() {
        return this.maxNumRequestsPerConnection;
    }

    public void setMaxNumRequestsPerConnection(@Nullable Integer maxNumRequestsPerConnection) {
        this.maxNumRequestsPerConnection = maxNumRequestsPerConnection;
    }

    @Nullable
    public String getHttp2InitialConnectionWindowSize() {
        return this.http2InitialConnectionWindowSize;
    }

    public void setHttp2InitialConnectionWindowSize(@Nullable String http2InitialConnectionWindowSize) {
        this.http2InitialConnectionWindowSize = http2InitialConnectionWindowSize;
    }

    @Nullable
    public String getHttp2InitialStreamWindowSize() {
        return this.http2InitialStreamWindowSize;
    }

    public void setHttp2InitialStreamWindowSize(@Nullable String http2InitialStreamWindowSize) {
        this.http2InitialStreamWindowSize = http2InitialStreamWindowSize;
    }

    @Nullable
    public Long getHttp2MaxStreamsPerConnection() {
        return this.http2MaxStreamsPerConnection;
    }

    public void setHttp2MaxStreamsPerConnection(@Nullable Long http2MaxStreamsPerConnection) {
        this.http2MaxStreamsPerConnection = http2MaxStreamsPerConnection;
    }

    @Nullable
    public String getHttp2MaxFrameSize() {
        return this.http2MaxFrameSize;
    }

    public void setHttp2MaxFrameSize(@Nullable String http2MaxFrameSize) {
        this.http2MaxFrameSize = http2MaxFrameSize;
    }

    @Nullable
    public String getHttp2MaxHeaderListSize() {
        return this.http2MaxHeaderListSize;
    }

    public void setHttp2MaxHeaderListSize(@Nullable String http2MaxHeaderListSize) {
        this.http2MaxHeaderListSize = http2MaxHeaderListSize;
    }

    @Nullable
    public String getHttp1MaxInitialLineLength() {
        return this.http1MaxInitialLineLength;
    }

    public void setHttp1MaxInitialLineLength(@Nullable String http1MaxInitialLineLength) {
        this.http1MaxInitialLineLength = http1MaxInitialLineLength;
    }

    @Nullable
    public String getHttp1MaxHeaderSize() {
        return this.http1MaxHeaderSize;
    }

    public void setHttp1MaxHeaderSize(@Nullable String http1MaxHeaderSize) {
        this.http1MaxHeaderSize = http1MaxHeaderSize;
    }

    @Nullable
    public String getHttp1MaxChunkSize() {
        return this.http1MaxChunkSize;
    }

    public void setHttp1MaxChunkSize(@Nullable String http1MaxChunkSize) {
        this.http1MaxChunkSize = http1MaxChunkSize;
    }

    @Nullable
    public AccessLog getAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(@Nullable AccessLog accessLog) {
        this.accessLog = accessLog;
    }

    @Nullable
    public String getAccessLogger() {
        return this.accessLogger;
    }

    public void setAccessLogger(@Nullable String accessLogger) {
        this.accessLogger = accessLogger;
    }

    @Nullable
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(@Nullable Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @Nullable
    public String getMaxRequestLength() {
        return this.maxRequestLength;
    }

    public void setMaxRequestLength(@Nullable String maxRequestLength) {
        this.maxRequestLength = maxRequestLength;
    }

    @Nullable
    public Boolean getVerboseResponses() {
        return this.verboseResponses;
    }

    public void setVerboseResponses(@Nullable Boolean verboseResponses) {
        this.verboseResponses = verboseResponses;
    }

    public boolean enableAutoInjection() {
        return this.enableAutoInjection;
    }

    public void setEnableAutoInjection(boolean enableAutoInjection) {
        this.enableAutoInjection = enableAutoInjection;
    }

    public static class InternalServiceProperties
    extends Port {
        @Nullable
        private List<InternalServiceId> include = InternalServiceId.defaultServiceIds();

        @Nullable
        public List<InternalServiceId> getInclude() {
            return this.include;
        }

        public void setInclude(List<InternalServiceId> include) {
            this.include = include;
        }
    }

    public static class Compression {
        private boolean enabled;
        private String[] mimeTypes = new String[]{"text/html", "text/xml", "text/plain", "text/css", "text/javascript", "application/javascript", "application/json", "application/xml"};
        @Nullable
        private String[] excludedUserAgents;
        private String minResponseSize = "1024";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String[] getMimeTypes() {
            return this.mimeTypes;
        }

        public void setMimeTypes(String[] mimeTypes) {
            this.mimeTypes = mimeTypes;
        }

        @Nullable
        public String[] getExcludedUserAgents() {
            return this.excludedUserAgents;
        }

        public void setExcludedUserAgents(String[] excludedUserAgents) {
            this.excludedUserAgents = excludedUserAgents;
        }

        public String getMinResponseSize() {
            return this.minResponseSize;
        }

        public void setMinResponseSize(String minResponseSize) {
            this.minResponseSize = minResponseSize;
        }
    }

    public static class AccessLog {
        private String type = "disabled";
        @Nullable
        private String format;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Nullable
        public String getFormat() {
            return this.format;
        }

        public void setFormat(@Nullable String format) {
            this.format = format;
        }
    }

    public static class Port {
        @Nullable
        private String ip;
        @Nullable
        private String iface;
        private int port;
        @Nullable
        private List<SessionProtocol> protocols;

        @Nullable
        public String getIp() {
            return this.ip;
        }

        public Port setIp(String ip) {
            this.ip = ip;
            return this;
        }

        @Nullable
        public String getIface() {
            return this.iface;
        }

        public Port setIface(String iface) {
            this.iface = iface;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Port setPort(int port) {
            this.port = port;
            return this;
        }

        @Nullable
        public List<SessionProtocol> getProtocols() {
            return this.protocols;
        }

        public Port setProtocols(List<SessionProtocol> protocols) {
            this.protocols = ImmutableList.copyOf(protocols);
            return this;
        }

        public Port setProtocol(SessionProtocol protocol) {
            this.protocols = ImmutableList.of((Object)protocol);
            return this;
        }
    }
}

