/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.aop;

import cn.hutool.json.JSONUtil;
import com.ovopark.aicheck.feign.TokenApi;
import com.ovopark.aicheck.model.auth.TokenValue;
import com.ovopark.aicheck.model.organize.UsersPojo;
import com.ovopark.aicheck.result.BaseResult;
import com.ovopark.aicheck.utils.OvoUserUtils;
import com.ovopark.module.shared.spring.rbac.SessionService;
import com.ovopark.module.shared.spring.rbac.SessionToken;
import com.ovopark.module.shared.spring.rbac.SessionUsersPojo;
import com.ovopark.module.shared.spring.rbac.TokenInvalidException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshExpiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AISessionProvider
implements SessionService.SessionServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(AISessionProvider.class);
    @Autowired
    private TokenApi tokenApi;

    public SessionService get() {
        SessionService sessionService = new SessionService(){

            public SessionToken parseNewToken(String newToken) {
                log.info("=====SessionService-\u8c03\u7528tokenApi.parseNewToken\u5f00\u59cb====={}", (Object)newToken);
                try {
                    BaseResult<TokenValue> responseEntity = AISessionProvider.this.tokenApi.parseToken(newToken);
                    log.info("=====SessionService-\u8c03\u7528tokenApi.parseNewToken\u8fd4\u56de====={}", (Object)JSONUtil.toJsonStr(responseEntity));
                    if (responseEntity == null || responseEntity.getIsError().booleanValue() || responseEntity.getData() == null) {
                        if (responseEntity != null && responseEntity.getIsError().booleanValue()) {
                            String errCode;
                            switch (errCode = responseEntity.getCode() + "") {
                                case "9990001": {
                                    throw new TokenInvalidException();
                                }
                                case "9990002": {
                                    throw new TokenRefreshException();
                                }
                                case "9990003": {
                                    throw new TokenRefreshExpiredException();
                                }
                            }
                        }
                        return null;
                    }
                    TokenValue tokenValue = responseEntity.getData();
                    return AISessionProvider.this.ofToken(tokenValue);
                }
                catch (Exception e) {
                    log.info("=====SessionService-\u8c03\u7528tokenApi.parseNewToken\u5f02\u5e38====={}", (Object)newToken);
                    return null;
                }
            }

            public SessionUsersPojo getUsersById(Integer userId) {
                UsersPojo user = OvoUserUtils.getUserDetail(userId);
                log.info("-----SessionService-\u8c03\u7528getUserById\u7ed3\u679c-----{}", (Object)JSONUtil.toJsonStr((Object)user));
                if (user.getId() != null) {
                    return AISessionProvider.this.ofUser(user);
                }
                return null;
            }
        };
        return sessionService;
    }

    public SessionToken ofToken(TokenValue tokenValue) {
        if (tokenValue == null) {
            return null;
        }
        SessionToken sessionToken = new SessionToken();
        sessionToken.setUserId(tokenValue.getUserId());
        sessionToken.setGroupId(tokenValue.getGroupId());
        sessionToken.setUserName(tokenValue.getUserName());
        sessionToken.setLoginType(tokenValue.getLoginType());
        sessionToken.setTokenExpirationTimestamp(tokenValue.getTokenExpirationTimestamp());
        sessionToken.setRefreshExpirationTimestamp(tokenValue.getRefreshExpirationTimestamp());
        sessionToken.setCreateAtTimestamp(tokenValue.getCreateAtTimestamp());
        sessionToken.setToken(tokenValue.getToken());
        sessionToken.setIsAgency(tokenValue.getIsAgency());
        sessionToken.setTokenExpirationSurplusTimestamp(tokenValue.getTokenExpirationTimestamp());
        sessionToken.setRefreshExpirationSurplusTimestamp(tokenValue.getRefreshExpirationTimestamp());
        return sessionToken;
    }

    public SessionUsersPojo ofUser(UsersPojo users) {
        if (users == null) {
            return null;
        }
        SessionUsersPojo sessionUsersPojo = new SessionUsersPojo();
        sessionUsersPojo.setId(users.getId());
        sessionUsersPojo.setUserName(users.getUserName());
        sessionUsersPojo.setShowName(users.getShowName());
        sessionUsersPojo.setGroupId(users.getGroupId());
        sessionUsersPojo.setDeptIds(users.getDeptIds());
        sessionUsersPojo.setPhone(users.getPhone());
        sessionUsersPojo.setMobilePhone(users.getMobilePhone());
        sessionUsersPojo.setMail(users.getMail());
        sessionUsersPojo.setLocalelan(users.getLocalelan());
        sessionUsersPojo.setUnread(users.getUnread());
        sessionUsersPojo.setActivateCode(users.getActivateCode());
        sessionUsersPojo.setCreaterId(users.getCreaterId());
        sessionUsersPojo.setPrivileges(users.getPrivileges());
        sessionUsersPojo.setIsRegisterUser(users.getIsRegisterUser());
        sessionUsersPojo.setIndicator(users.getIndicator());
        sessionUsersPojo.setUserOrganId(users.getUserOrganId());
        sessionUsersPojo.setIsSingleSign(users.getIsSingleSign());
        sessionUsersPojo.setIsPhoneActivate(users.getIsPhoneActivate());
        sessionUsersPojo.setIsMailActivate(users.getIsMailActivate());
        sessionUsersPojo.setEmployeeNumber(users.getEmployeeNumber());
        sessionUsersPojo.setIsDel(users.getIsDel());
        sessionUsersPojo.setPyName(users.getPyName());
        sessionUsersPojo.setIsAssign(users.getIsAssign());
        sessionUsersPojo.setIsAgency(users.getIsAgency());
        sessionUsersPojo.setHasThumb(users.getHasThumb());
        sessionUsersPojo.setThumbUpdateTime(users.getThumbUpdateTime());
        sessionUsersPojo.setHasScoreConfig(users.getHasScoreConfig());
        sessionUsersPojo.setExceptScoreRank(users.getExceptScoreRank());
        sessionUsersPojo.setCreater(users.getCreater());
        sessionUsersPojo.setIsFrozen(users.getIsFrozen());
        sessionUsersPojo.setDingdingUserId(users.getDingdingUserId());
        sessionUsersPojo.setNationalCode(users.getNationalCode());
        sessionUsersPojo.setThumbUrl(users.getThumbUrl());
        sessionUsersPojo.setStaffImageUrl(users.getStaffImageUrl());
        sessionUsersPojo.setIsSysAdmin(users.getIsSysAdmin());
        sessionUsersPojo.setNeedSms(users.getNeedSms());
        return sessionUsersPojo;
    }
}

