/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.aop;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.aicheck.config.AiSpecialUserConfig;
import com.ovopark.aicheck.exception.CommonException;
import com.ovopark.aicheck.model.auth.Authenticator;
import com.ovopark.aicheck.model.auth.ClientInfo;
import com.ovopark.aicheck.model.auth.Users;
import com.ovopark.aicheck.result.ReturnCode;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.jdk8.JavaxServletRequest;
import com.ovopark.module.shared.spring.SharedRequest;
import com.ovopark.module.shared.spring.rbac.SessionClient;
import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;

public class AuthenticationInterceptor
implements HandlerInterceptor {
    @Autowired
    private SessionClient sessionClient;
    @Autowired
    private AiSpecialUserConfig aiSpecialUserConfig;
    private static final Logger log = LoggerFactory.getLogger(AuthenticationInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String[] s;
        String authorization = request.getHeader("Ovo-Authorization");
        if (StringUtils.isBlank((CharSequence)authorization)) {
            throw new CommonException(ReturnCode.TOKEN_LOST);
        }
        Session session = this.sessionClient.session((SharedRequest)new JavaxServletRequest(request));
        com.ovopark.module.shared.ClientInfo c = session.clientInfo();
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setLocale(c.getLocale());
        clientInfo.setLang(c.getLocaleString());
        clientInfo.setLang(c.getLang());
        clientInfo.setTimeZone(c.getTimeZone());
        if (session.backendToken() != null && (s = session.backendToken().split(" ")).length > 0) {
            clientInfo.setToken(s[0]);
        }
        clientInfo.setFullToken(session.backendToken());
        clientInfo.setClient(c.getClient());
        clientInfo.setPlatform(c.getPlatform());
        clientInfo.setVersion(c.getVersion());
        clientInfo.setRemoteIp(c.getRemoteIp());
        clientInfo.setDeviceName(c.getDeviceName());
        clientInfo.setDeviceSerialNo(c.getDeviceSerialNo());
        clientInfo.setChannel(c.getChannel());
        Users user = new Users();
        user.setId(session.getUserId());
        user.setUserName(session.getUserName());
        user.setGroupId(session.getGroupId());
        user.setLocale(clientInfo.getLocale());
        user.setLocaleLan(clientInfo.getLocale().getLanguage());
        if (this.isNeedSpecialDeal(request.getRequestURI()) && this.aiSpecialUserConfig.getSpecialUserIds().contains(session.getUserId())) {
            Integer enterpriseId = this.getEnterpriseIdFromParams(request);
            user.setGroupId(enterpriseId);
            log.info("=====> aop\u62e6\u622a\uff0c\u8d85\u7ba1\u8d26\u53f7\u8bbe\u7f6e\u7684\u7528\u6237\u4f01\u4e1aid={}", (Object)enterpriseId);
        }
        clientInfo.setUser(user);
        Authenticator.getInstance().setCurrentClient(clientInfo);
        log.info("=====> method\uff1a{}, client\uff1a{}, platform\uff1a{}, groupId\uff1a{}, userId\uff1a{}", new Object[]{request.getRequestURI(), clientInfo.getClient(), clientInfo.getPlatform(), session.getGroupId(), session.getUserId()});
        return true;
    }

    private Integer getEnterpriseIdFromHeader(HttpServletRequest request) {
        String enterpriseId = request.getHeader("enterpriseId");
        if (enterpriseId == null) {
            throw new CommonException(ReturnCode.PARAM_ERROR);
        }
        return Integer.parseInt(enterpriseId);
    }

    private Integer getEnterpriseIdFromParams(HttpServletRequest request) {
        String contentType = request.getContentType();
        log.info("=====> root - Content-Type\uff1a{}", (Object)contentType);
        if (contentType == null) {
            throw new CommonException(ReturnCode.REQUEST_ERROR);
        }
        String fieldValue = null;
        if (contentType.contains("application/json")) {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = request.getReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException e) {
                throw new CommonException(ReturnCode.PARAM_ERROR);
            }
            String jsonString = sb.toString();
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            fieldValue = jsonObject.getString("enterpriseId");
        } else {
            fieldValue = contentType.contains("multipart/form-data") ? request.getParameter("enterpriseId") : (contentType.contains("application/x-www-form-urlencoded") ? request.getParameter("enterpriseId") : request.getParameter("enterpriseId"));
        }
        if (StringUtils.isEmpty((CharSequence)fieldValue)) {
            throw new CommonException(ReturnCode.PARAM_ERROR);
        }
        return Integer.parseInt(fieldValue);
    }

    private boolean isNeedSpecialDeal(String requestURI) {
        if (requestURI.contains("/api/aicheck/annotation/goods/v1/web")) {
            return false;
        }
        return !requestURI.contains("/api/aicheck/user/v1/isAiRoot");
    }
}

