/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;

@Configuration
public class KafkaConfigK2 {
    @ConfigurationProperties(prefix="spring.kafka.k2")
    @Bean
    public KafkaProperties kafkaPropertiesK2() {
        return new KafkaProperties();
    }

    @Bean
    public KafkaTemplate<String, String> kafkaTemplateK2(@Autowired @Qualifier(value="kafkaPropertiesK2") KafkaProperties kafkaPropertiesK2) {
        return new KafkaTemplate(this.producerFactoryK2(kafkaPropertiesK2));
    }

    @Bean(value={"kafkaListenerContainerFactoryK2"})
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> kafkaListenerContainerFactoryK2(@Autowired @Qualifier(value="kafkaPropertiesK2") KafkaProperties kafkaPropertiesK2) {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactoryK2(kafkaPropertiesK2));
        return factory;
    }

    private ConsumerFactory<? super Integer, ? super String> consumerFactoryK2(KafkaProperties kafkaPropertiesK2) {
        return new DefaultKafkaConsumerFactory(kafkaPropertiesK2.buildConsumerProperties());
    }

    private DefaultKafkaProducerFactory<String, String> producerFactoryK2(KafkaProperties kafkaPropertiesK2) {
        return new DefaultKafkaProducerFactory(kafkaPropertiesK2.buildProducerProperties());
    }
}

