/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;

@Configuration
public class KafkaConfigK3 {
    @ConfigurationProperties(prefix="spring.kafka.k3")
    @Bean
    public KafkaProperties kafkaPropertiesK3() {
        return new KafkaProperties();
    }

    @Bean
    public KafkaTemplate<String, String> kafkaTemplateK3(@Autowired @Qualifier(value="kafkaPropertiesK3") KafkaProperties kafkaPropertiesK3) {
        return new KafkaTemplate(this.producerFactoryK3(kafkaPropertiesK3));
    }

    @Bean(value={"kafkaListenerContainerFactoryK3"})
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> kafkaListenerContainerFactoryK3(@Autowired @Qualifier(value="kafkaPropertiesK3") KafkaProperties kafkaPropertiesK3) {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactoryK3(kafkaPropertiesK3));
        return factory;
    }

    private ConsumerFactory<? super Integer, ? super String> consumerFactoryK3(KafkaProperties kafkaPropertiesK3) {
        return new DefaultKafkaConsumerFactory(kafkaPropertiesK3.buildConsumerProperties());
    }

    private DefaultKafkaProducerFactory<String, String> producerFactoryK3(KafkaProperties kafkaPropertiesK3) {
        return new DefaultKafkaProducerFactory(kafkaPropertiesK3.buildProducerProperties());
    }
}

