/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.constant.enums;

import org.apache.commons.lang3.StringUtils;

public enum DeployTypeEnum {
    CLOUD(1, "000", "\u4e91\u7aef", "", null, "\u4e91"),
    A1(2, "100", "\u677f\u7aef-A1\u5e73\u53f0", "A1", 61, "A1"),
    NVR(3, "200", "\u677f\u7aef-Dolphin1-A\u5e73\u53f0", "Dolphin1-A", 20, "NVR"),
    NVR_B(8, "201", "\u677f\u7aef-Dolphin1-B\u5e73\u53f0", "Dolphin1-B", 20, "NVR"),
    NVR_C(10, "203", "\u677f\u7aef-Dolphin1-C\u5e73\u53f0", "Dolphin1-C", 20, "NVR"),
    PC4i(4, "300", "\u677f\u7aef-PC4i\u5e73\u53f0", "", null, "PC4i"),
    PC8_B(5, "301", "\u677f\u7aef-PC8-B\u5e73\u53f0", "", null, "PC8-B"),
    ROBOT(6, "800", "\u677f\u7aef-T1\u5e73\u53f0", "", null, "T1"),
    SC_8(7, "400", "\u677f\u7aef-SC8\u5e73\u53f0", "SC-8", 20, "SC-8");

    private final Integer code;
    private final String algoCode;
    private final String name;
    private final String deviceType;
    private final Integer deviceDeploy;
    private final String mark;

    private DeployTypeEnum(Integer code, String algoCode, String name, String deviceType, Integer deviceDeploy, String mark) {
        this.code = code;
        this.algoCode = algoCode;
        this.name = name;
        this.deviceType = deviceType;
        this.deviceDeploy = deviceDeploy;
        this.mark = mark;
    }

    public String getMark() {
        return this.mark;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public Integer getDeviceDeploy() {
        return this.deviceDeploy;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getAlgoCode() {
        return this.algoCode;
    }

    public static Integer getCodeByDeploy(Integer deviceDeploy) {
        if (deviceDeploy == null) {
            return null;
        }
        for (DeployTypeEnum deployTypeEnum : DeployTypeEnum.values()) {
            if (deployTypeEnum.deviceDeploy == null || !deployTypeEnum.deviceDeploy.equals(deviceDeploy)) continue;
            return deployTypeEnum.getCode();
        }
        return null;
    }

    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (DeployTypeEnum deployTypeEnum : DeployTypeEnum.values()) {
            if (!deployTypeEnum.code.equals(code)) continue;
            return deployTypeEnum.getName();
        }
        return null;
    }

    public static String getMark(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (DeployTypeEnum deployTypeEnum : DeployTypeEnum.values()) {
            if (!deployTypeEnum.algoCode.equals(code)) continue;
            return deployTypeEnum.getMark();
        }
        return null;
    }

    public static String getNameByDevice(String device) {
        if (StringUtils.isBlank((CharSequence)device)) {
            return null;
        }
        for (DeployTypeEnum deployTypeEnum : DeployTypeEnum.values()) {
            if (!StringUtils.isNotEmpty((CharSequence)deployTypeEnum.deviceType) || !device.contains(deployTypeEnum.deviceType)) continue;
            return deployTypeEnum.getAlgoCode();
        }
        return null;
    }
}

