/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.feign;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.google.common.collect.Maps;
import com.ovopark.aicheck.model.gms.TaskIORes;
import com.ovopark.aicheck.properties.GmsTaskProperties;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskIoApi {
    private static final Logger log = LoggerFactory.getLogger(TaskIoApi.class);
    private static String taskIoUrl;
    private static String token;
    private static String checkUrl;
    private static String addTask;
    private static String updateTask;
    private static String deleteTask;
    private static String modelParamsUpdate;
    private static String addTaskForApp;
    private static String deleteTaskForApp;
    @Resource
    private GmsTaskProperties gmsTaskProperties;

    @PostConstruct
    public void init() {
        taskIoUrl = this.gmsTaskProperties.getTaskIoUrl();
        token = this.gmsTaskProperties.getToken();
        checkUrl = this.gmsTaskProperties.getCheckUrl();
        addTask = this.gmsTaskProperties.getAddTask();
        updateTask = this.gmsTaskProperties.getUpdateTask();
        deleteTask = this.gmsTaskProperties.getDeleteTask();
        modelParamsUpdate = this.gmsTaskProperties.getModelParamsUpdate();
        addTaskForApp = this.gmsTaskProperties.getAddTaskForApp();
        deleteTaskForApp = this.gmsTaskProperties.getDeleteTaskForApp();
    }

    public static String add(String json) {
        log.info("-------GMS\u4e0b\u53d1\u4efb\u52a1\u53c2\u6570-------" + json);
        String result = HttpRequest.post((String)(taskIoUrl + addTask)).body(json).execute().body();
        log.info("-------GMS\u4e0b\u53d1\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c-------" + result);
        return result;
    }

    public static String addTaskForApp(String json) {
        log.info("-------AppGMS\u4e0b\u53d1\u4efb\u52a1\u53c2\u6570-------" + json);
        String result = HttpRequest.post((String)(taskIoUrl + addTaskForApp)).body(json).execute().body();
        log.info("-------AppGMS\u4e0b\u53d1\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c-------" + result);
        return result;
    }

    public static String update(String json) {
        log.info("-------\u4e0b\u53d1\u4fee\u6539\u4efb\u52a1\u53c2\u6570-------" + json);
        String result = HttpRequest.post((String)(taskIoUrl + updateTask)).body(json).execute().body();
        log.info("-------\u4e0b\u53d1\u4fee\u6539\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c-------" + result);
        return result;
    }

    public static String delete(Integer taskId) {
        HashMap params = Maps.newHashMap();
        params.put("taskId", taskId);
        String json = JSONUtil.toJsonStr((Object)params);
        log.info("-------GMS\u5220\u9664\u4efb\u52a1\u53c2\u6570-------taskId={}", (Object)taskId);
        log.info("-------GMS\u5220\u9664\u4efb\u52a1\u53c2\u6570url-------" + taskIoUrl + deleteTask);
        String result = HttpRequest.post((String)(taskIoUrl + deleteTask)).body(json).execute().body();
        log.info("-------GMS\u5220\u9664\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c-------" + result);
        return result;
    }

    public static String deleteTaskForApp(Integer taskId) {
        HashMap params = Maps.newHashMap();
        params.put("taskId", taskId);
        String json = JSONUtil.toJsonStr((Object)params);
        log.info("-------appGMS\u5220\u9664\u4efb\u52a1\u53c2\u6570-------taskId={}", (Object)taskId);
        String result = HttpRequest.post((String)(taskIoUrl + deleteTaskForApp)).body(json).execute().body();
        log.info("-------appGMS\u5220\u9664\u4efb\u52a1\u8fd4\u56de\u7ed3\u679c-------" + result);
        return result;
    }

    public static TaskIORes check(String json) {
        log.info("-------\u5355\u6b21\u8c03\u7528\u8bc6\u522b\u53c2\u6570-------" + json + " url : " + checkUrl);
        String result = ((HttpRequest)HttpRequest.post((String)checkUrl).header("Token", token)).body(json).execute().body();
        log.info("-------\u5355\u6b21\u8c03\u7528\u8bc6\u522b\u8fd4\u56de\u7ed3\u679c-------" + result);
        TaskIORes taskIORes = (TaskIORes)JSONUtil.toBean((String)result, TaskIORes.class);
        return taskIORes;
    }

    public static String updateForOneDevice(String json) {
        log.info("-------\u4fee\u6539\u5355\u4e2a\u8bbe\u5907\u7684\u4fe1\u606f\uff0c\u91cd\u65b0\u4e0b\u53d1\u4efb\u52a1GMS-------" + json);
        String result = HttpRequest.post((String)(taskIoUrl + modelParamsUpdate)).body(json).execute().body();
        log.info("-------\u4fee\u6539\u5355\u4e2a\u8bbe\u5907\u7684\u4fe1\u606f\uff0c\u91cd\u65b0\u4e0b\u53d1\u4efb\u52a1GMS-------" + result);
        return result;
    }
}

