/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.sharding;

import com.ovopark.aicheck.context.SpringContextAware;
import com.ovopark.aicheck.sharding.enums.ShardingTableCacheEnum;
import com.ovopark.aicheck.utils.DateUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sharding.algorithm.config.AlgorithmProvidedShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ShardingAlgorithmTool {
    private static final Logger log = LoggerFactory.getLogger(ShardingAlgorithmTool.class);
    private static final String TABLE_SPLIT_SYMBOL = "_";
    private static final int MAX_QUERY_MONTH = 3;
    private static final Environment ENV = SpringContextAware.getApplicationContext().getEnvironment();
    private static final String DB_URL = ENV.getProperty("spring.shardingsphere.datasource.master.url");
    private static final String DB_USERNAME = ENV.getProperty("spring.shardingsphere.datasource.master.username");
    private static final String DB_PASSWORD = ENV.getProperty("spring.shardingsphere.datasource.master.password");

    public static String getShardingTableAndCreate(ShardingTableCacheEnum logicTable, String actualTableName) {
        if (logicTable.resultTableNamesCache().contains(actualTableName)) {
            return actualTableName;
        }
        boolean isSuccess = ShardingAlgorithmTool.createShardingTable(logicTable, actualTableName);
        return isSuccess ? actualTableName : logicTable.logicTableName();
    }

    public static void actualShardingTableLoad() {
        Arrays.stream(ShardingTableCacheEnum.values()).forEach(ShardingAlgorithmTool::actualTableCacheAndReload);
    }

    public static List<String> actualTableCacheAndReload(ShardingTableCacheEnum logicTable) {
        List<String> tableNameList = ShardingAlgorithmTool.getAllTableNameBySchema(logicTable);
        ShardingAlgorithmTool.actualDataNodesRefresh(logicTable.logicTableName(), new LinkedHashSet<String>(tableNameList));
        logicTable.resultTableNamesCache().clear();
        logicTable.resultTableNamesCache().addAll(tableNameList);
        return tableNameList;
    }

    public static List<String> getAllTableNameBySchema(ShardingTableCacheEnum logicTable) {
        ArrayList<String> tableNames = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)DB_URL) || StringUtils.isEmpty((CharSequence)DB_USERNAME) || StringUtils.isEmpty((CharSequence)DB_PASSWORD)) {
            log.error(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0cURL:{}, username:{}, password:{}", new Object[]{DB_URL, DB_USERNAME, DB_PASSWORD});
            throw new ShardingSphereException(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
        }
        String currYearMonth = DateUtils.getCurrYearMonth();
        try (Connection conn = DriverManager.getConnection(DB_URL, DB_USERNAME, DB_PASSWORD);
             Statement st = conn.createStatement();){
            String logicTableName = logicTable.logicTableName();
            try (ResultSet rs = st.executeQuery("show TABLES like '" + logicTableName + TABLE_SPLIT_SYMBOL + "20%'");){
                while (rs.next()) {
                    String suffix;
                    long diffValue;
                    String tableName = rs.getString(1);
                    if (tableName == null || !tableName.matches(String.format("^(%s\\d{6})$", logicTableName + TABLE_SPLIT_SYMBOL)) || (diffValue = DateUtils.get2YearMonthDiffCount(suffix = tableName.replace(logicTableName + TABLE_SPLIT_SYMBOL, ""), currYearMonth)) > 3L) continue;
                    tableNames.add(tableName);
                }
            }
        }
        catch (SQLException e) {
            log.error(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ShardingSphereException(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[]{e.getMessage()});
        }
        return tableNames;
    }

    public static void actualDataNodesRefresh(String logicTableName, Set<String> tableNamesCache) {
        try {
            String dbName = "master";
            log.info(">>>>>>>>>> \u3010\u5206\u7247\u8868\u3011\u66f4\u65b0\u8868{}\u914d\u7f6e\uff0ctableNamesCache:{}", (Object)logicTableName, tableNamesCache);
            String newActualDataNodes = tableNamesCache.stream().map(o -> String.format("%s.%s", dbName, o)).collect(Collectors.joining(","));
            ShardingSphereDataSource shardingSphereDataSource = SpringContextAware.getBean(ShardingSphereDataSource.class);
            ShardingAlgorithmTool.updateShardRuleActualDataNodes(shardingSphereDataSource, logicTableName, newActualDataNodes);
        }
        catch (Exception e) {
            log.error(">>>>>>>>>> \u521d\u59cb\u5316 \u52a8\u6001\u8868\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void updateShardRuleActualDataNodes(ShardingSphereDataSource dataSource, String logicTableName, String newActualDataNodes) {
        ContextManager contextManager = dataSource.getContextManager();
        String schemaName = "logic_db";
        LinkedList<AlgorithmProvidedShardingRuleConfiguration> newRuleConfigList = new LinkedList<AlgorithmProvidedShardingRuleConfiguration>();
        Collection oldRuleConfigList = dataSource.getContextManager().getMetaDataContexts().getMetaData(schemaName).getRuleMetaData().getConfigurations();
        for (RuleConfiguration oldRuleConfig : oldRuleConfigList) {
            if (!(oldRuleConfig instanceof AlgorithmProvidedShardingRuleConfiguration)) continue;
            AlgorithmProvidedShardingRuleConfiguration oldAlgorithmConfig = (AlgorithmProvidedShardingRuleConfiguration)oldRuleConfig;
            AlgorithmProvidedShardingRuleConfiguration newAlgorithmConfig = new AlgorithmProvidedShardingRuleConfiguration();
            LinkedList newTableRuleConfigList = new LinkedList();
            Collection oldTableRuleConfigList = oldAlgorithmConfig.getTables();
            oldTableRuleConfigList.forEach(oldTableRuleConfig -> {
                if (logicTableName.equals(oldTableRuleConfig.getLogicTable())) {
                    ShardingTableRuleConfiguration newTableRuleConfig = new ShardingTableRuleConfiguration(oldTableRuleConfig.getLogicTable(), newActualDataNodes);
                    newTableRuleConfig.setTableShardingStrategy(oldTableRuleConfig.getTableShardingStrategy());
                    newTableRuleConfig.setDatabaseShardingStrategy(oldTableRuleConfig.getDatabaseShardingStrategy());
                    newTableRuleConfig.setKeyGenerateStrategy(oldTableRuleConfig.getKeyGenerateStrategy());
                    newTableRuleConfigList.add(newTableRuleConfig);
                } else {
                    newTableRuleConfigList.add(oldTableRuleConfig);
                }
            });
            newAlgorithmConfig.setTables(newTableRuleConfigList);
            newAlgorithmConfig.setAutoTables(oldAlgorithmConfig.getAutoTables());
            newAlgorithmConfig.setBindingTableGroups(oldAlgorithmConfig.getBindingTableGroups());
            newAlgorithmConfig.setBroadcastTables(oldAlgorithmConfig.getBroadcastTables());
            newAlgorithmConfig.setDefaultDatabaseShardingStrategy(oldAlgorithmConfig.getDefaultDatabaseShardingStrategy());
            newAlgorithmConfig.setDefaultTableShardingStrategy(oldAlgorithmConfig.getDefaultTableShardingStrategy());
            newAlgorithmConfig.setDefaultKeyGenerateStrategy(oldAlgorithmConfig.getDefaultKeyGenerateStrategy());
            newAlgorithmConfig.setDefaultShardingColumn(oldAlgorithmConfig.getDefaultShardingColumn());
            newAlgorithmConfig.setShardingAlgorithms(oldAlgorithmConfig.getShardingAlgorithms());
            newAlgorithmConfig.setKeyGenerators(oldAlgorithmConfig.getKeyGenerators());
            newRuleConfigList.add(newAlgorithmConfig);
        }
        contextManager.alterRuleConfiguration(schemaName, newRuleConfigList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createShardingTable(ShardingTableCacheEnum logicTable, String actualTableName) {
        String month = actualTableName.replace(logicTable.logicTableName() + TABLE_SPLIT_SYMBOL, "");
        YearMonth shardingMonth = YearMonth.parse(month, DateTimeFormatter.ofPattern("yyyyMM"));
        if (!YearMonth.now().equals(shardingMonth)) {
            log.warn(">>>>>>>>>> \u3010\u5206\u7247\u8868\u3011\u521b\u5efa\u5206\u7247\u8868\u5f02\u5e38\uff1a\u65e5\u671f\u4e0d\u5408\u6cd5\uff0c\u5f85\u521b\u5efa\u5206\u8868\u4e3a:{}", (Object)actualTableName);
            return false;
        }
        String string = logicTable.logicTableName().intern();
        synchronized (string) {
            if (logicTable.resultTableNamesCache().contains(actualTableName)) {
                return false;
            }
            ShardingAlgorithmTool.executeSql(Collections.singletonList("CREATE TABLE IF NOT EXISTS `" + actualTableName + "` LIKE `" + logicTable.logicTableName() + "`;"));
            ShardingAlgorithmTool.updateAutoIncrement(logicTable.logicTableName(), month, actualTableName);
            ShardingAlgorithmTool.actualTableCacheAndReload(logicTable);
        }
        return true;
    }

    private static void executeSql(List<String> sqlList) {
        if (StringUtils.isEmpty((CharSequence)DB_URL) || StringUtils.isEmpty((CharSequence)DB_USERNAME) || StringUtils.isEmpty((CharSequence)DB_PASSWORD)) {
            log.error(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0cURL:{}, username:{}, password:{}", new Object[]{DB_URL, DB_USERNAME, DB_PASSWORD});
            throw new ShardingSphereException(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
        }
        try (Connection conn = DriverManager.getConnection(DB_URL, DB_USERNAME, DB_PASSWORD);){
            try (Statement st = conn.createStatement();){
                conn.setAutoCommit(false);
                for (String sql : sqlList) {
                    st.execute(sql);
                }
            }
            catch (Exception e) {
                conn.rollback();
                log.error(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u6570\u636e\u8868\u521b\u5efa\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
                throw new ShardingSphereException(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u6570\u636e\u8868\u521b\u5efa\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
            }
        }
        catch (SQLException e) {
            log.error(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0cexecuteSql\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ShardingSphereException(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
        }
    }

    private static void updateAutoIncrement(String logicTableName, String month, String actualTableName) {
        String lastActualTableName = logicTableName + TABLE_SPLIT_SYMBOL + DateUtils.getLastYearMonth(month);
        try (Connection connection = DriverManager.getConnection(DB_URL, DB_USERNAME, DB_PASSWORD);){
            try (Statement st = connection.createStatement();){
                ResultSet rs = st.executeQuery("SELECT MAX(id) FROM " + lastActualTableName);
                if (rs.next()) {
                    Long lastMaxId = rs.getLong(1);
                    st.executeUpdate("ALTER TABLE " + actualTableName + " AUTO_INCREMENT = " + (lastMaxId + 1000L));
                }
            }
            catch (SQLException e) {
                log.error(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u83b7\u53d6\u548c\u66f4\u65b0\u81ea\u589e\u4e3b\u952e\u8d77\u59cb\u503c\u5f02\u5e38\uff0c\u5f53\u524d\u8868\u540d\uff1a{}\uff0c\u539f\u56e0\uff1a{}", (Object)actualTableName, (Object)e.getMessage());
                connection.rollback();
                throw new ShardingSphereException(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u6570\u636e\u8868\u521b\u5efa\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
            }
        }
        catch (Exception e) {
            log.error(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0cupdateAutoIncrement\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ShardingSphereException(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
        }
    }
}

