/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.sharding;

import com.google.common.collect.Range;
import com.ovopark.aicheck.sharding.ShardingAlgorithmTool;
import com.ovopark.aicheck.sharding.enums.ShardingTableCacheEnum;
import com.ovopark.aicheck.utils.DateUtils;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeShardingAlgorithm
implements StandardShardingAlgorithm<Date> {
    private static final Logger log = LoggerFactory.getLogger(TimeShardingAlgorithm.class);
    private static final DateTimeFormatter TABLE_SHARD_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMM");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss");
    private final String TABLE_SPLIT_SYMBOL = "_";

    public String doSharding(Collection<String> tableNames, PreciseShardingValue<Date> preciseShardingValue) {
        String logicTableName = preciseShardingValue.getLogicTableName();
        ShardingTableCacheEnum logicTable = ShardingTableCacheEnum.of(logicTableName);
        if (logicTable == null) {
            log.error(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u7cbe\u786e\u5206\u7247\u9519\u8bef\uff0c\u5e94\u5206\u8868\u96c6\u5408\uff1a{}\uff0c\u903b\u8f91\u8868\uff1a{}", ShardingTableCacheEnum.logicTableNames(), (Object)logicTableName);
            throw new ShardingSphereException(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u7cbe\u786e\u5206\u7247\u9519\u8bef\uff0c\u903b\u8f91\u8868\u4e0d\u5b58\u5728\uff1a{}", new Object[]{logicTableName});
        }
        log.info(">>>>>>>>>> \u3010\u5206\u8868\u3011\u7cbe\u786e\u5206\u7247\uff0c\u8282\u70b9\u914d\u7f6e\u8868\u540d\uff1a{}\uff0c\u6570\u636e\u5e93\u7f13\u5b58\u8868\u540d\uff1a{}", tableNames, logicTable.resultTableNamesCache());
        Date dateTime = (Date)preciseShardingValue.getValue();
        String actualTableName = logicTableName + "_" + this.dateOrDateStrToLocal(dateTime).format(TABLE_SHARD_TIME_FORMATTER);
        String resultTable = ShardingAlgorithmTool.getShardingTableAndCreate(logicTable, actualTableName);
        if (!tableNames.contains(actualTableName) && !logicTableName.equals(resultTable)) {
            tableNames.add(actualTableName);
        }
        return resultTable;
    }

    public Collection<String> doSharding(Collection<String> tableNames, RangeShardingValue<Date> rangeShardingValue) {
        List<String> tableNameList;
        String logicTableName = rangeShardingValue.getLogicTableName();
        ShardingTableCacheEnum logicTable = ShardingTableCacheEnum.of(logicTableName);
        if (logicTable == null) {
            log.error(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u8303\u56f4\u5206\u7247\u9519\u8bef\uff0clogicTableNames\uff1a{}\uff0clogicTableName:{}", ShardingTableCacheEnum.logicTableNames(), (Object)logicTableName);
            throw new ShardingSphereException(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u8303\u56f4\u5206\u7247\u9519\u8bef\uff0c\u903b\u8f91\u8868\u4e0d\u5b58\u5728\uff1a{}", new Object[]{logicTableName});
        }
        log.info(">>>>>>>>>> \u3010\u5206\u8868\u3011\u8303\u56f4\u5206\u7247\uff0c\u8282\u70b9\u914d\u7f6e\u8868\u540d\uff1a{}\uff0c\u6570\u636e\u5e93\u7f13\u5b58\u8868\u540d\uff1a{}", tableNames, logicTable.resultTableNamesCache());
        Range valueRange = rangeShardingValue.getValueRange();
        boolean hasLowerBound = valueRange.hasLowerBound();
        boolean hasUpperBound = valueRange.hasUpperBound();
        Set<String> tableNameCache = logicTable.resultTableNamesCache();
        LocalDateTime min = hasLowerBound ? this.dateOrDateStrToLocal(valueRange.lowerEndpoint()) : this.getLowerEndpoint(tableNameCache);
        LocalDateTime max = hasUpperBound ? this.dateOrDateStrToLocal(valueRange.upperEndpoint()) : this.getUpperEndpoint(tableNameCache);
        LinkedHashSet<String> resultTableNames = new LinkedHashSet<String>();
        while (min.isBefore(max) || min.equals(max)) {
            String tableName = logicTableName + "_" + min.format(TABLE_SHARD_TIME_FORMATTER);
            resultTableNames.add(tableName);
            min = min.plusDays(1L);
        }
        List<String> actualTableNames = resultTableNames.stream().filter(tableNameCache::contains).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(actualTableNames) && CollectionUtils.isNotEmpty(tableNameList = ShardingAlgorithmTool.actualTableCacheAndReload(logicTable))) {
            actualTableNames = resultTableNames.stream().filter(tableNameList::contains).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(actualTableNames)) {
                actualTableNames.add(logicTable.logicTableName());
            }
        }
        actualTableNames.sort(Comparator.reverseOrder());
        return actualTableNames;
    }

    public void init() {
    }

    public String getType() {
        return null;
    }

    private LocalDateTime dateOrDateStrToLocal(Object objDate) {
        if (objDate instanceof Date) {
            return ((Date)objDate).toInstant().atZone(ZoneOffset.of("+8")).toLocalDateTime();
        }
        Date date = DateUtils.parse(objDate.toString());
        return date.toInstant().atZone(ZoneOffset.of("+8")).toLocalDateTime();
    }

    private LocalDateTime getLowerEndpoint(Collection<String> tableNames) {
        Optional<LocalDateTime> optional = tableNames.stream().map(o -> LocalDateTime.parse(o.substring(o.lastIndexOf("_") + 1) + "01 00:00:00", DATE_TIME_FORMATTER)).min(Comparator.comparing(Function.identity()));
        if (optional.isPresent()) {
            return optional.get();
        }
        log.error(">>>>>>>>>> \u3010\u5206\u8868\u3011\u83b7\u53d6\u6570\u636e\u6700\u5c0f\u5206\u8868\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0ctableName\uff1a{}", tableNames);
        throw new ShardingSphereException(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u8303\u56f4\u5206\u7247\u9519\u8bef\uff0c\u83b7\u53d6\u6570\u636e\u6700\u5c0f\u5206\u8868\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
    }

    private LocalDateTime getUpperEndpoint(Collection<String> tableNames) {
        Optional<LocalDateTime> optional = tableNames.stream().map(o -> LocalDateTime.parse(o.substring(o.lastIndexOf("_") + 1) + "01 00:00:00", DATE_TIME_FORMATTER)).max(Comparator.comparing(Function.identity()));
        if (optional.isPresent()) {
            return optional.get();
        }
        log.error(">>>>>>>>>> \u3010\u5206\u8868\u3011\u83b7\u53d6\u6570\u636e\u6700\u5927\u5206\u8868\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0ctableName\uff1a{}", tableNames);
        throw new ShardingSphereException(">>>>>>>>>>ShardingSphere\u7ec4\u4ef6\u8303\u56f4\u5206\u7247\u9519\u8bef\uff0c\u83b7\u53d6\u6570\u636e\u6700\u5927\u5206\u8868\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
    }
}

