/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.sharding.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum ShardingTableCacheEnum {
    AI_CHECK_TASK_LOG("is_ai_check_task_log", new HashSet<String>()),
    AI_CHECK_TASK_LOG_MEMBER("is_ai_check_task_log_member", new HashSet<String>());

    private final String logicTableName;
    private final Set<String> resultTableNamesCache;
    private static Map<String, ShardingTableCacheEnum> valueMap;

    private ShardingTableCacheEnum(String logicTableName, Set<String> resultTableNamesCache) {
        this.logicTableName = logicTableName;
        this.resultTableNamesCache = resultTableNamesCache;
    }

    public static ShardingTableCacheEnum of(String value) {
        return valueMap.get(value);
    }

    public String logicTableName() {
        return this.logicTableName;
    }

    public Set<String> resultTableNamesCache() {
        return this.resultTableNamesCache;
    }

    public static Set<String> logicTableNames() {
        return valueMap.keySet();
    }

    public String toString() {
        return "ShardingTableCacheEnum{logicTableName='" + this.logicTableName + '\'' + ", resultTableNamesCache=" + this.resultTableNamesCache + '}';
    }

    static {
        valueMap = new HashMap<String, ShardingTableCacheEnum>();
        Arrays.stream(ShardingTableCacheEnum.values()).forEach(o -> valueMap.put(o.logicTableName, (ShardingTableCacheEnum)((Object)o)));
    }
}

