/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import java.time.LocalDateTime;

public class CronUtils {
    public static String localDateTimeToCron(LocalDateTime dateTime) {
        if (dateTime == null) {
            throw new IllegalArgumentException("LocalDateTime cannot be null");
        }
        return String.format("%d %d %d %d %d ?", dateTime.getSecond(), dateTime.getMinute(), dateTime.getHour(), dateTime.getDayOfMonth(), dateTime.getMonthValue(), CronUtils.getCronDayOfWeek(dateTime.getDayOfWeek().getValue()));
    }

    public static String dailyCron(LocalDateTime dateTime) {
        if (dateTime == null) {
            throw new IllegalArgumentException("LocalDateTime cannot be null");
        }
        return String.format("%d %d %d * * ?", dateTime.getSecond(), dateTime.getMinute(), dateTime.getHour());
    }

    public static String monthlyCron(LocalDateTime dateTime) {
        if (dateTime == null) {
            throw new IllegalArgumentException("LocalDateTime cannot be null");
        }
        return String.format("%d %d %d %d * ?", dateTime.getSecond(), dateTime.getMinute(), dateTime.getHour(), dateTime.getDayOfMonth());
    }

    public static String yearlyCron(LocalDateTime dateTime) {
        if (dateTime == null) {
            throw new IllegalArgumentException("LocalDateTime cannot be null");
        }
        return String.format("%d %d %d %d %d ?", dateTime.getSecond(), dateTime.getMinute(), dateTime.getHour(), dateTime.getDayOfMonth(), dateTime.getMonthValue());
    }

    private static int getCronDayOfWeek(int dayOfWeek) {
        if (dayOfWeek == 1) {
            return 2;
        }
        if (dayOfWeek == 2) {
            return 3;
        }
        if (dayOfWeek == 3) {
            return 4;
        }
        if (dayOfWeek == 4) {
            return 5;
        }
        if (dayOfWeek == 5) {
            return 6;
        }
        if (dayOfWeek == 6) {
            return 7;
        }
        return 1;
    }

    public static void main(String[] args) {
        LocalDateTime dateTime = LocalDateTime.of(2023, 10, 5, 14, 30, 25);
        System.out.println("\u6307\u5b9a\u65f6\u95f4\u6267\u884c\u4e00\u6b21: " + CronUtils.localDateTimeToCron(dateTime));
        System.out.println("\u6bcf\u5929\u540c\u4e00\u65f6\u95f4\u6267\u884c: " + CronUtils.dailyCron(dateTime));
        System.out.println("\u6bcf\u6708\u540c\u4e00\u5929\u6267\u884c: " + CronUtils.monthlyCron(dateTime));
        System.out.println("\u6bcf\u5e74\u540c\u6708\u540c\u65e5\u6267\u884c: " + CronUtils.yearlyCron(dateTime));
    }
}

