/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import cn.hutool.core.convert.Convert;
import com.ovopark.aicheck.constant.enums.WeekEnum;
import com.ovopark.aicheck.utils.WeekRange;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DateUtils {
    public static String FORMAT_SHORT = "yyyy-MM-dd";
    public static String FORMAT_SHORT_SIMPLE = "yyyyMMdd";
    public static String FORMAT_YEAR_MONTH = "yyyyMM";
    public static String FORMAT_TIME = "HH:mm:ss";
    public static String FORMAT_TIME_SIMPLE = "HHmmss";
    public static String FORMAT_LONG = "yyyy-MM-dd HH:mm:ss";
    public static String FORMAT_FULL = "yyyy-MM-dd HH:mm:ss.S";
    public static String FORMAT_SHORT_CN = "yyyy\u5e74MM\u6708dd";
    public static String FORMAT_LONG_CN = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";
    public static String FORMAT_LONG_ABBR = "yyyyMMddHHmmss";
    public static final String LINK_DATABASE_DATE_MSEL = "yyyyMMddHHmmssSSS";
    public static final String FORMAT_ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    public static String FORMAT_FULL_CN = "yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2SSS\u6beb\u79d2";

    public static String getNowStr() {
        return DateUtils.getDateStr(new Date(), FORMAT_SHORT_SIMPLE);
    }

    public static String getNowStr_S() {
        return DateUtils.getDateStr(new Date(), FORMAT_LONG_ABBR);
    }

    public static String getNowStr_MS() {
        return DateUtils.getDateStr(new Date(), LINK_DATABASE_DATE_MSEL);
    }

    public static String getDateStr(Date date, String formatStr) {
        SimpleDateFormat fomate = new SimpleDateFormat(formatStr);
        return fomate.format(date);
    }

    public static String getDatePattern() {
        return FORMAT_LONG;
    }

    public static String getNow() {
        return DateUtils.format(new Date());
    }

    public static String getNow(String format) {
        return DateUtils.format(new Date(), format);
    }

    public static Date formatDate(Date date) {
        String str = DateUtils.format(date, FORMAT_LONG);
        return DateUtils.parse(str, FORMAT_LONG);
    }

    public static String format(Date date) {
        return DateUtils.format(date, DateUtils.getDatePattern());
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static String formatTime(Time time, String pattern) {
        String returnValue = "";
        if (time != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(time);
        }
        return returnValue;
    }

    public static Date parse(String strDate) {
        return DateUtils.parse(strDate, DateUtils.getDatePattern());
    }

    public static Date getFirstDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(7, calendar.getFirstDayOfWeek());
        return calendar.getTime();
    }

    public static Date getFirstDayOfMon(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        date = cal.getTime();
        return date;
    }

    public static Date getYesterday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -1);
        date = cal.getTime();
        return date;
    }

    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, n);
        return cal.getTime();
    }

    public static Date addSecond(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, n);
        return cal.getTime();
    }

    public static String getTimeString() {
        Calendar calendar = Calendar.getInstance();
        return Convert.toStr((Object)(calendar.getTimeInMillis() / 1000L));
    }

    public static int countHours(Date date1, Date date2) {
        int hours = (int)((date2.getTime() - date1.getTime()) / 3600000L);
        return hours;
    }

    public static int countDays(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    public static Date getStartTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Long getSecBetweenTwoDate(Date startDate, Date endDate) {
        long a = startDate.getTime();
        long b = endDate.getTime();
        Long c = (b - a) / 1000L;
        return c;
    }

    public static List<String> getBetweenTwoDateStr(String startStr, String endStr) {
        ArrayList<String> result = new ArrayList<String>();
        Date begin = DateUtils.parse(startStr, FORMAT_SHORT);
        Date end = DateUtils.parse(endStr, FORMAT_SHORT);
        if (end.before(begin)) {
            return result;
        }
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(begin);
        while (begin.getTime() <= end.getTime()) {
            result.add(DateUtils.format(tempStart.getTime(), FORMAT_SHORT));
            tempStart.add(6, 1);
            begin = tempStart.getTime();
        }
        return result;
    }

    public static String getCurrentTimeLaterOrBefore(Date date, int unit, int value, String formatStr) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(unit, value);
        return format.format(cal.getTime());
    }

    public static Boolean timeDetermine(String createTime, Date startTime, Integer frequency) {
        Date endTime = DateUtils.addMinute(startTime, frequency);
        Date nowTime = DateUtils.parse(createTime);
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static Boolean timeDetermineBySecond(String createTime, Date startTime, Integer frequency) {
        Date endTime = DateUtils.addSecond(startTime, frequency);
        Date nowTime = DateUtils.parse(createTime);
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static Date getAssignDate(Date date, String time) {
        String dateStr = DateUtils.getDateStr(date, FORMAT_SHORT) + " " + time;
        return DateUtils.parse(dateStr, FORMAT_LONG);
    }

    public static String getHHMMSS(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date).split(" ")[1];
    }

    public static Date getAssignShortDate(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        String dateEndStr = DateUtils.getDateStr(cal.getTime(), FORMAT_SHORT);
        return DateUtils.parse(dateEndStr, FORMAT_SHORT);
    }

    public static Time strToTime(String strDate) {
        String str = strDate;
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        Date d = null;
        try {
            d = format.parse(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Time(d.getTime());
    }

    public static int getWeeks(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        String calStr1 = DateUtils.format(cal.getTime(), FORMAT_LONG);
        cal.set(7, 2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String calStr = DateUtils.format(cal.getTime(), FORMAT_LONG);
        int dayOfWeek = cal.get(7);
        int weekDay = dayOfWeek - 1;
        if (gregorianCalendar.isLeapYear(year)) {
            if (weekDay == 5 || weekDay == 4) {
                return 53;
            }
            return 52;
        }
        if (weekDay == 5) {
            return 53;
        }
        return 52;
    }

    public static String judgementWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return WeekEnum.getWeekDesc(dayOfWeek);
    }

    public static Date getChinaFirstWeekDay(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1 || dayOfWeek >= 5) {
            return DateUtils.getNextWeekMonday(cal.getTime());
        }
        return DateUtils.getThisWeekMonday(cal.getTime());
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getThisWeekMonday(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static Date getThisWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date getThisWeekSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        cal.set(5, cal.get(5) + 6);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static String addMinuteStr(String date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.parse(date));
        cal.add(12, n);
        Date calDate = cal.getTime();
        return DateUtils.format(calDate);
    }

    public static String addSecondStr(String date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.parse(date));
        cal.add(13, n);
        Date calDate = cal.getTime();
        return DateUtils.format(calDate);
    }

    public static int daysBetweenAndOne(Date date1, Date date2) {
        int count = 0;
        count = Math.abs((int)((date1.getTime() - date2.getTime()) / 86400000L));
        return count + 1;
    }

    public static long daysBetween(LocalDateTime start, LocalDateTime end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3anull");
        }
        return ChronoUnit.DAYS.between(start, end);
    }

    public static Date minusMonthsFirstDay(Date date, int n) {
        Instant dateInstant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = dateInstant.atZone(zoneId).toLocalDate();
        LocalDate lastMonth = localDate.minusMonths(n);
        LocalDate firstLocalDay = lastMonth.with(TemporalAdjusters.firstDayOfMonth());
        Instant instant = firstLocalDay.atStartOfDay().atZone(zoneId).toInstant();
        Date firstDay = Date.from(instant);
        return firstDay;
    }

    public static Date minusMonthsEndDay(Date date, int n) {
        Instant dateInstant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = dateInstant.atZone(zoneId).toLocalDate();
        LocalDate lastMonth = localDate.minusMonths(n);
        LocalDate endLocalDay = lastMonth.with(TemporalAdjusters.lastDayOfMonth());
        Instant instant = endLocalDay.atStartOfDay().atZone(zoneId).toInstant();
        Date endDay = Date.from(instant);
        return endDay;
    }

    public static String getHourPeriod(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int period = calendar.get(11);
        return String.valueOf(period);
    }

    public static String getLastYearMonth(String currYearMonth) {
        Date date = DateUtils.parse(currYearMonth, "yyyyMM");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) - 1);
        date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        return format.format(date);
    }

    public static String getCurrYearMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        return format.format(new Date());
    }

    public static long get2YearMonthDiffCount(String yearMonthBefore, String yearMonthAfter) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_YEAR_MONTH);
        YearMonth yearMonth1 = YearMonth.parse(yearMonthBefore, formatter);
        YearMonth yearMonth2 = YearMonth.parse(yearMonthAfter, formatter);
        long diffMonthCount = ChronoUnit.MONTHS.between(yearMonth1, yearMonth2);
        return Math.abs(diffMonthCount);
    }

    public static LocalDateTime convertToLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static String formatLocalDateTime(LocalDateTime date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return date.now().format(formatter);
    }

    public static Date convertToDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getNextDayXClock(Date date, int x) {
        LocalDateTime localDateTime = DateUtils.convertToLocalDateTime(date);
        LocalDateTime nextDay7AM = localDateTime.plusDays(1L).withHour(x).withMinute(0).withSecond(0).withNano(0);
        return DateUtils.convertToDate(nextDay7AM);
    }

    public static Date getNextWeekMondayXClock(Date date, int x) {
        LocalDateTime localDateTime = DateUtils.convertToLocalDateTime(date);
        LocalDateTime nextWeekMondayXClock = localDateTime.plusWeeks(1L).with(DayOfWeek.MONDAY).withHour(x).withMinute(0).withSecond(0).withNano(0);
        return DateUtils.convertToDate(nextWeekMondayXClock);
    }

    public static Date getNextMonthFirstDayXClock(Date date, int x) {
        LocalDateTime localDateTime = DateUtils.convertToLocalDateTime(date);
        LocalDateTime nextMonthFirstDayXClock = localDateTime.plusMonths(1L).with(TemporalAdjusters.firstDayOfMonth()).withHour(x).withMinute(0).withSecond(0).withNano(0);
        return DateUtils.convertToDate(nextMonthFirstDayXClock);
    }

    public static Date getNextQuarterFirstDayXClock(Date date, int x) {
        int nextQuarterStartMonth;
        LocalDateTime localDateTime = DateUtils.convertToLocalDateTime(date);
        int currentMonth = localDateTime.getMonthValue();
        if (currentMonth <= 3) {
            nextQuarterStartMonth = 4;
        } else if (currentMonth <= 6) {
            nextQuarterStartMonth = 7;
        } else if (currentMonth <= 9) {
            nextQuarterStartMonth = 10;
        } else {
            nextQuarterStartMonth = 1;
            localDateTime = localDateTime.plusYears(1L);
        }
        LocalDateTime nextQuarterFirstDayXClock = localDateTime.withMonth(nextQuarterStartMonth).with(TemporalAdjusters.firstDayOfMonth()).withHour(x).withMinute(0).withSecond(0).withNano(0);
        return DateUtils.convertToDate(nextQuarterFirstDayXClock);
    }

    public static Date getPreviousDayEndTime(Date curTime) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime previousDay = now.minusDays(1L);
        LocalDateTime previousDayEnd = previousDay.with(LocalTime.MAX).withNano(0);
        ZonedDateTime zonedDateTime = previousDayEnd.atZone(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date getPreviousDayStartTime(Date date) {
        LocalDateTime localDateTime = DateUtils.convertToLocalDateTime(date);
        LocalDateTime previousDay = localDateTime.minusDays(1L);
        LocalDateTime previousDayStartTime = previousDay.withHour(0).withMinute(0).withSecond(0).withNano(0);
        return DateUtils.convertToDate(previousDayStartTime);
    }

    public static Date getPreviousMondayStartTime(Date date) {
        LocalDateTime localDateTime = DateUtils.convertToLocalDateTime(date);
        LocalDateTime previousWeek = localDateTime.minusWeeks(1L);
        LocalDateTime previousMonday = previousWeek.with(DayOfWeek.MONDAY);
        LocalDateTime previousMondayStartTime = previousMonday.withHour(0).withMinute(0).withSecond(0).withNano(0);
        return DateUtils.convertToDate(previousMondayStartTime);
    }

    public static Date getPreviousMonthFirstDayStartTime(Date date) {
        LocalDateTime localDateTime = DateUtils.convertToLocalDateTime(date);
        LocalDateTime previousMonth = localDateTime.minusMonths(1L);
        LocalDateTime previousMonthFirstDay = previousMonth.with(TemporalAdjusters.firstDayOfMonth());
        LocalDateTime previousMonthFirstDayStartTime = previousMonthFirstDay.withHour(0).withMinute(0).withSecond(0).withNano(0);
        return DateUtils.convertToDate(previousMonthFirstDayStartTime);
    }

    public static Date getPreviousQuarterFirstDayStartTime(Date date) {
        int previousQuarterStartMonth;
        LocalDateTime localDateTime = DateUtils.convertToLocalDateTime(date);
        LocalDate localDate = localDateTime.toLocalDate();
        int currentMonth = localDate.getMonthValue();
        if (currentMonth <= 3) {
            previousQuarterStartMonth = 10;
            localDate = localDate.minusYears(1L);
        } else {
            previousQuarterStartMonth = currentMonth <= 6 ? 1 : (currentMonth <= 9 ? 4 : 7);
        }
        LocalDate previousQuarterFirstDay = localDate.withMonth(previousQuarterStartMonth).with(TemporalAdjusters.firstDayOfMonth());
        LocalDateTime previousQuarterFirstDayStartTime = previousQuarterFirstDay.atStartOfDay();
        return DateUtils.convertToDate(previousQuarterFirstDayStartTime);
    }

    public static List<WeekRange> getWeekRanges(LocalDate start, LocalDate end) {
        ArrayList<WeekRange> weekRanges = new ArrayList<WeekRange>();
        LocalDate currentStart = start.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        while (currentStart.isBefore(end) || currentStart.isEqual(end)) {
            LocalDate currentEnd = currentStart.plusDays(6L);
            if (currentEnd.isAfter(end)) {
                currentEnd = end;
            }
            weekRanges.add(new WeekRange(currentStart, currentEnd));
            currentStart = currentStart.plusWeeks(1L);
        }
        return weekRanges;
    }

    public static LocalDate toLocalDate(String dateStr) {
        return DateUtils.toLocalDate(dateStr, FORMAT_SHORT);
    }

    public static LocalDate toLocalDate(String dateStr, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDate.parse(dateStr, formatter);
    }

    public static String getStringToTime(String time) {
        if (!StringUtils.isNotEmpty((String)time)) {
            return null;
        }
        if (time.contains(":")) {
            return time;
        }
        long timestamp = Long.parseLong(time);
        Instant instant = Instant.ofEpochMilli(timestamp);
        ZoneId zone = ZoneId.of("Asia/Shanghai");
        ZonedDateTime zonedDateTime = instant.atZone(zone);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        String formatted = zonedDateTime.format(formatter);
        return formatted;
    }

    public static long getTimestampByNow() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime futureTime = now.plusYears(50L);
        long timestamp = futureTime.toEpochSecond(ZoneOffset.UTC);
        return timestamp;
    }

    public static void main(String[] args) {
    }
}

