/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.aicheck.entity.AiApplicationModellabelLabel;
import com.ovopark.aicheck.entity.AiBoxResultLog;
import com.ovopark.aicheck.entity.AiCheckTaskLog;
import com.ovopark.aicheck.model.detect.BaiduResult;
import com.ovopark.aicheck.model.detect.BoxInfo;
import com.ovopark.aicheck.model.detect.BoxResult;
import com.ovopark.aicheck.model.detect.DetectDetail;
import com.ovopark.aicheck.model.detect.DetectResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class DeviceTaskUtils {
    public static boolean judgeBaiduResult(String result) {
        JSONObject json = JSONObject.parseObject((String)result);
        String j = Convert.toStr((Object)json.get((Object)"results"));
        if (StrUtil.isEmpty((CharSequence)j)) {
            return false;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)j);
        return !jsonArray.isEmpty();
    }

    public static boolean isLLM(String modelIdentifier) {
        try {
            String llm = modelIdentifier.substring(1, 4);
            return "001".equals(llm);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) {
        String s = "000100000400000000000";
        System.out.println(s.substring(1, 4));
    }

    public static List<BaiduResult> toBaiduResultList(String result) {
        DetectResult detectResult = (DetectResult)JSONUtil.toBean((String)result, DetectResult.class);
        List<BaiduResult> list = detectResult.getResults();
        return list;
    }

    public static BoxResult toBeanBoxResult(AiBoxResultLog aiBoxResultLog) {
        BoxResult boxResult = new BoxResult();
        BeanUtils.copyProperties((Object)aiBoxResultLog, (Object)boxResult);
        return boxResult;
    }

    public static String toJSONResult(String result) {
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        String str = "";
        JSONObject json = JSONObject.parseObject((String)result);
        String j = Convert.toStr((Object)json.get((Object)"results"));
        String log_id = Convert.toStr((Object)json.get((Object)"log_id"));
        HashMap<String, Object> retrunMM = new HashMap<String, Object>();
        retrunMM.put("log_id", log_id);
        JSONArray jsonArray = JSONArray.parseArray((String)j);
        if (jsonArray.isEmpty()) {
            retrunMM.put("results", new ArrayList());
            str = JSON.toJSONString(retrunMM);
            return str;
        }
        List rlist = JSON.parseArray((String)jsonArray.toJSONString(), BaiduResult.class);
        retrunMM.put("results", rlist);
        str = JSON.toJSONString(retrunMM);
        return str;
    }

    public static float intersectionoverUnion(BoxInfo box1, BoxInfo box2) {
        int leftColumnMax = Math.max(box1.getX1(), box2.getX1());
        int rightColumnMin = Math.min(box1.getX2(), box2.getX2());
        int upRowMax = Math.max(box1.getY1(), box2.getY1());
        int downRowMin = Math.min(box1.getY2(), box2.getY2());
        if (leftColumnMax >= rightColumnMin || downRowMin <= upRowMax) {
            return 0.0f;
        }
        int s1 = box1.getLocation().getWidth() * box1.getLocation().getHeight();
        int s2 = box2.getLocation().getWidth() * box2.getLocation().getHeight();
        float sCross = (downRowMin - upRowMax) * (rightColumnMin - leftColumnMax);
        return sCross / ((float)(s1 + s2) - sCross);
    }

    public static String buildAIDetectContent(List<String> reportContentList) {
        if (CollectionUtils.isEmpty(reportContentList)) {
            return "";
        }
        ArrayList<DetectDetail> detectDetailList = new ArrayList<DetectDetail>();
        if (reportContentList.size() == 1) {
            DetectDetail detectDetail = new DetectDetail(reportContentList.get(0), 1);
            detectDetailList.add(detectDetail);
        } else {
            Map<String, Long> collect = reportContentList.stream().collect(Collectors.groupingBy(e -> e, Collectors.counting()));
            for (Map.Entry<String, Long> entry : collect.entrySet()) {
                DetectDetail detectDetail = new DetectDetail(entry.getKey(), entry.getValue().intValue());
                detectDetailList.add(detectDetail);
            }
            for (DetectDetail detect : detectDetailList) {
                if (!"playphone".equals(detect.getDetName())) continue;
                detect.setDetCount(detect.getDetCount() / 2);
            }
        }
        return JSONUtil.toJsonStr(detectDetailList);
    }

    public static String buildCloudTaskDetectContent(AiCheckTaskLog aiCheckTaskLog, List<AiApplicationModellabelLabel> appReportLabelList) {
        if (aiCheckTaskLog.getResultStatus() == 4 || StringUtils.isEmpty((String)aiCheckTaskLog.getBaiduResult()) || aiCheckTaskLog.getBaiduResult().length() < 50) {
            return "";
        }
        Integer resultStatus = aiCheckTaskLog.getResultStatus();
        ArrayList<String> reportContentList = new ArrayList<String>();
        try {
            DetectResult detectResult = (DetectResult)JSONUtil.toBean((String)aiCheckTaskLog.getBaiduResult(), DetectResult.class);
            for (BaiduResult baiduResult : detectResult.getResults()) {
                for (AiApplicationModellabelLabel appReportLabel : appReportLabelList) {
                    if (!baiduResult.getName().equals(appReportLabel.getLabelStr()) || appReportLabel.getLabelStatus() != resultStatus) continue;
                    reportContentList.add(appReportLabel.getLabelName());
                }
            }
            return DeviceTaskUtils.buildAIDetectContent(reportContentList);
        }
        catch (Exception e) {
            return "";
        }
    }
}

