/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import com.ovopark.aicheck.context.SpringContextAware;
import java.util.Locale;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class I18nUtils {
    @Autowired
    private MessageSource messageSource;
    private static volatile MessageSource instance = null;

    @PostConstruct
    public void init() {
        instance = this.messageSource;
    }

    public static String getMessage(String code, Locale locale) {
        return instance.getMessage(code, null, locale);
    }

    public static String getMessage(String code, Object[] args, Locale locale) {
        return instance.getMessage(code, args, locale);
    }

    public static String getMessageByEnv(String code) {
        return instance.getMessage(code, null, I18nUtils.getLocaleByEnv());
    }

    public static String getMessageByEnv(String code, Object[] args) {
        return instance.getMessage(code, args, I18nUtils.getLocaleByEnv());
    }

    private static Locale getLocaleByEnv() {
        String activeProfile = SpringContextAware.getActiveProfile();
        if ("asia".equalsIgnoreCase(activeProfile)) {
            return Locale.US;
        }
        return Locale.SIMPLIFIED_CHINESE;
    }
}

