/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.ovopark.aicheck.feign.OpenAiApi;
import com.ovopark.aicheck.model.openai.ModelRelationCategoryVO;
import com.ovopark.aicheck.model.openai.OpenAiForeignBatchSnapshootListRequest;
import com.ovopark.aicheck.result.BaseResult;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenAiUtils {
    private static final Logger log = LoggerFactory.getLogger(OpenAiUtils.class);
    @Autowired
    private OpenAiApi openAiApi;
    private static OpenAiApi openAiApiInstance;

    @PostConstruct
    public void init() {
        openAiApiInstance = this.openAiApi;
    }

    public static String batchSnapshotListV2(OpenAiForeignBatchSnapshootListRequest request) {
        String url = "";
        try {
            BaseResult baseResult = openAiApiInstance.batchSnapshotListV2(request);
            log.info("-----\u6279\u91cf\u83b7\u53d6\u7b97\u6cd5\u6a21\u578b\u5305-\u8c03\u7528\u7ed3\u679c-----{}", (Object)JSONUtil.toJsonStr((Object)baseResult));
            if (!baseResult.getIsError().booleanValue() && baseResult.getData() != null) {
                JSONArray jsonArray = JSONUtil.parseArray(baseResult.getData());
                JSON json = JSONUtil.parse((Object)Convert.toStr((Object)jsonArray.get(0)));
                url = Convert.toStr((Object)json.getByPath("url"));
                return url;
            }
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            return url;
        }
    }

    public static ModelRelationCategoryVO modelRelationCategory(String algoCode) {
        ModelRelationCategoryVO vo = new ModelRelationCategoryVO();
        try {
            BaseResult<ModelRelationCategoryVO> baseResult = openAiApiInstance.modelRelationCategory(algoCode);
            log.info("-----\u83b7\u53d6\u6a21\u578b\u4e0b\u7684\u5206\u7c7b-\u8c03\u7528\u7ed3\u679c-----{}", (Object)JSONUtil.toJsonStr(baseResult));
            if (!baseResult.getIsError().booleanValue() && baseResult.getData() != null) {
                return baseResult.getData();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

