/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import cn.hutool.json.JSONUtil;
import com.ovopark.aicheck.feign.ShopwebCheckApi;
import com.ovopark.aicheck.model.check.PresetNamesVo;
import com.ovopark.aicheck.model.vo.tasklog.InspectionItemVo;
import com.ovopark.aicheck.model.vo.tasklog.SceneVo;
import com.ovopark.aicheck.result.BaseResult;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OvoCheckUtils {
    private static final Logger log = LoggerFactory.getLogger(OvoCheckUtils.class);
    @Autowired
    private ShopwebCheckApi shopwebCheckApi;
    private static ShopwebCheckApi shopwebCheckApiInstance;

    @PostConstruct
    public void init() {
        shopwebCheckApiInstance = this.shopwebCheckApi;
    }

    public static PresetNamesVo getPresetNamesById(Integer userId) {
        PresetNamesVo presetNamesVo = new PresetNamesVo();
        try {
            BaseResult<PresetNamesVo> userPojo = shopwebCheckApiInstance.getPresetNamesById(userId);
            log.info("-----SessionService-\u8c03\u7528getUserById\u7ed3\u679c-----{}", (Object)JSONUtil.toJsonStr(userPojo));
            presetNamesVo = userPojo.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return presetNamesVo;
    }

    public static SceneVo getSceneById(Integer sceneConfigId) {
        SceneVo sceneVo = new SceneVo();
        try {
            log.info("=====getSceneById\u83b7\u53d6\u573a\u666f\u4fe1\u606f\uff0csceneConfigId={}", (Object)sceneConfigId);
            BaseResult<SceneVo> sceneResult = shopwebCheckApiInstance.getSceneById(sceneConfigId);
            sceneVo = sceneResult.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("=====getSceneById\u83b7\u53d6\u573a\u666f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return sceneVo;
    }

    public static InspectionItemVo getInspectionItem(Integer dbviewshopId) {
        InspectionItemVo inspectionVo = new InspectionItemVo();
        try {
            log.info("=====getInspectionItem\u83b7\u53d6\u70b9\u68c0\u9879\u4fe1\u606f\uff0cdbviewshopId={}", (Object)dbviewshopId);
            BaseResult<InspectionItemVo> result = shopwebCheckApiInstance.getInspectionItemById(dbviewshopId);
            inspectionVo = result.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("=====getInspectionItem\u83b7\u53d6\u70b9\u68c0\u9879\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return inspectionVo;
    }
}

