/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.google.common.collect.Maps;
import com.ovopark.aicheck.feign.OvoparkDeviceApi;
import com.ovopark.aicheck.feign.OvoparkDeviceManageApi;
import com.ovopark.aicheck.model.device.AiMainDeviceVo;
import com.ovopark.aicheck.model.device.CreateDevicePresetFMo;
import com.ovopark.aicheck.model.device.DelAlgoActivateFeignMo;
import com.ovopark.aicheck.model.device.DelAlgoActivateFeignVo;
import com.ovopark.aicheck.model.device.DeviceStatusPojo;
import com.ovopark.aicheck.model.device.DmsDeviceBaseRes;
import com.ovopark.aicheck.model.device.GetAiMainDeviceListMo;
import com.ovopark.aicheck.model.device.SetAlgoAlgoActivMo;
import com.ovopark.aicheck.model.device.SetDeviceSceneBo;
import com.ovopark.aicheck.model.device.SnapshotByHandVo;
import com.ovopark.aicheck.model.device.VideoFeignV1Vo;
import com.ovopark.aicheck.model.vo.tasksIntegration.DelAlgoDetailConfigBo;
import com.ovopark.aicheck.model.vo.tasksIntegration.DelAlgoDetailConfigVo;
import com.ovopark.aicheck.result.BaseResult;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OvoparkDeviceUtils {
    private static final Logger log = LoggerFactory.getLogger(OvoparkDeviceUtils.class);
    @Value(value="${ovopark.gateway:''}")
    private String gateway;
    @Value(value="${ovopark.device-snapshotByHand:''}")
    private String snapshotByHandUrl;
    private static String ovoparkGateway;
    private static String deviceSnapshotByHandUrl;
    @Autowired
    private OvoparkDeviceApi ovoparkDeviceApi;
    @Autowired
    private OvoparkDeviceManageApi ovoparkDeviceManageApi;
    private static OvoparkDeviceApi ovoparkDeviceApiInstance;
    private static OvoparkDeviceManageApi ovoparkDeviceManageApiInstance;

    @PostConstruct
    public void init() {
        ovoparkGateway = this.gateway;
        deviceSnapshotByHandUrl = this.snapshotByHandUrl;
        ovoparkDeviceApiInstance = this.ovoparkDeviceApi;
        ovoparkDeviceManageApiInstance = this.ovoparkDeviceManageApi;
    }

    public static String snapshotByHand(Integer deviceId, Integer presetNos) {
        String result;
        BaseResult baseResult;
        String url = ovoparkGateway + deviceSnapshotByHandUrl;
        HashMap params = Maps.newHashMap();
        params.put("deviceId", deviceId);
        if (presetNos != null) {
            params.put("presetNos", presetNos);
        }
        if ((baseResult = (BaseResult)JSONUtil.toBean((String)(result = ((HttpRequest)HttpRequest.post((String)url).header("authenticator", "740AE299473DD07AFB892C49D6AAB027")).body(JSONUtil.toJsonStr((Object)params)).execute().body()), BaseResult.class)) == null || baseResult.getIsError().booleanValue()) {
            log.info("--snapshotByHand\u8bf7\u6c42\u63a5\u53e3\u9519\u8bef---{}", (Object)result);
            return null;
        }
        String data = Convert.toStr(baseResult.getData());
        SnapshotByHandVo snapshotByHandVo = (SnapshotByHandVo)JSONUtil.toBean((String)data, SnapshotByHandVo.class);
        if (snapshotByHandVo == null) {
            log.info("--snapshotByHand\u6ca1\u6709\u6293\u62cd\u5230\u56fe\u7247--");
            return null;
        }
        return snapshotByHandVo.getUrl();
    }

    public static DeviceStatusPojo getDeviceByMac(String authorization, String mac, Integer versionFlag, Integer parentFlag) {
        try {
            BaseResult<DeviceStatusPojo> response = ovoparkDeviceApiInstance.getDeviceByMac(authorization, mac, versionFlag, parentFlag);
            if (!(response != null && response.getCode() == 0 && response.getData() != null || (response = ovoparkDeviceApiInstance.getDeviceByMac(authorization, mac, 1, 0)) != null && response.getCode() == 0 && response.getData() != null)) {
                log.info("===code_get_device_info_fail");
                return null;
            }
            return response.getData();
        }
        catch (Exception e) {
            log.info("===getDeviceByMac\u63a5\u53e3\u62a5\u9519---" + e.getMessage());
            return null;
        }
    }

    public static DeviceStatusPojo getDeviceByNvrMac(String authorization, String mac, Integer versionFlag, Integer parentFlag) {
        try {
            BaseResult<DeviceStatusPojo> response = ovoparkDeviceApiInstance.getDeviceByMac(authorization, mac, versionFlag, parentFlag);
            if (response == null || response.getCode() != 0 || response.getData() == null) {
                return null;
            }
            return response.getData();
        }
        catch (Exception e) {
            log.info("===getDeviceByNvrMac\u63a5\u53e3\u62a5\u9519---" + e.getMessage());
            return null;
        }
    }

    public static List<AiMainDeviceVo> getAiMainDeviceListV1(GetAiMainDeviceListMo mo) {
        try {
            BaseResult<List<AiMainDeviceVo>> baseResult = ovoparkDeviceManageApiInstance.getAiMainDeviceListV1(mo);
            if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null) {
                log.info("===getAiMainDeviceListV1\u63a5\u53e3\u62a5\u9519---" + JSONUtil.toJsonStr(baseResult));
                return null;
            }
            return baseResult.getData();
        }
        catch (Exception e) {
            log.info("===getAiMainDeviceListV1\u63a5\u53e3\u62a5\u9519---" + e.getMessage());
            return null;
        }
    }

    public static DmsDeviceBaseRes setAlgoAlgoActiv(SetAlgoAlgoActivMo mo) {
        try {
            BaseResult<DmsDeviceBaseRes> baseResult = ovoparkDeviceApiInstance.setAlgoAlgoActiv(mo);
            log.info("===setAlgoAlgoActiv\u63a5\u53e3\u8fd4\u56de---" + JSONUtil.toJsonStr(baseResult) + "---\u8bf7\u6c42\u53c2\u6570----" + JSONUtil.toJsonStr((Object)mo));
            if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null) {
                log.info("===setAlgoAlgoActiv\u63a5\u53e3\u62a5\u9519---" + JSONUtil.toJsonStr(baseResult) + "---\u8bf7\u6c42\u53c2\u6570----" + mo);
                return null;
            }
            DmsDeviceBaseRes dmsDeviceBaseRes = baseResult.getData();
            if (dmsDeviceBaseRes == null) {
                log.info("===setAlgoAlgoActiv\u63a5\u53e3\u62a5\u9519---" + JSONUtil.toJsonStr((Object)dmsDeviceBaseRes));
                return null;
            }
            return baseResult.getData();
        }
        catch (Exception e) {
            log.info("===setAlgoAlgoActiv\u63a5\u53e3\u62a5\u9519---" + e.getMessage());
            return null;
        }
    }

    public static Boolean setAlgoAlgoActivForA1(SetAlgoAlgoActivMo mo) {
        try {
            BaseResult<DmsDeviceBaseRes> baseResult = ovoparkDeviceApiInstance.setAlgoAlgoActiv(mo);
            log.info("===setAlgoAlgoActivForA1\u63a5\u53e3\u8fd4\u56de---" + JSONUtil.toJsonStr(baseResult) + "---\u8bf7\u6c42\u53c2\u6570----" + JSONUtil.toJsonStr((Object)mo));
            if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null) {
                log.info("===setAlgoAlgoActivForA1\u63a5\u53e3\u62a5\u9519---" + JSONUtil.toJsonStr(baseResult) + "---\u8bf7\u6c42\u53c2\u6570----" + mo);
                return false;
            }
            DmsDeviceBaseRes dmsDeviceBaseRes = baseResult.getData();
            if (dmsDeviceBaseRes == null) {
                return false;
            }
            LinkedHashMap map = (LinkedHashMap)dmsDeviceBaseRes.getData();
            String errno = Convert.toStr(map.get("errno"));
            if ("200000".equals(errno)) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("===setAlgoAlgoActivForA1\u63a5\u53e3\u62a5\u9519---" + e.getMessage());
            return false;
        }
    }

    public static List<VideoFeignV1Vo> getVideoDetailList(Integer depId) {
        try {
            BaseResult<List<VideoFeignV1Vo>> baseResult = ovoparkDeviceManageApiInstance.getVideoDetailList(depId);
            log.info("===getVideoDetailList \u63a5\u53e3\u8fd4\u56de---" + JSONUtil.toJsonStr(baseResult));
            if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null) {
                log.info("===getVideoDetailList \u63a5\u53e3\u62a5\u9519---" + JSONUtil.toJsonStr(baseResult));
                return null;
            }
            return baseResult.getData();
        }
        catch (Exception e) {
            log.info("===getVideoDetailList \u63a5\u53e3\u62a5\u9519---" + e.getMessage());
            return null;
        }
    }

    public static DelAlgoActivateFeignVo delAlgoActivate(DelAlgoActivateFeignMo mo) {
        try {
            log.info("===delAlgoActivate \u5220\u9664\u7b97\u6cd5\u63a5\u53e3\u53c2\u6570---" + JSONUtil.toJsonStr((Object)mo));
            BaseResult<DelAlgoActivateFeignVo> baseResult = ovoparkDeviceManageApiInstance.delAlgoActivate(mo);
            log.info("===delAlgoActivate \u5220\u9664\u7b97\u6cd5\u63a5\u53e3\u8fd4\u56de---" + JSONUtil.toJsonStr(baseResult));
            if (baseResult == null) {
                log.info("===delAlgoActivate \u63a5\u53e3\u62a5\u9519---" + JSONUtil.toJsonStr(baseResult));
                return null;
            }
            if (baseResult.getCode() != 0 || baseResult.getData() == null || !Convert.toStr((Object)baseResult.getData().getData().getErrno()).equals("200000")) {
                log.info("===delAlgoActivate \u63a5\u53e3\u62a5\u9519---" + JSONUtil.toJsonStr(baseResult));
                return null;
            }
            return baseResult.getData();
        }
        catch (Exception e) {
            log.info("===delAlgoActivate \u63a5\u53e3\u62a5\u9519---" + e.getMessage());
            return null;
        }
    }

    public static DelAlgoDetailConfigVo delAlgoDetailConfig(String token, DelAlgoDetailConfigBo params) {
        try {
            log.info("===delAlgoDetailConfig \u5220\u9664\u7b97\u6cd5\u63a5\u53e3\u53c2\u6570---" + JSONUtil.toJsonStr((Object)params));
            BaseResult<DelAlgoDetailConfigVo> baseResult = ovoparkDeviceApiInstance.delAlgoDetailConfig(token, params);
            log.info("===delAlgoDetailConfig \u5220\u9664\u7b97\u6cd5\u63a5\u53e3\u8fd4\u56de---" + JSONUtil.toJsonStr(baseResult));
            if (baseResult == null || baseResult.getCode() != 0 || baseResult.getData() == null || !baseResult.getData().getData().getErrno().equals("200000")) {
                log.info("===delAlgoDetailConfig \u63a5\u53e3\u62a5\u9519---" + JSONUtil.toJsonStr(baseResult));
                return null;
            }
            return baseResult.getData();
        }
        catch (Exception e) {
            log.info("===delAlgoDetailConfig \u63a5\u53e3\u62a5\u9519---" + e.getMessage());
            return null;
        }
    }

    public static Integer createDevicePreset(CreateDevicePresetFMo mo) {
        try {
            BaseResult<Integer> baseResult = ovoparkDeviceManageApiInstance.createDevicePreset(mo);
            log.info("===createDevicePreset \u63a5\u53e3\u8fd4\u56de---" + JSONUtil.toJsonStr(baseResult));
            if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null) {
                log.info("===createDevicePreset \u63a5\u53e3\u62a5\u9519---" + JSONUtil.toJsonStr(baseResult));
                return null;
            }
            return baseResult.getData();
        }
        catch (Exception e) {
            log.info("===createDevicePreset \u63a5\u53e3\u62a5\u9519---" + e.getMessage());
            return null;
        }
    }

    public static BaseResult setDeviceScene(SetDeviceSceneBo mo) {
        try {
            BaseResult baseResult = ovoparkDeviceApiInstance.setDeviceScene(mo);
            log.info("===setDeviceScene \u63a5\u53e3\u8fd4\u56de---" + JSONUtil.toJsonStr((Object)baseResult));
            if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null) {
                log.info("===setDeviceScene \u63a5\u53e3\u62a5\u9519---" + JSONUtil.toJsonStr((Object)baseResult));
                return null;
            }
            return baseResult;
        }
        catch (Exception e) {
            log.info("===setDeviceScene \u63a5\u53e3\u62a5\u9519---" + e.getMessage());
            return null;
        }
    }

    public static void main(String[] args) {
        String str = "{\"code\":0,\"message\":\"SUCCESS\",\"isError\":false,\"data\":{\"errno\":\"comm_success\",\"msg\":\"comm_success\",\"data\":{\"errno\":\"200000\",\"msg\":\"OK\"}}}";
        BaseResult baseResult = (BaseResult)JSONUtil.toBean((String)str, BaseResult.class);
        DelAlgoDetailConfigVo vo = (DelAlgoDetailConfigVo)JSONUtil.toBean((String)Convert.toStr(baseResult.getData()), DelAlgoDetailConfigVo.class);
        if (baseResult.getCode() != 0 || baseResult.getData() == null || !Convert.toStr((Object)vo.getData().getErrno()).equals("200000")) {
            log.info("===delAlgoDetailConfig \u63a5\u53e3\u62a5\u9519---" + JSONUtil.toJsonStr((Object)baseResult));
        } else {
            log.info("===success====");
        }
    }
}

