/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import cn.hutool.core.convert.Convert;
import com.ovopark.aicheck.constant.enums.WeekEnum;
import com.ovopark.aicheck.model.vo.tasklog.TimeParseResult;
import com.ovopark.aicheck.utils.StringSplitUtil;
import java.sql.Time;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("HH:mm:ss");
    private static final Object LOCK = new Object();
    public static String FORMAT_SHORT = "yyyy-MM-dd";
    public static String FORMAT_SHORT_SIMPLE = "yyyyMMdd";
    public static String FORMAT_YEAR_MONTH = "yyyyMM";
    public static String FORMAT_TIME = "HH:mm:ss";
    public static String FORMAT_TIME_SIMPLE = "HHmmss";
    public static String FORMAT_LONG = "yyyy-MM-dd HH:mm:ss";
    public static String FORMAT_FULL = "yyyy-MM-dd HH:mm:ss.S";
    public static String FORMAT_SHORT_CN = "yyyy\u5e74MM\u6708dd";
    public static String FORMAT_LONG_CN = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";
    public static String FORMAT_LONG_ABBR = "yyyyMMddHHmmss";
    public static final String LINK_DATABASE_DATE_MSEL = "yyyyMMddHHmmssSSS";
    public static final String FORMAT_ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    public static String FORMAT_FULL_CN = "yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2SSS\u6beb\u79d2";

    public static String getNowStr() {
        return DateUtils.getDateStr(new Date(), FORMAT_SHORT_SIMPLE);
    }

    public static String getNowStr_S() {
        return DateUtils.getDateStr(new Date(), FORMAT_LONG_ABBR);
    }

    public static String getNowStr_MS() {
        return DateUtils.getDateStr(new Date(), LINK_DATABASE_DATE_MSEL);
    }

    public static String getDateStr(Date date, String formatStr) {
        SimpleDateFormat fomate = new SimpleDateFormat(formatStr);
        return fomate.format(date);
    }

    public static String getDatePattern() {
        return FORMAT_LONG;
    }

    public static String getNow() {
        return DateUtils.format(new Date());
    }

    public static String getNow(String format) {
        return DateUtils.format(new Date(), format);
    }

    public static Date formatDate(Date date) {
        String str = DateUtils.format(date, FORMAT_LONG);
        return DateUtils.parse(str, FORMAT_LONG);
    }

    public static String format(Date date) {
        return DateUtils.format(date, DateUtils.getDatePattern());
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static String formatTime(Time time, String pattern) {
        String returnValue = "";
        if (time != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(time);
        }
        return returnValue;
    }

    public static Date parse(String strDate) {
        return DateUtils.parse(strDate, DateUtils.getDatePattern());
    }

    public static Date getFirstDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(7, calendar.getFirstDayOfWeek());
        return calendar.getTime();
    }

    public static Date getFirstDayOfMon(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        date = cal.getTime();
        return date;
    }

    public static Date getYesterday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -1);
        date = cal.getTime();
        return date;
    }

    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date assignMonthStart(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date assignMonthEnd(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        cal.set(5, 0);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, n);
        return cal.getTime();
    }

    public static Date addSecond(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, n);
        return cal.getTime();
    }

    public static String getTimeString() {
        Calendar calendar = Calendar.getInstance();
        return Convert.toStr((Object)(calendar.getTimeInMillis() / 1000L));
    }

    public static String getYear(Date date) {
        return DateUtils.format(date).substring(0, 4);
    }

    public static int countHours(Date date1, Date date2) {
        int hours = (int)((date2.getTime() - date1.getTime()) / 3600000L);
        return hours;
    }

    public static int countDays(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    public static Date getStartTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static String strToDateFormat(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            formatter.setLenient(false);
            Date newDate = formatter.parse(date);
            formatter = new SimpleDateFormat("yyyy-MM-dd");
            return formatter.format(newDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String LongToDateStr(String dateFormat, Long millSec) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date date = new Date(millSec);
        return sdf.format(date);
    }

    public static Date LongToDate(String dateFormat, Long millSec) {
        Date date = new Date(millSec);
        return date;
    }

    public static Long getSecBetweenTwoDate(Date lastDate) {
        long a = new Date().getTime();
        long b = lastDate.getTime();
        Long c = (a - b) / 1000L;
        return c;
    }

    public static Long getSecBetweenTwoDate(Date startDate, Date endDate) {
        long a = startDate.getTime();
        long b = endDate.getTime();
        Long c = (b - a) / 1000L;
        return c;
    }

    public static String beforeHourToNowDate(int hour, String dateFormat) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - hour);
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String time = sdf.format(calendar.getTime());
        return time;
    }

    public static List<Date> getBetweenDates(Date begin, Date end) {
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(begin);
        while (begin.getTime() <= end.getTime()) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
            begin = tempStart.getTime();
        }
        return result;
    }

    public static List<String> getBetweenTwoDateStr(String startStr, String endStr) {
        ArrayList<String> result = new ArrayList<String>();
        Date begin = DateUtils.parse(startStr, FORMAT_SHORT);
        Date end = DateUtils.parse(endStr, FORMAT_SHORT);
        if (end.before(begin)) {
            return result;
        }
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(begin);
        while (begin.getTime() <= end.getTime()) {
            result.add(DateUtils.format(tempStart.getTime(), FORMAT_SHORT));
            tempStart.add(6, 1);
            begin = tempStart.getTime();
        }
        return result;
    }

    public static List<String> getMonthBetween(String minDate, String maxDate) {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        try {
            Calendar min = Calendar.getInstance();
            Calendar max = Calendar.getInstance();
            min.setTime(sdf.parse(minDate));
            min.set(min.get(1), min.get(2), 1);
            max.setTime(sdf.parse(maxDate));
            max.set(max.get(1), max.get(2), 2);
            Calendar curr = min;
            while (curr.before(max)) {
                result.add(sdf.format(curr.getTime()));
                curr.add(2, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getWeek() {
        String week = "";
        Date today = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        int weekday = c.get(7);
        if (weekday == 1) {
            week = "7";
        } else if (weekday == 2) {
            week = "1";
        } else if (weekday == 3) {
            week = "2";
        } else if (weekday == 4) {
            week = "3";
        } else if (weekday == 5) {
            week = "4";
        } else if (weekday == 6) {
            week = "5";
        } else if (weekday == 7) {
            week = "6";
        }
        return week;
    }

    public static int getQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) / 3 + 1;
    }

    public static Date getStartTimeOfMonth(Date date, int m, int d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, m - 1);
        cal.set(5, d);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date getEndTimeOfMonth(Date date, int m, int d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, m - 1);
        cal.set(5, d);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static String getOneHourLater(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, 1);
        return format.format(cal.getTime());
    }

    public static String getCurrentTimeLaterOrBefore(Date date, int unit, int value, String formatStr) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(unit, value);
        return format.format(cal.getTime());
    }

    public static Boolean timeDetermine(String createTime, Date startTime, Integer frequency) {
        Date endTime = DateUtils.addMinute(startTime, frequency);
        Date nowTime = DateUtils.parse(createTime);
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static Boolean timeDetermineBySecond(String createTime, Date startTime, Integer frequency) {
        Date endTime = DateUtils.addSecond(startTime, frequency);
        Date nowTime = DateUtils.parse(createTime);
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static String getDateStartStr(Date date) {
        return DateUtils.getDateStr(date, FORMAT_SHORT) + " 00:00:00";
    }

    public static String getAssignDateStr(Date date, String time) {
        return DateUtils.getDateStr(date, FORMAT_SHORT) + " " + time;
    }

    public static Date getAssignDate(Date date, String time) {
        String dateStr = DateUtils.getDateStr(date, FORMAT_SHORT) + " " + time;
        return DateUtils.parse(dateStr, FORMAT_LONG);
    }

    public static String getHHMMSS(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date).split(" ")[1];
    }

    public static String getDateEndStr(Date date) {
        return DateUtils.getDateStr(date, FORMAT_SHORT) + " 23:59:59";
    }

    public static Date getDateEnd(Date date) {
        String dateEndStr = DateUtils.getDateStr(date, FORMAT_SHORT) + " 23:59:59";
        return DateUtils.parse(dateEndStr, FORMAT_LONG);
    }

    public static Date getAssignShortDate(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        String dateEndStr = DateUtils.getDateStr(cal.getTime(), FORMAT_SHORT);
        return DateUtils.parse(dateEndStr, FORMAT_SHORT);
    }

    public static Date getFewDaysAgoOrLast(Date date, int num, String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, num);
        date = calendar.getTime();
        date = DateUtils.parseDateToDatePattern(date, format);
        return date;
    }

    public static Date parseDateToDatePattern(Date date, String format) {
        String resultDate = DateUtils.getDateStr(date, format);
        return DateUtils.parse(resultDate, format);
    }

    public static Date getXxljobStartDate() {
        return DateUtils.getStartTimeOfDay(new Date());
    }

    public static Date getXxljobEndDate() {
        return DateUtils.addMonth(DateUtils.getEndTimeOfDay(new Date()), 60);
    }

    public static Date getNDate(long timestr) {
        SimpleDateFormat sd = new SimpleDateFormat(FORMAT_LONG);
        String ntime = sd.format(timestr);
        return DateUtils.parse(ntime);
    }

    public static Date getNDateByZone(long timestr, Integer zone) {
        if (zone == null || zone == 0) {
            zone = 8;
        }
        SimpleDateFormat sd = new SimpleDateFormat(FORMAT_LONG);
        sd.setTimeZone(TimeZone.getTimeZone("GMT+" + zone));
        String ntime = sd.format(timestr);
        return DateUtils.parse(ntime);
    }

    public static String getNDateByZoneStr(String createTime, Integer zone) {
        SimpleDateFormat sd = new SimpleDateFormat(FORMAT_LONG);
        long timestr = sd.parse(createTime, new ParsePosition(0)).getTime();
        if (zone == null || zone == 0) {
            zone = 8;
        }
        sd.setTimeZone(TimeZone.getTimeZone("GMT+" + zone));
        String ntime = sd.format(timestr);
        return ntime;
    }

    public static float getIntervalTimeHour(Date start, Date end) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long differ = end.getTime() - start.getTime();
        long day = differ / nd;
        long hour = differ % nd / nh;
        long min = differ % nd % nh / nm;
        float intervalHour = 0.0f;
        if (day > 0L) {
            intervalHour = day * 24L;
        }
        if (hour > 0L) {
            intervalHour += (float)hour;
        }
        if (min > 0L) {
            intervalHour += (float)min / 60.0f;
        }
        return intervalHour;
    }

    public static Time strToTime(String strDate) {
        String str = strDate;
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        Date d = null;
        try {
            d = format.parse(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Time(d.getTime());
    }

    public static int getWeeks(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        String calStr1 = DateUtils.format(cal.getTime(), FORMAT_LONG);
        cal.set(7, 2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String calStr = DateUtils.format(cal.getTime(), FORMAT_LONG);
        int dayOfWeek = cal.get(7);
        int weekDay = dayOfWeek - 1;
        if (gregorianCalendar.isLeapYear(year)) {
            if (weekDay == 5 || weekDay == 4) {
                return 53;
            }
            return 52;
        }
        if (weekDay == 5) {
            return 53;
        }
        return 52;
    }

    public static String judgementWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return WeekEnum.getWeekDesc(dayOfWeek);
    }

    public static String getChinaFirstWeekDayStr(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1 || dayOfWeek >= 5) {
            return DateUtils.format(DateUtils.getNextWeekMonday(cal.getTime()), FORMAT_LONG);
        }
        return DateUtils.format(DateUtils.getThisWeekMonday(cal.getTime()), FORMAT_LONG);
    }

    public static Date getChinaFirstWeekDay(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1 || dayOfWeek >= 5) {
            return DateUtils.getNextWeekMonday(cal.getTime());
        }
        return DateUtils.getThisWeekMonday(cal.getTime());
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getThisWeekMonday(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static Date getThisWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date getThisWeekSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        cal.set(5, cal.get(5) + 6);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static List<List<Date>> getYearWeekStartAndEnd(int year) {
        int weeks = DateUtils.getWeeks(year);
        ArrayList<List<Date>> result = new ArrayList<List<Date>>(weeks);
        Date chinaFirstWeekDay = DateUtils.getChinaFirstWeekDay(year);
        for (int i = 1; i <= weeks; ++i) {
            ArrayList<Date> weekList = new ArrayList<Date>();
            if (i == 1) {
                Date thisWeekSunday = DateUtils.getThisWeekSunday(chinaFirstWeekDay);
                weekList.add(chinaFirstWeekDay);
                weekList.add(thisWeekSunday);
            } else {
                Date nextWeekMonday = DateUtils.getNextWeekMonday(chinaFirstWeekDay);
                Date nextWeekSunday = DateUtils.getThisWeekSunday(nextWeekMonday);
                weekList.add(nextWeekMonday);
                weekList.add(nextWeekSunday);
                chinaFirstWeekDay = nextWeekMonday;
            }
            result.add(weekList);
        }
        return result;
    }

    public static String addMinuteStr(String date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.parse(date));
        cal.add(12, n);
        Date calDate = cal.getTime();
        return DateUtils.format(calDate);
    }

    public static String addSecondStr(String date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.parse(date));
        cal.add(13, n);
        Date calDate = cal.getTime();
        return DateUtils.format(calDate);
    }

    public static int daysBetween(Date date1, Date date2) throws ParseException {
        int count = 0;
        count = Math.abs((int)((date1.getTime() - date2.getTime()) / 86400000L));
        return count;
    }

    public static int daysBetweenAndOne(Date date1, Date date2) throws ParseException {
        int count = 0;
        count = Math.abs((int)((date1.getTime() - date2.getTime()) / 86400000L));
        return count + 1;
    }

    public static Date minusMonthsFirstDay(Date date, int n) {
        Instant dateInstant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = dateInstant.atZone(zoneId).toLocalDate();
        LocalDate lastMonth = localDate.minusMonths(n);
        LocalDate firstLocalDay = lastMonth.with(TemporalAdjusters.firstDayOfMonth());
        Instant instant = firstLocalDay.atStartOfDay().atZone(zoneId).toInstant();
        Date firstDay = Date.from(instant);
        return firstDay;
    }

    public static Date minusMonthsEndDay(Date date, int n) {
        Instant dateInstant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = dateInstant.atZone(zoneId).toLocalDate();
        LocalDate lastMonth = localDate.minusMonths(n);
        LocalDate endLocalDay = lastMonth.with(TemporalAdjusters.lastDayOfMonth());
        Instant instant = endLocalDay.atStartOfDay().atZone(zoneId).toInstant();
        Date endDay = Date.from(instant);
        return endDay;
    }

    public static String getHourPeriod(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int period = calendar.get(11);
        return String.valueOf(period);
    }

    public static String getLastYearMonth(String currYearMonth) {
        Date date = DateUtils.parse(currYearMonth, "yyyyMM");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) - 1);
        date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        return format.format(date);
    }

    public static String getCurrYearMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        return format.format(new Date());
    }

    public static Integer getYearMonthSubtract(String yearMonthBefore, String yearMonthAfter) {
        Date date1 = DateUtils.parse(yearMonthBefore, "yyyyMM");
        Date date2 = DateUtils.parse(yearMonthAfter, "yyyyMM");
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(date2);
        int result = c2.get(2) - c1.get(2);
        int month = (c2.get(1) - c1.get(1)) * 12;
        return result == 0 ? 1 : Math.abs(month + result);
    }

    public static long get2YearMonthDiffCount(String yearMonthBefore, String yearMonthAfter) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(FORMAT_YEAR_MONTH);
        YearMonth yearMonth1 = YearMonth.parse(yearMonthBefore, formatter);
        YearMonth yearMonth2 = YearMonth.parse(yearMonthAfter, formatter);
        long diffMonthCount = ChronoUnit.MONTHS.between(yearMonth1, yearMonth2);
        return Math.abs(diffMonthCount);
    }

    public static TimeParseResult parseTimeInfo(String timeStr) {
        LocalDateTime inputDateTime;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        try {
            inputDateTime = LocalDateTime.parse(timeStr, dateTimeFormatter);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u8f93\u5165\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u4f20\u5165 yyyy-MM-dd HH:mm:ss \u683c\u5f0f\uff08\u4f8b\uff1a2024-09-06 10:45:42\uff09", e);
        }
        LocalDate inputDate = inputDateTime.toLocalDate();
        int dayOfMonth = inputDate.getDayOfMonth();
        DayOfWeek dayOfWeekEnum = inputDate.getDayOfWeek();
        int dayOfWeek = dayOfWeekEnum.getValue();
        LocalTime startLocalTime = LocalTime.of(0, 0, 0);
        LocalTime endLocalTime = LocalTime.of(23, 59, 59);
        Time dayStartTime = Time.valueOf(startLocalTime);
        Time endTime = Time.valueOf(endLocalTime);
        LocalDateTime fullDayStartTime = LocalDateTime.of(inputDate, startLocalTime);
        LocalDateTime fullDayEndTime = LocalDateTime.of(inputDate, endLocalTime);
        TimeParseResult result = new TimeParseResult();
        result.setInputDateTime(inputDateTime);
        result.setDayOfMonth(dayOfMonth);
        result.setDayOfWeek(dayOfWeek);
        result.setDayStartTime(dayStartTime);
        result.setEndTime(endTime);
        result.setFullDayStartTime(fullDayStartTime);
        result.setFullDayEndTime(fullDayEndTime);
        return result;
    }

    public static boolean isInputTimeInRange(String inputTimeStr, Time startTime, Time endTime) throws ParseException {
        if (inputTimeStr == null || inputTimeStr.trim().isEmpty()) {
            throw new IllegalArgumentException("\u8f93\u5165\u65f6\u95f4\u5b57\u7b26\u4e32\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (startTime == null || endTime == null) {
            throw new IllegalArgumentException("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        TimeParseResult timeResult = DateUtils.parseTimeInfo(inputTimeStr);
        Time inputTime = new Time(timeResult.getInputDateTime().toLocalTime().toNanoOfDay() / 1000000L);
        return DateUtils.isBetween(inputTime, startTime, endTime);
    }

    public static boolean isBetween(Time inputTime, Time startTime, Time endTime) {
        long endMs;
        if (inputTime == null || startTime == null || endTime == null) {
            throw new IllegalArgumentException("\u8f93\u5165\u65f6\u95f4\u3001\u5f00\u59cb\u65f6\u95f4\u3001\u7ed3\u675f\u65f6\u95f4\u5747\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        long inputMs = DateUtils.getTimeInMillis(inputTime);
        long startMs = DateUtils.getTimeInMillis(startTime);
        if (startMs <= (endMs = DateUtils.getTimeInMillis(endTime))) {
            return inputMs >= startMs && inputMs <= endMs;
        }
        return inputMs >= startMs || inputMs <= endMs;
    }

    private static long getTimeInMillis(Time time) {
        Object object = LOCK;
        synchronized (object) {
            try {
                String timeStr = TIME_FORMATTER.format(time);
                Date date = TIME_FORMATTER.parse(timeStr);
                return date.getTime();
            }
            catch (ParseException e) {
                throw new RuntimeException("\u65f6\u95f4\u683c\u5f0f\u89e3\u6790\u5f02\u5e38", e);
            }
        }
    }

    private static void validateParams(String inputTimeStr, int periodExecType, String startTimeStr, String endTimeStr) {
        if (inputTimeStr == null || inputTimeStr.trim().isEmpty()) {
            throw new IllegalArgumentException("\u8f93\u5165\u65f6\u95f4\u5b57\u7b26\u4e32\u4e0d\u53ef\u4e3a\u7a7a\uff01\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss");
        }
        if (periodExecType < 0 || periodExecType > 2) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u5468\u671f\u7c7b\u578b\uff01\u652f\u6301\uff1a0=\u6309\u5929\uff0c1=\u6309\u5468\uff0c2=\u6309\u6708");
        }
        if (startTimeStr == null || startTimeStr.trim().isEmpty() || endTimeStr == null || endTimeStr.trim().isEmpty()) {
            throw new IllegalArgumentException("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\uff01\u683c\u5f0f\uff1aHH:mm:ss");
        }
        try {
            Time.valueOf(startTimeStr);
            Time.valueOf(endTimeStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u4f20\u5165 HH:mm:ss \u683c\u5f0f\uff08\u5982 09:00:00\uff09", e);
        }
    }

    private static boolean matchCycle(Integer dayOfMonth, Integer dayOfWeek, List<Integer> periodList, int periodExecType) {
        switch (periodExecType) {
            case 0: {
                return true;
            }
            case 1: {
                return periodList.contains(dayOfWeek);
            }
            case 2: {
                if (dayOfMonth == null || dayOfMonth < 1 || dayOfMonth > 31) {
                    return false;
                }
                return periodList.contains(dayOfMonth);
            }
        }
        return false;
    }

    private static Time convertLocalTimeToSqlTime(LocalTime localTime) {
        return Time.valueOf(localTime);
    }

    public static boolean checkTaskMatch(String inputTimeStr, String periodListStr, int periodExecType, String startTimeStr, String endTimeStr) {
        DateUtils.validateParams(inputTimeStr, periodExecType, startTimeStr, endTimeStr);
        TimeParseResult timeResult = DateUtils.parseTimeInfo(inputTimeStr);
        Integer dayOfMonth = timeResult.getDayOfMonth();
        Integer dayOfWeek = timeResult.getDayOfWeek();
        Time inputTime = DateUtils.convertLocalTimeToSqlTime(timeResult.getInputDateTime().toLocalTime());
        List<Integer> periodList = StringSplitUtil.splitToIntList(periodListStr);
        boolean isCycleMatch = DateUtils.matchCycle(dayOfMonth, dayOfWeek, periodList, periodExecType);
        if (!isCycleMatch) {
            return false;
        }
        Time startTime = Time.valueOf(startTimeStr);
        Time endTime = Time.valueOf(endTimeStr);
        return DateUtils.isBetween(inputTime, startTime, endTime);
    }

    public static void main(String[] args) throws Exception {
        String inputTime1 = "2024-09-10 10:45:42";
        String periodList1 = "1,10,20";
        int execType1 = 2;
        String start1 = "09:00:00";
        String end1 = "18:00:00";
        boolean result1 = DateUtils.checkTaskMatch(inputTime1, periodList1, execType1, start1, end1);
        System.out.println("\u6309\u6708\u573a\u666f\uff08\u5339\u914d\u65e5\u671f+\u65f6\u95f4\uff09\uff1a" + result1);
        String inputTime2 = "2024-09-06 10:45:42";
        boolean result2 = DateUtils.checkTaskMatch(inputTime2, periodList1, execType1, start1, end1);
        System.out.println("\u6309\u6708\u573a\u666f\uff08\u4e0d\u5339\u914d\u65e5\u671f\uff09\uff1a" + result2);
        String inputTime3 = "2024-09-20 23:30:00";
        String start3 = "23:00:00";
        String end3 = "02:00:00";
        boolean result3 = DateUtils.checkTaskMatch(inputTime3, periodList1, execType1, start3, end3);
        System.out.println("\u6309\u6708\u573a\u666f\uff08\u8de8\u5929\u65f6\u95f4\u5339\u914d\uff09\uff1a" + result3);
        String inputTime4 = "2024-10-31 10:45:42";
        boolean result4 = DateUtils.checkTaskMatch(inputTime4, periodList1, execType1, start1, end1);
        System.out.println("\u6309\u6708\u573a\u666f\uff08\u65e5\u671f\u4e0d\u5728\u914d\u7f6e\u4e2d\uff09\uff1a" + result4);
        String inputTime5 = "2024-09-06 15:30:00";
        String periodList5 = "";
        int execType5 = 0;
        boolean result5 = DateUtils.checkTaskMatch(inputTime5, periodList5, execType5, start1, end1);
        System.out.println("\u6309\u5929\u573a\u666f\uff1a" + result5);
        String inputTime6 = "2024-09-06 10:45:42";
        String periodList6 = "1,3,5";
        int execType6 = 1;
        boolean result6 = DateUtils.checkTaskMatch(inputTime6, periodList6, execType6, start1, end1);
        System.out.println("\u6309\u5468\u573a\u666f\uff1a" + result6);
    }
}

