/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import cn.hutool.http.HttpRequest;
import com.ovopark.aicheck.utils.DateUtils;
import com.ovopark.aicheck.utils.Md5Kit;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class HMACSHA1Utils {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String genHMAC(String data, String key) {
        String result = null;
        try {
            SecretKeySpec signinKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signinKey);
            byte[] rawHmac = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
            result = Base64.encodeBase64String((byte[])rawHmac);
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e.getMessage());
        }
        catch (InvalidKeyException e) {
            System.err.println(e.getMessage());
        }
        if (null != result) {
            return result;
        }
        return null;
    }

    public static void main(String[] args) {
        String resultUrl = "https://raasr.xfyun.cn/v2/api/getResult";
        String appId = "52ef02f9";
        String secretKey = "ef99a102f4246ad5703ae4cd5bdd2181";
        String ts = DateUtils.getTimeString();
        String baseString = appId + ts;
        String sign = Md5Kit.encodeByMD5(32, baseString);
        String signa = HMACSHA1Utils.genHMAC(sign, secretKey);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("signa", signa);
        params.put("appId", appId);
        params.put("ts", ts);
        params.put("orderId", "DKHJQ202401041051250106oJ2wH3DKeROzyAK");
        params.put("resultType", "transfer");
        String result = HttpRequest.post((String)resultUrl).form(params).timeout(20000).execute().body();
        System.out.println("signa----" + signa);
        System.out.println("\u79d1\u5927\u8baf\u98de\u8bc6\u522b\u7ed3\u679c----" + result);
    }
}

