/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.exception;

import com.ovopark.aicheck.exception.CommonException;
import com.ovopark.aicheck.result.BaseResult;
import com.ovopark.aicheck.result.ReturnCode;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public Object handleBadRequest(Exception e) {
        if (e instanceof CommonException) {
            CommonException commonException = (CommonException)e;
            return BaseResult.error(commonException.getErrorCode(), commonException.getErrorCodeName(), commonException.getErrorMsg());
        }
        if (e instanceof ServletException) {
            return BaseResult.exception(ReturnCode.REQUEST_ERROR, e.getMessage());
        }
        if (e instanceof HttpMessageConversionException) {
            log.error("====>>>\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff1a{}", (Object)e.getMessage());
            return BaseResult.exception(ReturnCode.REQUEST_PARAM_ERROR);
        }
        if (e instanceof DataAccessException) {
            log.error("====>>>\u6570\u636e\u5e93\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return BaseResult.exception(ReturnCode.DB_SQL_ERROR);
        }
        e.printStackTrace();
        log.error("====>>>\u672a\u77e5\u5f02\u5e38\u7c7b\u578b\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        return BaseResult.exception(ReturnCode.INTERNAL_SERVER_ERROR, e.getMessage());
    }
}

