/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.ovopark.aicheck.annotation.ExcelColumName;
import com.ovopark.aicheck.annotation.ExcelName;
import com.ovopark.aicheck.utils.I18nUtils;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EasyExcelUtils {
    private ExcelWriter excelWriter = null;
    private WriteSheet writeSheet = null;

    public void init(String sheetName, Class<?> tableClass, OutputStream outputStream, WriteHandler handler) {
        if (this.excelWriter == null && this.writeSheet == null) {
            this.excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((OutputStream)outputStream, tableClass).head(tableClass)).registerWriteHandler(handler)).build();
            this.writeSheet = EasyExcelFactory.writerSheet((String)sheetName).build();
        }
    }

    public void init2(String sheetName, List<List<String>> header, OutputStream outputStream, WriteHandler handler) {
        if (this.excelWriter == null && this.writeSheet == null) {
            this.excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((OutputStream)outputStream).head(header)).registerWriteHandler(handler)).build();
            this.writeSheet = EasyExcelFactory.writerSheet((String)sheetName).build();
        }
    }

    public void doExportExcel(List<?> dataList) {
        try {
            this.excelWriter.write(dataList, this.writeSheet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finish() {
        if (this.excelWriter != null) {
            this.excelWriter.finish();
        }
    }

    public static Class chooseLang(Class<?> source, String lang) throws NoSuchFieldException, IllegalAccessException {
        Field[] fields = source.getDeclaredFields();
        if (fields.length > 0) {
            block8: for (Field field : fields) {
                ExcelProperty anoExcel = field.getAnnotation(ExcelProperty.class);
                ExcelName anoExcelName = field.getAnnotation(ExcelName.class);
                if (anoExcel == null || anoExcelName == null) continue;
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(anoExcel);
                Field f = invocationHandler.getClass().getDeclaredField("memberValues");
                f.setAccessible(true);
                Map memberValues = (Map)f.get(invocationHandler);
                List<String> valueList = Arrays.asList(anoExcelName.names());
                if (valueList.size() != 2) continue;
                switch (lang) {
                    case "zh": {
                        memberValues.put("value", new String[]{valueList.get(0)});
                        continue block8;
                    }
                    case "en": {
                        memberValues.put("value", new String[]{valueList.get(1)});
                        continue block8;
                    }
                    default: {
                        memberValues.put("value", new String[]{valueList.get(0)});
                    }
                }
            }
        }
        return source;
    }

    public static Class i18nLang(Class<?> source, Locale locale) throws NoSuchFieldException, IllegalAccessException {
        Field[] fields = source.getDeclaredFields();
        if (fields.length > 0) {
            for (Field field : fields) {
                ExcelProperty anoExcel = field.getAnnotation(ExcelProperty.class);
                ExcelColumName anoExcelName = field.getAnnotation(ExcelColumName.class);
                if (anoExcel == null || anoExcelName == null) continue;
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(anoExcel);
                Field f = invocationHandler.getClass().getDeclaredField("memberValues");
                f.setAccessible(true);
                Map memberValues = (Map)f.get(invocationHandler);
                String columnName = I18nUtils.getMessage(anoExcelName.key(), locale);
                memberValues.put("value", new String[]{columnName});
            }
        }
        return source;
    }
}

