/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.ovopark.aicheck.context.SpringContextAware;
import com.ovopark.aicheck.properties.OssAliyunProperties;
import com.ovopark.aicheck.utils.DateUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class OssUtils {
    private static final Logger log = LoggerFactory.getLogger(OssUtils.class);
    private static String ossBucketName;
    private static String ossEndPoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String accessUrl;
    private static final String businessCode = "ovopark-ai";
    @Autowired
    private OssAliyunProperties ossAliyunProperties;
    private static volatile OSSClient instance;

    @PostConstruct
    public void init() {
        accessKeyId = this.ossAliyunProperties.getAccessKeyId();
        accessKeySecret = this.ossAliyunProperties.getAccessKeySecret();
        ossEndPoint = this.ossAliyunProperties.getEndpoint();
        ossBucketName = this.ossAliyunProperties.getBucketName();
        accessUrl = this.ossAliyunProperties.getAccessUrl();
    }

    public static synchronized OSSClient getInstance() {
        if (instance == null) {
            instance = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
        }
        return instance;
    }

    private static String basePath(Integer enterpriseId) {
        if (enterpriseId == null) {
            String profile = SpringContextAware.getActiveProfile();
            log.info("==========activeProfile========{}", (Object)profile);
            enterpriseId = "FORMAL".equalsIgnoreCase(profile) || "TASK".equalsIgnoreCase(profile) ? Integer.valueOf(211) : Integer.valueOf(1084);
        }
        return "ovopark-ai/" + enterpriseId + "/" + DateUtils.format(new Date(), "yyyy/MM/dd");
    }

    private static String buildOssFilePath(String imageName, Integer enterpriseId) {
        return OssUtils.basePath(enterpriseId) + "/" + imageName;
    }

    private static String buildOssFileName(String suffix) {
        String extName = suffix.substring(suffix.lastIndexOf("."));
        long millis = System.currentTimeMillis();
        Random random = new Random();
        int end3 = random.nextInt(999);
        String str = millis + String.format("%03d", end3);
        return str + extName;
    }

    public static String uploadFile(File file, String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            fileName = OssUtils.buildOssFileName(file.getName());
        }
        String ossFilePath = OssUtils.buildOssFilePath(fileName, null);
        OssUtils.putObject(file, fileName, ossFilePath);
        return ossFilePath;
    }

    public static String uploadByteFile(byte[] file, String preFileName, String fileName) {
        String imgName = OssUtils.buildOssFileName(preFileName);
        String newFileName = "";
        newFileName = preFileName + "/" + imgName;
        String imagePath = OssUtils.buildOssFilePath(newFileName, null);
        log.info("imgName==" + imgName);
        log.info("newFileName==" + newFileName);
        log.info("imagePath==" + imagePath);
        OssUtils.putByteFileObject(file, newFileName, imagePath);
        return accessUrl + "/" + imagePath;
    }

    public static String uploadMultipartFile(MultipartFile file, String originalFilename, Integer enterpriseId) {
        String imagePath = OssUtils.buildOssFilePath(originalFilename, enterpriseId);
        OssUtils.putMultipartObject(file, originalFilename, imagePath);
        return accessUrl + "/" + imagePath;
    }

    public static String uploadByInputStream(InputStream input, String fileName) {
        String imagePath = OssUtils.buildOssFilePath(fileName, 0);
        OSSClient client = OssUtils.getInstance();
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentType(OssUtils.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
        meta.setCacheControl("no-cache");
        client.putObject(ossBucketName, imagePath, input, meta);
        return accessUrl + "/" + imagePath;
    }

    public static String uploadByUrl(String url, String fileName) {
        InputStream in = OssUtils.getOssFileInputStream(url);
        String imagePath = OssUtils.uploadByInputStream(in, fileName);
        return imagePath;
    }

    public static InputStream getOssFileInputStream(String ossFilePath) {
        InputStream input = null;
        try {
            OSSClient client = OssUtils.getInstance();
            OSSObject obj = client.getObject(ossBucketName, ossFilePath);
            if (obj != null) {
                input = obj.getObjectContent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("=====oss -> downLoadFile:{}", (Object)e.getMessage());
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadFromOss(String ossFilePath, String localDir, String picName) {
        String localFilePath = localDir + File.separator + picName;
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            URL url = new URL(ossFilePath);
            URLConnection connection = url.openConnection();
            inputStream = connection.getInputStream();
            outputStream = new FileOutputStream(localFilePath);
            byte[] buffer = new byte[10240];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            String string = localFilePath;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("=====oss -> downloadFromOss\u65b9\u6cd5\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void deleteFile(String filePath) {
        try {
            OSSClient client = OssUtils.getInstance();
            client.deleteObject(ossBucketName, filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("=====oss -> deleteFile:{}", (Object)e.getMessage());
        }
    }

    private static void putObject(File file, String fileName, String imagePath) {
        try {
            OSSClient client = OssUtils.getInstance();
            FileInputStream input = new FileInputStream(file);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssUtils.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, (InputStream)input, meta);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            log.warn("=====oss -> putObject:{}", (Object)e.getMessage());
        }
    }

    private static String contentType(String fileType) {
        fileType = fileType.toLowerCase();
        String contentType = "";
        switch (fileType) {
            case "bmp": {
                contentType = "image/bmp";
                break;
            }
            case "gif": {
                contentType = "image/gif";
                break;
            }
            case "png": 
            case "jpeg": 
            case "jpg": {
                contentType = "image/jpeg";
                break;
            }
            case "html": {
                contentType = "text/html";
                break;
            }
            case "txt": {
                contentType = "text/plain";
                break;
            }
            case "vsd": {
                contentType = "application/vnd.visio";
                break;
            }
            case "ppt": 
            case "pptx": {
                contentType = "application/vnd.ms-powerpoint";
                break;
            }
            case "doc": 
            case "docx": {
                contentType = "application/msword";
                break;
            }
            case "xml": {
                contentType = "text/xml";
                break;
            }
            case "mp4": {
                contentType = "video/mp4";
                break;
            }
            default: {
                contentType = "application/octet-stream";
            }
        }
        return contentType;
    }

    private static void putByteFileObject(byte[] file, String fileName, String imagePath) {
        try {
            OSSClient client = OssUtils.getInstance();
            ByteArrayInputStream input = new ByteArrayInputStream(file);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssUtils.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, (InputStream)input, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("=====oss -> putByteFileObject:{}", (Object)e.getMessage());
        }
    }

    private static void putMultipartObject(MultipartFile file, String fileName, String imagePath) {
        OSSClient client = OssUtils.getInstance();
        try {
            InputStream input = file.getInputStream();
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssUtils.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, input, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("=====oss -> putMultipartObject:{}", (Object)e.getMessage());
        }
    }

    public static String getAccessUrl() {
        return accessUrl;
    }

    static {
        instance = null;
    }
}

