/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;

@Configuration
public class KafkaConfigK1 {
    @Primary
    @ConfigurationProperties(prefix="spring.kafka.k1")
    @Bean
    public KafkaProperties kafkaPropertiesK1() {
        return new KafkaProperties();
    }

    @Primary
    @Bean
    public KafkaTemplate<String, String> kafkaTemplateK1(@Autowired @Qualifier(value="kafkaPropertiesK1") KafkaProperties kafkaPropertiesK1) {
        return new KafkaTemplate(this.producerFactoryK1(kafkaPropertiesK1));
    }

    @Bean(value={"kafkaListenerContainerFactoryK1"})
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> kafkaListenerContainerFactoryK1(@Autowired @Qualifier(value="kafkaPropertiesK1") KafkaProperties kafkaPropertiesK1) {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactoryK1(kafkaPropertiesK1));
        return factory;
    }

    private ConsumerFactory<? super Integer, ? super String> consumerFactoryK1(KafkaProperties kafkaPropertiesK1) {
        return new DefaultKafkaConsumerFactory(kafkaPropertiesK1.buildConsumerProperties());
    }

    private DefaultKafkaProducerFactory<String, String> producerFactoryK1(KafkaProperties kafkaPropertiesK1) {
        return new DefaultKafkaProducerFactory(kafkaPropertiesK1.buildProducerProperties());
    }
}

