/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.constant.enums;

import java.util.Locale;

public enum AiDataSourceEnum {
    PRESENCE(1, "\u4e91\u7aef\u6293\u62cd", "Cloud"),
    DURATION(2, "\u677f\u7aef\u6293\u62cd", "Devices");

    private final Integer type;
    private final String nameZH;
    private final String nameEN;

    private AiDataSourceEnum(Integer type, String nameZH, String nameEN) {
        this.type = type;
        this.nameZH = nameZH;
        this.nameEN = nameEN;
    }

    public static String getName(Integer type, String language) {
        for (AiDataSourceEnum value : AiDataSourceEnum.values()) {
            if (!value.getType().equals(type)) continue;
            if (Locale.ENGLISH.getLanguage().equals(language)) {
                return value.getNameEN();
            }
            return value.getNameZH();
        }
        return "";
    }

    public Integer getType() {
        return this.type;
    }

    public String getNameZH() {
        return this.nameZH;
    }

    public String getNameEN() {
        return this.nameEN;
    }
}

