/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);

    public static String getIpAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u672c\u673aIP\u5730\u5740\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return "";
    }
}

