/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtils {
    private static Logger log = LoggerFactory.getLogger(TimeUtils.class);
    public static Integer DEFAULT_TIME_ZONE = 8;

    public static Date getLocalTime(Long timeStamp, Integer timeZone, Integer isSummerTime, Date summerTimeStart, Date summerTimeEnd) {
        Date date = new Date(timeStamp);
        return TimeUtils.getLocalTime(date, timeZone, isSummerTime, summerTimeStart, summerTimeEnd);
    }

    public static Date getLocalTime(Date date, Integer timeZone, Integer isSummerTime, Date summerTimeStart, Date summerTimeEnd) {
        timeZone = timeZone != null ? timeZone : DEFAULT_TIME_ZONE;
        isSummerTime = isSummerTime == null ? 0 : isSummerTime;
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (timeZone <= 12) {
            cal.add(10, timeZone - DEFAULT_TIME_ZONE);
        } else {
            switch (timeZone) {
                case 13: {
                    cal.add(10, -9 - DEFAULT_TIME_ZONE);
                    cal.add(12, -30);
                    break;
                }
                case 14: {
                    cal.add(10, -3 - DEFAULT_TIME_ZONE);
                    cal.add(12, -30);
                    break;
                }
                case 15: {
                    cal.add(10, 3 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 16: {
                    cal.add(10, 4 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 17: {
                    cal.add(10, 5 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 18: {
                    cal.add(10, 6 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 19: {
                    cal.add(10, 9 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 20: {
                    cal.add(10, 10 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 21: {
                    cal.add(10, 13 - DEFAULT_TIME_ZONE);
                    break;
                }
                case 22: {
                    cal.add(10, 14 - DEFAULT_TIME_ZONE);
                    break;
                }
            }
        }
        if (TimeUtils.isDST(cal.getTime(), isSummerTime, summerTimeStart, summerTimeEnd)) {
            cal.add(10, 1);
        }
        return cal.getTime();
    }

    public static boolean isDST(Date now, Integer isSummerTime, Date summerTimeStart, Date summerTimeEnd) {
        boolean isDst = false;
        if (isSummerTime != null && isSummerTime > 0 && summerTimeStart != null && summerTimeEnd != null) {
            if (summerTimeEnd.after(summerTimeStart)) {
                if (!now.before(summerTimeStart) && now.before(summerTimeEnd)) {
                    isDst = true;
                }
            } else {
                isDst = !now.after(summerTimeEnd) || now.after(summerTimeStart);
            }
        }
        return isDst;
    }
}

