/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.aop;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.aicheck.exception.CommonException;
import com.ovopark.aicheck.feign.SsoFeign;
import com.ovopark.aicheck.model.auth.Authenticator;
import com.ovopark.aicheck.model.auth.ClientInfo;
import com.ovopark.aicheck.model.auth.TokenValue;
import com.ovopark.aicheck.model.auth.Users;
import com.ovopark.aicheck.result.BaseResult;
import com.ovopark.aicheck.result.ReturnCode;
import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;

public class AuthenticationInterceptor
implements HandlerInterceptor {
    @Autowired
    private SsoFeign ssoFeign;
    private static final Logger log = LoggerFactory.getLogger(AuthenticationInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String wdzToken = request.getHeader("Ovo-Authorization");
        log.info("=========\u4e07\u5e97\u638c\u7cfb\u7edf\u7528\u6237Token\u9a8c\u8bc1\uff0cOvo-Authorization={}", (Object)wdzToken);
        if (StringUtils.isEmpty((CharSequence)wdzToken)) {
            throw new CommonException(ReturnCode.TOKEN_LOST);
        }
        if (StringUtils.isNotEmpty((CharSequence)wdzToken)) {
            String[] auths = wdzToken.split(" ");
            String token = auths[0];
            log.info("=========\u4e07\u5e97\u638c\u7cfb\u7edf\u7528\u6237Token\u9a8c\u8bc1\uff0ctoken={}", (Object)token);
            BaseResult<TokenValue> ret = this.ssoFeign.parseToken(token);
            log.info("=========\u4e07\u5e97\u638c\u7cfb\u7edf\u7528\u6237Token\u9a8c\u8bc1\uff0ctoken={}\uff0c\u8fd4\u56de\uff1a{}", (Object)token, ret);
            if (ret.getIsError().booleanValue() || ret.getData() == null) {
                throw new CommonException(ReturnCode.TOKEN_EXPIRATION);
            }
            TokenValue wdzTokenInfo = ret.getData();
            ClientInfo clientInfo = new ClientInfo();
            clientInfo.setUserId(wdzTokenInfo.getUserId());
            clientInfo.setUserName(wdzTokenInfo.getUserName());
            Users user = new Users();
            user.setId(wdzTokenInfo.getUserId());
            user.setUserName(wdzTokenInfo.getUserName());
            user.setGroupId(wdzTokenInfo.getGroupId());
            clientInfo.setUser(user);
            Authenticator.getInstance().setCurrentClient(clientInfo);
            return true;
        }
        return false;
    }

    private Integer getEnterpriseIdFromHeader(HttpServletRequest request) {
        String enterpriseId = request.getHeader("enterpriseId");
        if (enterpriseId == null) {
            throw new CommonException(ReturnCode.PARAM_ERROR);
        }
        return Integer.parseInt(enterpriseId);
    }

    private Integer getEnterpriseIdFromParams(HttpServletRequest request) {
        String contentType = request.getContentType();
        log.info("=====> root - Content-Type\uff1a{}", (Object)contentType);
        if (contentType == null) {
            throw new CommonException(ReturnCode.REQUEST_ERROR);
        }
        String fieldValue = null;
        if (contentType.contains("application/json")) {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = request.getReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException e) {
                throw new CommonException(ReturnCode.PARAM_ERROR);
            }
            String jsonString = sb.toString();
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            fieldValue = jsonObject.getString("enterpriseId");
        } else {
            fieldValue = contentType.contains("multipart/form-data") ? request.getParameter("enterpriseId") : (contentType.contains("application/x-www-form-urlencoded") ? request.getParameter("enterpriseId") : request.getParameter("enterpriseId"));
        }
        if (StringUtils.isEmpty((CharSequence)fieldValue)) {
            throw new CommonException(ReturnCode.PARAM_ERROR);
        }
        return Integer.parseInt(fieldValue);
    }
}

