/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ovopark.aicheck.feign.OrganizeApi;
import com.ovopark.aicheck.model.organize.DepartmentMo;
import com.ovopark.aicheck.model.organize.EnterpriseGroupMo;
import com.ovopark.aicheck.model.organize.OrgNode;
import com.ovopark.aicheck.model.organize.OrgRoot;
import com.ovopark.aicheck.model.organize.OrgUser;
import com.ovopark.aicheck.model.organize.PermittedOrgQry;
import com.ovopark.aicheck.model.organize.PermittedOrgTreeNode;
import com.ovopark.aicheck.model.organize.SimpleTagAndOrganizeMo;
import com.ovopark.aicheck.result.BaseResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OvoparkOrganizeUtils {
    private static final Logger log = LoggerFactory.getLogger(OvoparkOrganizeUtils.class);
    @Autowired
    private OrganizeApi organizeApi;
    private static OrganizeApi organizeApiInstance;

    @PostConstruct
    public void init() {
        organizeApiInstance = this.organizeApi;
    }

    public static List<PermittedOrgTreeNode> getSelectedOrgNode(Integer userId, String deptIds, Integer enterpriseId) {
        ArrayList<PermittedOrgTreeNode> depList = new ArrayList<PermittedOrgTreeNode>();
        List<Integer> depIdList = StrUtil.splitTrim((CharSequence)deptIds, (CharSequence)",").stream().filter(e -> e.startsWith("S_")).map(e -> Integer.parseInt(e.replace("S_", ""))).collect(Collectors.toList());
        List<Integer> orgIdList = StrUtil.splitTrim((CharSequence)deptIds, (CharSequence)",").stream().filter(e -> e.startsWith("O_")).map(e -> Integer.parseInt(e.replace("O_", ""))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(depIdList) && CollectionUtils.isEmpty(orgIdList)) {
            return depList;
        }
        try {
            PermittedOrgQry qry = new PermittedOrgQry();
            qry.setUserId(userId);
            qry.setGroupId(enterpriseId);
            qry.setPickOrgIdList(orgIdList);
            qry.setPickDepIdList(depIdList);
            qry.setOpenStatusList(new ArrayList<Integer>());
            log.info("======\u8bf7\u6c42\u63a5\u53e3\u53c2\u6570-getSelectedOrgNode---{}", (Object)qry);
            BaseResult<List<PermittedOrgTreeNode>> nodeTreeResult = organizeApiInstance.getOrganizeAndDep(qry);
            log.info("======\u8bf7\u6c42\u63a5\u53e3\u8fd4\u56de-getSelectedOrgNode---{}", nodeTreeResult);
            List<PermittedOrgTreeNode> nodeTree = nodeTreeResult.getData();
            OvoparkOrganizeUtils.pickDepList(depList, nodeTree);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.warn("======\u8bf7\u6c42\u63a5\u53e3\u9519\u8bef-getSelectedOrgNode---{}", (Object)e2.getMessage());
        }
        return depList;
    }

    public static OrgRoot getOrgRoot(Integer enterpriseId) {
        OrgRoot orgRoot = new OrgRoot();
        log.info("-------\u6839\u636e\u4f01\u4e1aid\u83b7\u53d6\u7ec4\u7ec7\u6839\u8282\u70b9-------{}", (Object)enterpriseId);
        BaseResult<OrgRoot> result = organizeApiInstance.getRootOrganizeByGroupId(enterpriseId);
        if (result == null || result.getIsError().booleanValue()) {
            log.warn("======\u8bf7\u6c42\u63a5\u53e3\u9519\u8bef-getOrgRootName---{}", (Object)JSON.toJSONString(result));
            return orgRoot;
        }
        if (result.getData() != null) {
            orgRoot = result.getData();
        }
        return orgRoot;
    }

    public static List<OrgNode> getOrgNodeName(String nodeId) {
        List<OrgNode> orgRoot = new ArrayList<OrgNode>();
        log.info("-------\u6839\u636e\u7ec4\u7ec7ID\u83b7\u53d6\u7ec4\u7ec7\u8282\u70b9\u540d\u79f0-------{}", (Object)nodeId);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("typeIds", Arrays.asList(nodeId));
        BaseResult<List<OrgNode>> result = organizeApiInstance.getNamesByType(params);
        if (result == null || result.getIsError().booleanValue()) {
            log.warn("======\u8bf7\u6c42\u63a5\u53e3\u9519\u8bef-getOrgNodeName---{}", (Object)JSON.toJSONString(result));
            return orgRoot;
        }
        if (CollectionUtils.isNotEmpty((Collection)result.getData())) {
            orgRoot = result.getData();
        }
        return orgRoot;
    }

    public static EnterpriseGroupMo getEnterpriseByGroupId(Integer groupId) {
        log.info("-------\u6839\u636e\u4f01\u4e1aid\u83b7\u53d6\u4f01\u4e1a\u5b9e\u4f53-------{}", (Object)groupId);
        BaseResult<EnterpriseGroupMo> result = organizeApiInstance.getEnterpriseByGroupIdApi(groupId);
        if (result == null || result.getIsError().booleanValue()) {
            log.warn("======\u8bf7\u6c42\u63a5\u53e3\u9519\u8bef-getEnterpriseByGroupId---{}", (Object)JSON.toJSONString(result));
            return null;
        }
        return result.getData();
    }

    public static DepartmentMo getDepartmentById(Integer depId) {
        log.info("-------\u6839\u636e\u95e8\u5e97depId \u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u5217\u8868-------{}", (Object)depId);
        BaseResult<DepartmentMo> baseResult = organizeApiInstance.getDepartmentById(depId);
        if (baseResult == null || baseResult.getIsError().booleanValue()) {
            log.warn("======\u8bf7\u6c42\u63a5\u53e3\u9519\u8bef-getDepartmentById---{}", (Object)JSON.toJSONString(baseResult));
            return null;
        }
        return baseResult.getData();
    }

    public static List<DepartmentMo> getDepartmentByIdList(List<Integer> depIdList) {
        log.info("-------\u6839\u636e\u95e8\u5e97depIdList \u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u5217\u8868-------{}", depIdList);
        if (CollectionUtils.isEmpty(depIdList)) {
            return null;
        }
        BaseResult<List<DepartmentMo>> baseResult = organizeApiInstance.getDepartmentByIds(depIdList);
        if (baseResult == null || baseResult.getIsError().booleanValue()) {
            log.warn("======\u8bf7\u6c42\u63a5\u53e3\u9519\u8bef-getDepartmentByIdList---{}", (Object)JSON.toJSONString(baseResult));
            return null;
        }
        return baseResult.getData();
    }

    public static List<DepartmentMo> getDepartmentByIds(String depIds) {
        log.info("-------\u6839\u636e\u95e8\u5e97depIds \u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u5217\u8868-------{}", (Object)depIds);
        List<Integer> depIdList = StrUtil.splitTrim((CharSequence)depIds, (CharSequence)",").stream().map(Integer::parseInt).collect(Collectors.toList());
        return OvoparkOrganizeUtils.getDepartmentByIdList(depIdList);
    }

    public static Map<Integer, SimpleTagAndOrganizeMo> getOrganizeNames(List<Integer> depIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("depIds", depIds);
        params.put("showPojo", false);
        params.put("showName", true);
        log.info("======\u8bf7\u6c42\u63a5\u53e3\u53c2\u6570-getOrganizeNames---{}", (Object)JSON.toJSONString(params));
        BaseResult<Map<Integer, SimpleTagAndOrganizeMo>> baseResult = organizeApiInstance.getOrganizeNames(params);
        if (baseResult == null || baseResult.getIsError().booleanValue()) {
            log.warn("======\u8bf7\u6c42\u63a5\u53e3\u9519\u8bef-getOrganizeNames---{}", (Object)JSON.toJSONString(baseResult));
            return new HashMap<Integer, SimpleTagAndOrganizeMo>();
        }
        return baseResult.getData();
    }

    public static List<DepartmentMo> getDeptListByGroupIdAndName(Integer enterpriseId, String depName) {
        log.info("======\u8bf7\u6c42\u63a5\u53e3\u53c2\u6570-getDeptListByGroupIdAndName---enterpriseId:{},depName:{}", (Object)enterpriseId, (Object)depName);
        BaseResult<List<DepartmentMo>> baseResult = organizeApiInstance.getDeptListByGroupIdAndName(enterpriseId, depName);
        if (baseResult == null || baseResult.getIsError().booleanValue()) {
            log.warn("======\u8bf7\u6c42\u63a5\u53e3\u9519\u8bef-getDeptListByGroupIdAndName---{}", (Object)JSON.toJSONString(baseResult));
            return null;
        }
        return baseResult.getData();
    }

    public static List<OrgUser> getUserListByRoleId(Integer enterpriseId, Integer depId, Integer roleId) {
        log.info("======\u8bf7\u6c42\u63a5\u53e3\u53c2\u6570-getUserListByRoleId---enterpriseId:{},depId:{},roleId:{}", new Object[]{enterpriseId, depId, roleId});
        BaseResult<List<OrgUser>> baseResult = organizeApiInstance.getUserByRoleId(enterpriseId, depId, roleId);
        if (baseResult == null || baseResult.getIsError().booleanValue()) {
            log.warn("======\u8bf7\u6c42\u63a5\u53e3\u9519\u8bef-getUserListByRoleId---{}", (Object)JSON.toJSONString(baseResult));
            return null;
        }
        return baseResult.getData();
    }

    public static void pickDepList(List<PermittedOrgTreeNode> depList, List<PermittedOrgTreeNode> nodeList) {
        if (CollectionUtils.isNotEmpty(nodeList)) {
            nodeList.forEach(node -> {
                if (node.getType() == 1) {
                    depList.add((PermittedOrgTreeNode)node);
                } else {
                    List<PermittedOrgTreeNode> leaves = node.getLeaves();
                    OvoparkOrganizeUtils.pickDepList(depList, leaves);
                }
            });
        }
    }

    public static String getShowOrganizeName(List<String> orgAllNames) {
        if (CollectionUtils.isNotEmpty(orgAllNames)) {
            ArrayList<String> orgNames = new ArrayList<String>();
            if (orgAllNames.size() > 2) {
                for (int i = orgAllNames.size() - 2; i > 0 && orgNames.size() < 3; --i) {
                    orgNames.add(orgAllNames.get(i));
                }
                Collections.reverse(orgNames);
            } else {
                for (int i = 0; i < orgAllNames.size() - 1; ++i) {
                    orgNames.add(orgAllNames.get(i));
                }
            }
            return StringUtils.join(orgNames, (String)"/");
        }
        return "";
    }
}

