/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.easyexcel;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.util.List;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;

public class CustomizeWriteHandler
implements CellWriteHandler {
    private int mergeColumnIndex;
    private int mergeRowIndex;

    public CustomizeWriteHandler() {
    }

    public CustomizeWriteHandler(int mergeRowIndex, int mergeColumnIndex) {
        this.mergeRowIndex = mergeRowIndex;
        this.mergeColumnIndex = mergeColumnIndex;
    }

    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer columnIndex, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, WriteCellData<?> cellData, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        if (!isHead.booleanValue()) {
            switch (cell.getCellType()) {
                case STRING: {
                    String stringCellValue = cell.getStringCellValue();
                    if (!StringUtils.isBlank((CharSequence)stringCellValue)) break;
                    cell.setCellValue("\u2014\u2014");
                    break;
                }
                case BLANK: {
                    cell.setCellValue("\u2014\u2014");
                }
            }
            this.addHyperlink(writeSheetHolder, cell);
        }
    }

    private void addHyperlink(WriteSheetHolder writeSheetHolder, Cell cell) {
        String cellValue;
        String string = cellValue = cell.getCellType() == CellType.STRING ? cell.getStringCellValue() : null;
        if (StringUtils.isNotBlank((CharSequence)cellValue) && cellValue.startsWith("http")) {
            CreationHelper creationHelper = writeSheetHolder.getSheet().getWorkbook().getCreationHelper();
            Hyperlink hyperlink = creationHelper.createHyperlink(HyperlinkType.URL);
            hyperlink.setAddress(cellValue);
            cell.setHyperlink(hyperlink);
        }
    }

    private void mergeWithPrevRow(WriteSheetHolder writeSheetHolder, Cell cell, int curRowIndex, int curColIndex) {
        String stringCellValue;
        String string = stringCellValue = cell.getCellType() == CellType.STRING ? cell.getStringCellValue() : null;
        if (StringUtils.isNotBlank((CharSequence)stringCellValue)) {
            CreationHelper creationHelper = writeSheetHolder.getSheet().getWorkbook().getCreationHelper();
            Hyperlink hyperlink = creationHelper.createHyperlink(HyperlinkType.URL);
            hyperlink.setAddress(stringCellValue);
            cell.setHyperlink(hyperlink);
        }
    }
}

