/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import com.ovopark.aicheck.excel.WriteExcelDataDelegated;
import com.ovopark.aicheck.utils.ObsFileUtils;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ImageIcon;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiUtil {
    private static final Logger log = LoggerFactory.getLogger(PoiUtil.class);
    public static final Integer PER_SHEET_ROW_COUNT = 1000000;
    public static final Integer PER_WRITE_ROW_COUNT = 2000;
    public static final Integer PER_SHEET_WRITE_COUNT = PER_SHEET_ROW_COUNT / PER_WRITE_ROW_COUNT;
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    public static String formatDate(Date date, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static SXSSFWorkbook initExcel(Integer totalRowCount, String[] titles) {
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        int sheetCount = totalRowCount % PER_SHEET_ROW_COUNT == 0 ? totalRowCount / PER_SHEET_ROW_COUNT : totalRowCount / PER_SHEET_ROW_COUNT + 1;
        CellStyle style = PoiUtil.getCellStyle(wb);
        for (int i = 0; i < sheetCount; ++i) {
            SXSSFSheet sheet = wb.createSheet("sheet" + (i + 1));
            SXSSFRow headRow = sheet.createRow(0);
            for (int j = 0; j < titles.length; ++j) {
                SXSSFCell headRowCell = headRow.createCell(j);
                headRowCell.setCellValue(titles[j]);
                headRowCell.setCellStyle(style);
            }
        }
        return wb;
    }

    public static SXSSFWorkbook getWorkBook(String[] titles, String fileName) {
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        CellStyle style = PoiUtil.getCellStyle(wb);
        SXSSFSheet sheet = wb.createSheet(fileName);
        SXSSFRow headRow = sheet.createRow(0);
        for (int j = 0; j < titles.length; ++j) {
            SXSSFCell headRowCell = headRow.createCell(j);
            headRowCell.setCellValue(titles[j]);
            headRowCell.setCellStyle(style);
        }
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downLoadExcelToLocalPath(SXSSFWorkbook wb, String exportPath) {
        FileOutputStream fops = null;
        try {
            fops = new FileOutputStream(exportPath);
            wb.write((OutputStream)fops);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != wb) {
                try {
                    wb.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (null != fops) {
                try {
                    fops.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downLoadExcelToWebsite(SXSSFWorkbook wb, HttpServletResponse response, String fileName) throws IOException {
        response.setHeader("Content-disposition", "attachment; filename=" + new String((fileName + ".xlsx").getBytes(StandardCharsets.UTF_8), "ISO8859-1"));
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            wb.write((OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != wb) {
                try {
                    wb.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void exportExcelToLocalPath(Integer totalRowCount, String[] titles, String exportPath, WriteExcelDataDelegated writeExcelDataDelegated) throws Exception {
        log.info("\u5f00\u59cb\u5bfc\u51fa\uff1a" + PoiUtil.formatDate(new Date(), YYYY_MM_DD_HH_MM_SS));
        SXSSFWorkbook wb = PoiUtil.getWorkbook(totalRowCount, titles);
        int sheetCount = wb.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            SXSSFSheet eachSheet = wb.getSheetAt(i);
            for (int j = 1; j <= PER_SHEET_WRITE_COUNT; ++j) {
                int currentPage = i * PER_SHEET_WRITE_COUNT + j;
                int pageSize = PER_WRITE_ROW_COUNT;
                int startRowCount = (j - 1) * PER_WRITE_ROW_COUNT + 1;
                int endRowCount = startRowCount + pageSize - 1;
                writeExcelDataDelegated.writeExcelData(eachSheet, wb, startRowCount, endRowCount, currentPage, pageSize);
            }
        }
        PoiUtil.downLoadExcelToLocalPath(wb, exportPath);
        log.info("\u5bfc\u51fa\u5b8c\u6210\uff1a" + PoiUtil.formatDate(new Date(), YYYY_MM_DD_HH_MM_SS));
    }

    public static void exportExcelToWebsite(HttpServletResponse response, Integer totalRowCount, String fileName, String[] titles, WriteExcelDataDelegated writeExcelDataDelegated) throws Exception {
        SXSSFWorkbook wb = PoiUtil.getWorkbook(totalRowCount, titles);
        int sheetCount = wb.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            SXSSFSheet eachSheet = wb.getSheetAt(i);
            int num = totalRowCount / PER_WRITE_ROW_COUNT + 1;
            for (int j = 1; j <= num; ++j) {
                int currentPage = i * PER_SHEET_WRITE_COUNT + j;
                int pageSize = PER_WRITE_ROW_COUNT;
                int startRowCount = (j - 1) * PER_WRITE_ROW_COUNT + 1;
                int endRowCount = startRowCount + pageSize - 1;
                writeExcelDataDelegated.writeExcelData(eachSheet, wb, startRowCount, endRowCount, currentPage, pageSize);
            }
        }
        PoiUtil.downLoadExcelToWebsite(wb, response, fileName);
    }

    public static SXSSFWorkbook exportExcel(Integer totalRowCount, String[] titles, WriteExcelDataDelegated writeExcelDataDelegated) throws Exception {
        SXSSFWorkbook wb = PoiUtil.getWorkbook(totalRowCount, titles);
        int sheetCount = wb.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            SXSSFSheet eachSheet = wb.getSheetAt(i);
            int num = totalRowCount / PER_WRITE_ROW_COUNT + 1;
            for (int j = 1; j <= num; ++j) {
                int currentPage = i * PER_SHEET_WRITE_COUNT + j;
                int pageSize = PER_WRITE_ROW_COUNT;
                int startRowCount = (j - 1) * PER_WRITE_ROW_COUNT + 1;
                int endRowCount = startRowCount + pageSize - 1;
                writeExcelDataDelegated.writeExcelData(eachSheet, wb, startRowCount, endRowCount, currentPage, pageSize);
            }
        }
        return wb;
    }

    private static SXSSFWorkbook getWorkbook(Integer totalRowCount, String[] titles) {
        return PoiUtil.initExcel(totalRowCount, titles);
    }

    public static CellStyle getStyle(SXSSFWorkbook wb, Short color) {
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        if (color != null) {
            Font font = wb.createFont();
            font.setColor(color.shortValue());
            font.setUnderline((byte)1);
            style.setFont(font);
        }
        return style;
    }

    public static CellStyle getFontStyle(SXSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName("Arial");
        style.setFont(font);
        return style;
    }

    public static CellStyle getCellStyle(SXSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setWrapText(true);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        return style;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }

    public static boolean validateExcel(String filePath) {
        return filePath != null && (PoiUtil.isExcel2003(filePath) || PoiUtil.isExcel2007(filePath));
    }

    public static List<Row> getExcelRead(String fileName, InputStream is, boolean isTitle) throws Exception {
        Workbook workbook = PoiUtil.getWorkbook(fileName, is);
        Sheet sheet = workbook.getSheetAt(0);
        int count = 0;
        ArrayList<Row> list = new ArrayList<Row>();
        for (Row row : sheet) {
            if (count == 0 && isTitle) {
                ++count;
                continue;
            }
            if (row == null) continue;
            list.add(row);
        }
        return list;
    }

    public static Workbook getWorkbook(String fileName, InputStream is) throws Exception {
        Object workbook = null;
        boolean isExcel2003 = true;
        if (PoiUtil.isExcel2007(fileName)) {
            isExcel2003 = false;
        }
        workbook = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
        return workbook;
    }

    public static String getCellValue(Cell cell) {
        String cellValue = "";
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    cellValue = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue())).toString();
                    break;
                }
                DataFormatter dataFormatter = new DataFormatter();
                cellValue = dataFormatter.formatCellValue(cell);
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            case FORMULA: {
                cellValue = cell.getCellFormula() + "";
                break;
            }
            case BLANK: {
                cellValue = "";
                break;
            }
            case ERROR: {
                cellValue = "\u975e\u6cd5\u5b57\u7b26";
                break;
            }
            default: {
                cellValue = "\u672a\u77e5\u7c7b\u578b";
            }
        }
        return cellValue;
    }

    public static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            try {
                CellRangeAddress range = sheet.getMergedRegion(i);
                int firstColumn = range.getFirstColumn();
                int lastColumn = range.getLastColumn();
                int firstRow = range.getFirstRow();
                int lastRow = range.getLastRow();
                if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getMergedRegionValue_check(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            try {
                CellRangeAddress ca = sheet.getMergedRegion(i);
                int firstColumn = ca.getFirstColumn();
                int lastColumn = ca.getLastColumn();
                int firstRow = ca.getFirstRow();
                int lastRow = ca.getLastRow();
                if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
                Row fRow = sheet.getRow(firstRow);
                Cell fCell = fRow.getCell(firstColumn);
                return PoiUtil.getCellValue(fCell);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getCellValueAsJudge_check(Cell cell) {
        int column;
        int row;
        if (cell == null) {
            return "";
        }
        Sheet sheet = cell.getSheet();
        if (PoiUtil.isMergedRegion(sheet, row = cell.getRowIndex(), column = cell.getColumnIndex())) {
            return PoiUtil.getMergedRegionValue_check(sheet, row, column);
        }
        return PoiUtil.getCellValue(cell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeImageToExcel(SXSSFSheet eachSheet, SXSSFWorkbook wb, int col, int row, String path, int oss) {
        InputStream input = null;
        String type = path.substring(path.lastIndexOf(".") + 1);
        int pictureType = 5;
        if (type.equalsIgnoreCase("png")) {
            pictureType = 6;
        }
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        if (oss == 1) {
            try {
                input = ObsFileUtils.downloadToInputStream(path);
                if (input == null) return;
                BufferedImage bufferedImage = ImageIO.read(input);
                ImageIO.write((RenderedImage)bufferedImage, type, byteArrayOut);
                SXSSFDrawing drawing = eachSheet.createDrawingPatriarch();
                XSSFClientAnchor anchor = new XSSFClientAnchor(1, 1, 512, 125, (int)((short)col), row, (short)col + 1, row + 1);
                drawing.createPicture((ClientAnchor)anchor, wb.addPicture(byteArrayOut.toByteArray(), pictureType));
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            finally {
                try {
                    byteArrayOut.close();
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        int index = path.indexOf("s");
        File file = new File("/extend/shopweb/" + path.substring(index));
        FileInputStream fis = null;
        try {
            if (!file.exists()) return;
            fis = new FileInputStream(file);
            Image image = Toolkit.getDefaultToolkit().getImage(file.getPath());
            BufferedImage bufferedImage = PoiUtil.toBufferedImage(image);
            SXSSFDrawing drawing = eachSheet.createDrawingPatriarch();
            ImageIO.write((RenderedImage)bufferedImage, type, byteArrayOut);
            XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 512, 125, (int)((short)col), row, (short)col + 1, row + 1);
            drawing.createPicture((ClientAnchor)anchor, wb.addPicture(byteArrayOut.toByteArray(), 3));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            try {
                byteArrayOut.close();
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] readInputStream(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = is.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.flush();
        return bos.toByteArray();
    }

    private static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }
}

