/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.config;

import com.ovopark.aicheck.properties.XxlJobProperties;
import com.ovopark.aicheck.utils.IpUtils;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class XxlJobConfig {
    private static final Logger log = LoggerFactory.getLogger(XxlJobConfig.class);
    @Resource
    private XxlJobProperties xxlJobProperties;

    @Bean(initMethod="start", destroyMethod="destroy")
    public XxlJobSpringExecutor xxlJobExecutor() {
        log.info(">>>>>>>>>>> xxl-job config init.");
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setAdminAddresses(this.xxlJobProperties.getAddress());
        xxlJobSpringExecutor.setAccessToken(this.xxlJobProperties.getAccessToken());
        xxlJobSpringExecutor.setAppName(this.xxlJobProperties.getExecutor().getAppname());
        String localIp = this.xxlJobProperties.getExecutor().getIp();
        if (StringUtils.isEmpty((CharSequence)localIp)) {
            localIp = IpUtils.getIpAddress();
            log.info("\u672c\u673a\u516c\u7f51\uff1a{}", (Object)localIp);
        }
        xxlJobSpringExecutor.setIp(localIp);
        xxlJobSpringExecutor.setPort(this.xxlJobProperties.getExecutor().getPort().intValue());
        xxlJobSpringExecutor.setLogPath(this.xxlJobProperties.getExecutor().getLogpath());
        xxlJobSpringExecutor.setLogRetentionDays(this.xxlJobProperties.getExecutor().getLogretentiondays().intValue());
        log.info(">>>>>>>>>>> xxl-job\u542f\u52a8\u6210\u529f ip\uff1a{}\uff0c\u7aef\u53e3\uff1a{}", (Object)localIp, (Object)this.xxlJobProperties.getExecutor().getPort());
        return xxlJobSpringExecutor;
    }
}

