/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.context;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContextAware
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextAware.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) {
        return SpringContextAware.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringContextAware.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringContextAware.getApplicationContext().getBean(name, clazz);
    }

    public static Object getBeanByClass(Class clazz) {
        return SpringContextAware.getApplicationContext().getBean(clazz);
    }

    public static String getActiveProfile() {
        if (applicationContext == null || applicationContext.getEnvironment() == null || applicationContext.getEnvironment().getActiveProfiles().length == 0) {
            return "";
        }
        return applicationContext.getEnvironment().getActiveProfiles()[0];
    }
}

