/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import com.google.gson.Gson;
import com.ovopark.aicheck.model.cmiot.Coordinate;
import com.ovopark.aicheck.utils.ObsFileUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageBoxDrawer {
    private static final Logger log = LoggerFactory.getLogger(ImageBoxDrawer.class);
    private static final Gson gson = new Gson();

    public static String drawRedBoxesAndKeepOriginal(String imageUrl, List<Map<String, Coordinate>> infoList, Color color, int strokeWidth, String mac) throws Exception {
        log.info("\u5f00\u59cb\u7ed8\u5236\u7ea2\u8272\u6846\uff08\u539f\u56fe\u4e0d\u53d8\uff09- URL:{}", (Object)imageUrl);
        String fileName = ObsFileUtils.extractPureFileName(imageUrl) + "_" + System.currentTimeMillis() + "_redBox.jpg";
        String resultImgUrl = "";
        BufferedImage originalImage = ImageBoxDrawer.downloadImage(imageUrl);
        if (originalImage == null) {
            throw new IOException("\u4e0b\u8f7d\u56fe\u7247\u5931\u8d25 - URL:" + imageUrl);
        }
        BufferedImage modifiedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), originalImage.getType());
        Graphics2D g2d = modifiedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.drawImage(originalImage, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
        int validBoxCount = 0;
        if (infoList != null && !infoList.isEmpty()) {
            for (Map<String, Coordinate> labelMap : infoList) {
                for (Map.Entry<String, Coordinate> entry : labelMap.entrySet()) {
                    Coordinate coord = entry.getValue();
                    if (!ImageBoxDrawer.isValidCoord(coord, originalImage.getWidth(), originalImage.getHeight())) continue;
                    g2d.setColor(color);
                    g2d.setStroke(new BasicStroke(strokeWidth, 1, 1));
                    g2d.drawRect(coord.getLeft(), coord.getTop(), coord.getWidth(), coord.getHeight());
                    ++validBoxCount;
                }
            }
        }
        log.info("\u7ed8\u5236\u5b8c\u6210 - \u6709\u6548\u7ea2\u8272\u6846\u6570\u91cf:{}", (Object)validBoxCount);
        g2d.dispose();
        InputStream input = ImageBoxDrawer.getInputStreamByBufferedImage(modifiedImage);
        resultImgUrl = ObsFileUtils.upload(input, fileName, mac);
        log.info("\u5e26\u7ea2\u8272\u6846\u56fe\u7247\u4e0a\u4f20\u6210\u529f - URL:{}", (Object)resultImgUrl);
        return resultImgUrl;
    }

    private static boolean isValidCoord(Coordinate coord, int imgWidth, int imgHeight) {
        if (coord == null) {
            return false;
        }
        return coord.getWidth() > 0 && coord.getHeight() > 0 && coord.getLeft() >= 0 && coord.getTop() >= 0 && coord.getLeft() + coord.getWidth() <= imgWidth && coord.getTop() + coord.getHeight() <= imgHeight;
    }

    private static BufferedImage downloadImage(String imageUrl) throws IOException {
        BufferedImage image = null;
        try {
            URL url = new URL(imageUrl);
            InputStream in = url.openStream();
            image = ImageIO.read(in);
        }
        catch (IOException e) {
            log.info("=============\u751f\u6210\u753b\u6846\u56fe\u7247\uff0c\u56fe\u7247\u4e0d\u5b58\u5728!", (Throwable)e);
            e.printStackTrace();
        }
        return image;
    }

    private static InputStream getInputStreamByBufferedImage(BufferedImage image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static void main(String[] args) throws Exception {
        String imageUrl = "https://gms-img-ai.ovopark.com/20251101/11d7c08f-83ae-4065-abfb-121fd723c281:20251101000000.jpg";
        HashMap<String, Coordinate> map = new HashMap<String, Coordinate>();
        map.put("person", new Coordinate(50, 50, 200, 400));
        List<Map> infoList = Arrays.asList(map);
        Color defaultColor = Color.RED;
        int strokeWidth = 6;
        log.info("\u5f00\u59cb\u7ed8\u5236\u7ea2\u8272\u6846\uff08\u539f\u56fe\u4e0d\u53d8\uff09- URL:{}", (Object)imageUrl);
        String fileName = ObsFileUtils.extractPureFileName(imageUrl) + "_" + System.currentTimeMillis() + "_redBox.jpg";
        String resultImgUrl = "";
        BufferedImage originalImage = ImageBoxDrawer.downloadImage(imageUrl);
        if (originalImage == null) {
            throw new IOException("\u4e0b\u8f7d\u56fe\u7247\u5931\u8d25 - URL:" + imageUrl);
        }
        BufferedImage modifiedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), originalImage.getType());
        Graphics2D g2d = modifiedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.drawImage(originalImage, 0, 0, originalImage.getWidth(), originalImage.getHeight(), null);
        int validBoxCount = 0;
        if (infoList != null && !infoList.isEmpty()) {
            for (Map labelMap : infoList) {
                for (Map.Entry entry : labelMap.entrySet()) {
                    Coordinate coord = (Coordinate)entry.getValue();
                    if (!ImageBoxDrawer.isValidCoord(coord, originalImage.getWidth(), originalImage.getHeight())) continue;
                    g2d.setColor(defaultColor);
                    g2d.setStroke(new BasicStroke(strokeWidth, 1, 1));
                    g2d.drawRect(coord.getLeft(), coord.getTop(), coord.getWidth(), coord.getHeight());
                    ++validBoxCount;
                }
            }
        }
        log.info("\u7ed8\u5236\u5b8c\u6210 - \u6709\u6548\u7ea2\u8272\u6846\u6570\u91cf:{}", (Object)validBoxCount);
        g2d.dispose();
        String outputDirPath = "/Users/macbook/IdeaProjects/ai-check-cloud/ai-check-common/src/main/resources";
        File outputDir = new File(outputDirPath);
        if (!outputDir.exists()) {
            if (outputDir.mkdirs()) {
                log.info("\u6210\u529f\u521b\u5efa\u8f93\u51fa\u76ee\u5f55: {}", (Object)outputDirPath);
            } else {
                throw new IOException("\u65e0\u6cd5\u521b\u5efa\u8f93\u51fa\u76ee\u5f55: " + outputDirPath);
            }
        }
        File outputFile = new File(outputDir, fileName);
        try (InputStream inputStream = ImageBoxDrawer.getInputStreamByBufferedImage(modifiedImage);){
            Files.copy(inputStream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            log.info("\u56fe\u7247\u6210\u529f\u4fdd\u5b58\u5230\u672c\u5730: {}", (Object)outputFile.getAbsolutePath());
            System.out.println(outputFile.getAbsolutePath());
        }
    }
}

