/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ovopark.aicheck.model.obs.DeleteRes;
import com.ovopark.aicheck.model.obs.ObsResult;
import com.ovopark.aicheck.model.obs.UploadRes;
import com.ovopark.aicheck.properties.OssObsProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ObsFileUtils {
    private static final Logger log = LoggerFactory.getLogger(ObsFileUtils.class);
    private static String BIZ_CODE;
    private static String DOMAIN;
    private static String UPLOAD_API;
    private static String DELETE_API;
    private static String ACCESS_API;
    @Resource
    private OssObsProperties obsProperties;

    @PostConstruct
    public void init() {
        BIZ_CODE = this.obsProperties.getBizCode();
        DOMAIN = this.obsProperties.getDomain();
        UPLOAD_API = this.obsProperties.getUploadApi();
        DELETE_API = this.obsProperties.getDeleteApi();
        ACCESS_API = this.obsProperties.getAccessApi();
        log.info("OBS \u521d\u59cb\u8bdd:BIZ_CODE:{},DOMAIN:{},UPLOAD_API:{},DELETE_API{},ACCESS_API:{}", new Object[]{BIZ_CODE, DOMAIN, UPLOAD_API, DELETE_API, ACCESS_API});
    }

    public static String upload(File file, String mac) {
        InputStream inputStream = null;
        try {
            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.info("======\u4e0a\u4f20\u5f02\u5e38\uff0cfile\u9519\u8bef======{}", (Object)e.getMessage());
        }
        if (inputStream != null) {
            return ObsFileUtils.upload(inputStream, file.getName(), mac);
        }
        return "";
    }

    public static String upload(File file, Integer enterpriseId) {
        InputStream inputStream = null;
        try {
            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.info("======\u4e0a\u4f20\u5f02\u5e38\uff0cfile\u9519\u8bef======{}", (Object)e.getMessage());
        }
        if (inputStream != null) {
            return ObsFileUtils.upload(inputStream, file.getName(), enterpriseId);
        }
        return "";
    }

    public static String upload(InputStream inputStream, String fileName, Integer enterpriseId) {
        log.info("======obs\u4e0a\u4f20\u5f00\u59cb========");
        String url = "";
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("businessCode", BIZ_CODE);
            param.put("enterprisePath", String.valueOf(enterpriseId));
            HttpPost request = new HttpPost(DOMAIN + UPLOAD_API);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
            builder.addBinaryBody("file", inputStream, ContentType.DEFAULT_BINARY, fileName);
            for (Map.Entry entry : param.entrySet()) {
                String key = (String)entry.getKey();
                StringBody value = new StringBody((String)entry.getValue(), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
                builder.addPart(key, (ContentBody)value);
            }
            request.setEntity(builder.build());
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            HttpEntity responseEntity = response.getEntity();
            String ret = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity) : null;
            log.info("======obs\u4e0a\u4f20\u8fd4\u56de\uff1a{}", (Object)ret);
            if (StringUtils.isBlank((String)ret)) {
                log.info("======obs\u670d\u52a1\u5f02\u5e38======");
                return url;
            }
            ObsResult obsResult = (ObsResult)JSON.parseObject((String)ret, (TypeReference)new TypeReference<ObsResult<UploadRes>>(){}, (Feature[])new Feature[0]);
            if (obsResult.isError()) {
                log.info("======obs\u4e0a\u4f20\u5931\u8d25======");
                return url;
            }
            url = ((UploadRes)obsResult.getData()).getOssUrl();
            log.info("======obs\u4e0a\u4f20\u6210\u529f======");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("======obs\u4e0a\u4f20\u5f02\u5e38======{}", (Object)e.getMessage());
        }
        return url;
    }

    public static String upload(InputStream inputStream, String fileName, String mac) {
        log.info("======obs\u4e0a\u4f20\u5f00\u59cb========");
        String url = "";
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("businessCode", BIZ_CODE);
            param.put("enterprisePath", mac);
            HttpPost request = new HttpPost(DOMAIN + UPLOAD_API);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
            builder.addBinaryBody("file", inputStream, ContentType.DEFAULT_BINARY, fileName);
            for (Map.Entry entry : param.entrySet()) {
                String key = (String)entry.getKey();
                StringBody value = new StringBody((String)entry.getValue(), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
                builder.addPart(key, (ContentBody)value);
            }
            request.setEntity(builder.build());
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            HttpEntity responseEntity = response.getEntity();
            String ret = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity) : null;
            log.info("======obs\u4e0a\u4f20\u8fd4\u56de\uff1a{}", (Object)ret);
            if (StringUtils.isBlank((String)ret)) {
                log.info("======obs\u670d\u52a1\u5f02\u5e38======");
                return url;
            }
            ObsResult obsResult = (ObsResult)JSON.parseObject((String)ret, (TypeReference)new TypeReference<ObsResult<UploadRes>>(){}, (Feature[])new Feature[0]);
            if (obsResult.isError()) {
                log.info("======obs\u4e0a\u4f20\u5931\u8d25======");
                return url;
            }
            url = ((UploadRes)obsResult.getData()).getOssUrl();
            log.info("======obs\u4e0a\u4f20\u6210\u529f======");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("======obs\u4e0a\u4f20\u5f02\u5e38======{}", (Object)e.getMessage());
        }
        return url;
    }

    public static String extractPureFileName(String imageUrl) {
        if (imageUrl == null || imageUrl.trim().isEmpty()) {
            return "";
        }
        String url = imageUrl.trim();
        int lastSlashIndex = url.lastIndexOf("/");
        int fileNameStartIndex = lastSlashIndex == -1 ? 0 : lastSlashIndex + 1;
        int lastDotIndex = url.lastIndexOf(".");
        int fileNameEndIndex = lastDotIndex == -1 || lastDotIndex < fileNameStartIndex ? url.length() : lastDotIndex;
        String pureFileName = url.substring(fileNameStartIndex, fileNameEndIndex);
        return pureFileName.trim().isEmpty() ? "" : pureFileName;
    }

    public static void delete(String pathUrl) {
        ObsResult obsResult;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fileUrl", pathUrl);
        String ret = HttpRequest.post((String)(DOMAIN + DELETE_API)).body(JSONUtil.toJsonStr(params)).execute().body();
        log.info("======obs\u5220\u9664\u8fd4\u56de\uff1a{}", (Object)ret);
        if (ret != null && !(obsResult = (ObsResult)JSON.parseObject((String)ret, (TypeReference)new TypeReference<ObsResult<DeleteRes>>(){}, (Feature[])new Feature[0])).isError()) {
            DeleteRes uploadRes = (DeleteRes)obsResult.getData();
            log.info("======obs\u5220\u9664\u7ed3\u679c======{}", (Object)uploadRes.getFileState());
        }
    }

    public static String getAccessibleUrl(String ossUrl) {
        try {
            ObsResult obsResult;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("urlList", Arrays.asList(ossUrl));
            params.put("time", 30);
            params.put("timeUnit", 3);
            log.info("======obs\u83b7\u53d6\u53ef\u8bbf\u95eeurl\u53c2\u6570\uff1a{}  DOMAIN:{}", (Object)JSONUtil.toJsonStr(params), (Object)(DOMAIN + ACCESS_API));
            String ret = HttpRequest.post((String)(DOMAIN + ACCESS_API)).body(JSONUtil.toJsonStr(params)).execute().body();
            log.info("======obs\u83b7\u53d6\u53ef\u8bbf\u95eeurl\u8fd4\u56de\uff1a{}", (Object)ret);
            if (ret != null && !(obsResult = (ObsResult)JSON.parseObject((String)ret, (TypeReference)new TypeReference<ObsResult<List<String>>>(){}, (Feature[])new Feature[0])).isError() && obsResult.getData() != null) {
                List accessUrls = (List)obsResult.getData();
                ossUrl = CollectionUtils.isNotEmpty((Collection)accessUrls) ? (String)accessUrls.get(0) : ossUrl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("======obs\u83b7\u53d6\u53ef\u8bbf\u95eeurl\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return ossUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadToLocal(String ossFilePath, String localDir, String picName) {
        String localFilePath = localDir + File.separator + picName;
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            URL url = new URL(ossFilePath);
            URLConnection connection = url.openConnection();
            inputStream = connection.getInputStream();
            outputStream = new FileOutputStream(localFilePath);
            byte[] buffer = new byte[10240];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            String string = localFilePath;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("=====oss -> downloadFromOss\u65b9\u6cd5\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream downloadToInputStream(String ossFilePath) {
        InputStream inputStream = null;
        try {
            URL url = new URL(ossFilePath);
            URLConnection connection = url.openConnection();
            inputStream = connection.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("=====oss -> getOssFileInputStream\u65b9\u6cd5\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return inputStream;
    }

    public static void main(String[] args) throws FileNotFoundException {
        File file = new File("C:\\Users\\yumabing\\Desktop\\AI\\2\\\u6d4b\u8bd5\u56fe\u7247\u4e0a\u4f20.jpg");
        String url = ObsFileUtils.upload(file, "1084");
        System.out.println(url);
    }
}

