/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdPartyImageStreamUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyImageStreamUtil.class);
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECTION_REQUEST_TIMEOUT = 5000;
    private static final CloseableHttpClient HTTP_CLIENT = HttpClients.custom().setDefaultRequestConfig(ThirdPartyImageStreamUtil.buildRequestConfig()).setConnectionTimeToLive(30L, TimeUnit.SECONDS).setMaxConnTotal(200).setMaxConnPerRoute(50).build();

    public static InputStream downloadToStream(String imageUrl) throws Exception {
        if (imageUrl == null || imageUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("\u4e09\u65b9\u56fe\u7247URL\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CloseableHttpResponse httpResponse = null;
        File tempFile = null;
        try {
            tempFile = ThirdPartyImageStreamUtil.downloadToTempFile(imageUrl, httpResponse);
            LOGGER.info("\u4e34\u65f6\u6587\u4ef6\u751f\u6210\u6210\u529f\uff0c\u8def\u5f84\uff1a{}", (Object)tempFile.getAbsolutePath());
            return new AutoDeleteInputStream(new FileInputStream(tempFile), tempFile, httpResponse);
        }
        catch (Exception e) {
            ThirdPartyImageStreamUtil.closeHttpResource(httpResponse);
            ThirdPartyImageStreamUtil.deleteTempFile(tempFile);
            LOGGER.error("\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25\uff0cURL\uff1a{}", (Object)imageUrl, (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File downloadToTempFile(String imageUrl, CloseableHttpResponse httpResponse) throws Exception {
        HttpGet httpGet = new HttpGet(imageUrl);
        httpResponse = HTTP_CLIENT.execute((HttpUriRequest)httpGet);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            throw new IOException(String.format("\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25\uff0c\u54cd\u5e94\u7801\uff1a%d\uff0cURL\uff1a%s", statusCode, imageUrl));
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            throw new IOException(String.format("\u56fe\u7247\u54cd\u5e94\u4f53\u4e3a\u7a7a\uff0cURL\uff1a%s", imageUrl));
        }
        String fileSuffix = ThirdPartyImageStreamUtil.getFileSuffix(imageUrl);
        File tempFile = File.createTempFile("third-party-img-" + UUID.randomUUID(), fileSuffix, null);
        try (InputStream in = httpEntity.getContent();
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, len);
            }
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        }
        return tempFile;
    }

    private static void closeHttpResource(CloseableHttpResponse httpResponse) {
        if (httpResponse != null) {
            try {
                httpResponse.close();
                LOGGER.info("HTTP\u54cd\u5e94\u8d44\u6e90\u5df2\u5173\u95ed");
            }
            catch (IOException e) {
                LOGGER.error("HTTP\u54cd\u5e94\u8d44\u6e90\u5173\u95ed\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static void deleteTempFile(File tempFile) {
        if (tempFile != null && tempFile.exists()) {
            boolean deleted = tempFile.delete();
            if (deleted) {
                LOGGER.info("\u4e34\u65f6\u6587\u4ef6\u5df2\u5220\u9664\uff1a{}", (Object)tempFile.getAbsolutePath());
            } else {
                LOGGER.warn("\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff0c\u5c06\u5728\u7a0b\u5e8f\u9000\u51fa\u65f6\u6e05\u7406\uff1a{}", (Object)tempFile.getAbsolutePath());
                tempFile.deleteOnExit();
            }
        }
    }

    private static String getFileSuffix(String url) {
        String suffix;
        if (url.contains(".") && (suffix = url.substring(url.lastIndexOf("."))).matches("\\.(jpg|jpeg|png|gif|webp|bmp|svg)$")) {
            return suffix;
        }
        return ".jpg";
    }

    private static RequestConfig buildRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).setConnectionRequestTimeout(5000).build();
    }

    public static void main(String[] args) {
        String testImageUrl = "https://example.com/test-image.png";
        try (InputStream inputStream = ThirdPartyImageStreamUtil.downloadToStream(testImageUrl);){
            LOGGER.info("\u83b7\u53d6\u5230\u56fe\u7247InputStream\uff0c\u5f00\u59cb\u4e1a\u52a1\u5904\u7406");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class AutoDeleteInputStream
    extends FilterInputStream {
        private final File tempFile;
        private final CloseableHttpResponse httpResponse;
        private boolean closed = false;

        public AutoDeleteInputStream(InputStream in, File tempFile, CloseableHttpResponse httpResponse) {
            super(in);
            this.tempFile = tempFile;
            this.httpResponse = httpResponse;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                super.close();
            }
            finally {
                ThirdPartyImageStreamUtil.closeHttpResource(this.httpResponse);
                ThirdPartyImageStreamUtil.deleteTempFile(this.tempFile);
                this.closed = true;
            }
        }
    }
}

